PROGRAM txtmorph;
{
  Text Dot Morphing
  - by Bjarke Vikse
  oct 1994

  HOLD down ESCape key to exit!
  This one is by no means optimized. It utilizes screen mode $13 and
  does a few dot and colour transforming too.

  Here is the magic routine:
	 xpos:=x1 SHL 16;
	 xadd:=((x2-x1) SHL 16) DIV (moves);
	 ypos:=y1 SHL 16;
	 yadd:=((y2-y1) SHL 16) DIV (moves);
	 for i:=1 to moves do begin
		writeln(xpos SHR 16,' ',ypos SHR 16);
		inc(xpos,xadd); inc(ypos,yadd);
	 end;
  And use the same stuff to get colour fade. The 4 first lines are
  precalculated in a large buffer and the for-loop is written in asm!
}

{$A+,B-,G+,E+,I+,N-,X+}
{$C PRELOAD FIXED PERMANENT}

USES
	DEMOINIT, ILBM256,PICTURE;

{{$DEFINE DEBUG}

CONST
	YSIZE = 16;

TYPE
	pPictureType = ^PictureType;
	PictureType = array[1..200,1..320] of byte;
	pLongArray = ^LongArray;
	LongArray = array[0..16300] of longint;

VAR
	pix : pScreen;
	precalcarray : pLongArray;
	pixels : word;



(*------------------------------------------------*)

procedure InitDemo;
var
	i : integer;
begin
	ClearWholeScreen;

	New(pix);
	LoadPix(pix,'txtmorph.lbm');
	SetCMAP;

	New(precalcarray);
end;

procedure UninitDemo;
var
	i : integer;
begin
	Dispose(pix);
	Dispose(precalcarray);
end;



(*------------------------------------------------*)

procedure FindNextPoint(pic : pPictureType; VAR x,y : integer; VAR all : boolean);
begin
	repeat
		inc(x);
		if (x>320) then begin
			x:=1;
			inc(y); if (y>YSIZE) then begin y:=1; all:=TRUE; end;
		end;
	until (pic^[y,x]<>0);
end;

procedure CalcNewMorph(ofs1,ofs2 : word; n : integer);
var
	p : word;
	x,y, i,j : integer;
	pic1,pic2 : pPictureType;
	all : boolean;
begin
	inc(n);
	pic1:=Ptr(Seg(pix^),Ofs(pix^)+ofs1);
	pic2:=Ptr(Seg(pix^),Ofs(pix^)+ofs2);
	p:=0; all:=FALSE;
	pixels:=0;

	i:=(1)-1; j:=1;
	FindNextPoint(pic2,i,j,all);

	{find all points in old picture and make slope-calc to a
	 pixel in the new picture for each pixel}
	for x:=320 downto 1 do
		for y:=1 to YSIZE do
			if (pic1^[y,x]<>0) then begin
				{calc colour fade slope}
				precalcarray^[p]:=(longint(pic2^[j,i]-pic1^[y,x]) SHL 16) DIV n;
				precalcarray^[p+1]:=longint(pic1^[y,x]) SHL 16;
				{calc xpos slope}
				precalcarray^[p+2]:=(longint(i-x) SHL 16) DIV n;
				precalcarray^[p+3]:=longint(x) SHL 16;
				{calc ypos slope}
				precalcarray^[p+4]:=(longint(j-y) SHL 16) DIV n;
				precalcarray^[p+5]:=longint(y) SHL 16;
				inc(p,6);
				inc(pixels);
				FindNextPoint(pic2,i,j,all);
			end;

	if (all) then exit;
	{if there are more pixels in new picture, add some more pixels for them...}
	for x:=1 to 320 do
		for y:=1 to YSIZE do
			if (pic1^[y,x]<>0) then begin
				{calc colour fade slope}
				precalcarray^[p]:=(longint(pic2^[j,i]-pic1^[y,x]) SHL 16) DIV n;
				precalcarray^[p+1]:=longint(pic1^[y,x]) SHL 16;
				{calc xpos slope}
				precalcarray^[p+2]:=(longint(i-x) SHL 16) DIV n;
				precalcarray^[p+3]:=longint(x) SHL 16;
				{calc ypos slope}
				precalcarray^[p+4]:=(longint(j-y) SHL 16) DIV n;
				precalcarray^[p+5]:=longint(y) SHL 16;
				inc(p,6);
				inc(pixels);
				FindNextPoint(pic2,i,j,all);
				if (all) then exit;
			end;
end;


(*------------------------------------------------*)

procedure ClearScreen;
begin
	FillChar(Ptr(SEGA000,(80*320))^,YSIZE*320,#0);
end;

procedure MakeDots; assembler;
asm
	push	ds

	mov	es,SEGA000
	mov	cx,pixels
	lds	si,precalcarray
	cld
@loop:
	lodsw					{add to colour}
	mov	dx,ax
	lodsw
	add	[si],dx
	adc	[si+2],ax
	add	si,2
	lodsw					{get colour}
	push	ax				{remember it for a while}

	lodsw					{add to xpos}
	mov	dx,ax
	lodsw
	add	[si],dx
	adc	[si+2],ax
	add	si,2
	lodsw					{get xpos}
	push	ax				{remember it for a while}

	lodsw					{add to ypos}
	mov	dx,ax
	lodsw
	add	[si],dx
	adc	[si+2],ax
	add	si,2
	lodsw					{get ypos}
	xchg	al,ah
	mov	bx,ax
	shr	bx,2
	add	bx,ax
	pop	ax				{get xpos}
	add	bx,ax
	add	bx,80*320	{add screen offset}
	pop	ax				{get colour}
	mov	[es:bx],al	{put pixel}

	loop	@loop

	pop	ds
end;


(*------------------------------------------------*)

procedure RunOnce;
begin
	if keypressed then exit;
	VBLANK;
{$IFDEF DEBUG}	SetRGB(0,20,0,0); {$ENDIF}
	ClearScreen;
	MakeDots;
{$IFDEF DEBUG}	SetRGB(0,0,0,0); {$ENDIF}
end;

procedure Wait(offs : word);
begin
	if keypressed then exit;
	VBLANK;
	Move(Ptr(Seg(pix^),Ofs(pix^)+offs)^,Ptr(SEGA000,80*320)^,16*320);
end;


var
	i : integer;
begin
	SetScreenMode($13);
	InitDemo;

	while not keypressed do begin
		CalcNewMorph(0,YSIZE*320,80);
		for i:=1 to 80 do RunOnce;
		for i:=1 to 40 do Wait(YSIZE*320);
		CalcNewMorph(YSIZE*320,2*YSIZE*320,80);
		for i:=1 to 80 do RunOnce;
		for i:=1 to 40 do Wait(2*YSIZE*320);
		CalcNewMorph(2*YSIZE*320,0,80);
		for i:=1 to 80 do RunOnce;
		for i:=1 to 40 do Wait(0);
	end;

	UninitDemo;
	SetScreenMode(TEXTMODE);
end.
