PROGRAM MANDELBROT;
{
  Mandelbrot 1
  - by Bjarke Vikse
  aug 1994
  Math co-processer will speed things dramatically...
}

{$A+,B-,G+,E+,I+,N+,X+}
{$C FIXED PRELOAD PERMANENT}

USES
	DEMOINIT;

{{$DEFINE DEBUG}

(*------------------------------------------------*)

procedure InitDemo;
var
	i : integer;
begin
	ClearWholeScreen;
	for i:=0 to 15 do setRGB(16-i, i,i*3,i*3);
end;

procedure UninitDemo;
var
	i : integer;
begin
end;

(*------------------------------------------------*)

procedure PaintMandelbrot;
var
	u,v : integer;
	rl,rh,il,ih : real;
	x,y,xx,yy,dx,dy : real;
	r,i,s : real;
	n,nmax : word;
begin
	rl:=-2; {lowest r-value}
	rh:=0.5;  {highest r-value}
	il:=-1.5; {lowest i-value}
	ih:=1.5;  {highest i-value}
	nmax:=12;  {number of iterations}

	dx:=(rh-rl) / 160;
	dy:=(ih-il) / 100;
	yy:=il-dy;

	for u:=0 to 99 do begin
		yy:=yy+dy;
		xx:=rl-dx;
		for v:=0 to 159 do begin
			xx:=xx+dx;
			n:=0; r:=0.0; i:=0.0; s:=0.0;
			repeat
				x:=r;
				y:=i;
				r:=sqr(x) - sqr(y) + xx;
				i:=2.0*x*y + yy;
				s:=sqr(r) + sqr(i);
				inc(n);
			until (n=nmax) OR (s>4.0);
			if (n=nmax) then SetPixel(0,v,u,0) else SetPixel(0,v,u,n);
		end;
	end;
end;


begin
	OpenScreen;
	InitDemo;
	PaintMandelbrot;
	while NOT Keypressed do ;
	UninitDemo;
	CloseScreen;
end.
