(****************************************************)
(*   Programming:  Bob Dalton                       *)
(*   Demonstration Program for using Turbo Vision   *)
(*    as a game configuration and setup program     *)
(*    for BBS Doors                                 *)
(****************************************************)
{This unit sets up the individual dialogs and actions which happen
 for your program.  In the below examples I use nothing but radio
 buttons because I feel they are the best for an editor or game
 configuration program. What are radio buttons?  It means only
 ONE button can be selected at anyone time among the choices given}

unit SDialogs;

interface

Uses WorldVar;

{To be called by the program they must be listed here}

function HowManySoldiers: Word;
function HowManyTanks: Word;
function HowMuchMoney: Word;
function HowManyGenerals: Word;

implementation

uses Dialogs,   {has TDialog}
     Objects,   {has TRect}
     Views,     {has ofXXXXX constants}
     App;       {has Desktop global variable}

{The below function sets up the Turbo Vision dialog and then
 performs an action when the button choice is made}
function HowManySoldiers: Word;
var R    : TRect;
    PDlg : PDialog;
    RB   : PRadioButtons;
    AMask: LongInt;
    Scope: LongInt;

 Begin
   R.Assign(17, 1, 57, 16); {Overall size of dialog box}
   {The next line center the text "Maximum Players" between
    the lines at the top of the dialog box}
   PDlg := New(Pdialog, Init(R,'How Many Soldiers?'));
   with PDlg^ do
   begin
    R.Assign(5, 1, 35, 11); {Size of the radio button box}
    RB := New(PRadioButtons, Init(R,
    NewSItem('100',
    NewSItem('150',
    NewSItem('200',
    NewSItem('250',
    NewSItem('300',
    NewSItem('350',
    NewSItem('400',
    NewSItem('450',
    NewSItem('500',
    NewSItem('550',
    nil))))))))))));
    Insert(RB);
    {The next line presets one of the buttons - "0" = First button}
    RB^.Press(3);
    {The next line sets "AMASK" to how many buttons choices there are}
    AMask:=Rb^.EnableMask;
    {The next line is quite handy in that if registered=false then
     the buttons will be greyed out and the user will only be able
     to view them and NOT make any changes}
    IF Registered=False then RB^.SetButtonState(Amask,False);
    R.Assign(7, 12, 19, 14); {Sets button size for next two items}
    Insert(New(PButton, Init(R, 'O~k~', cmOk, bfDefault)));
    R.Move(14, 0);
    Insert(New(PButton, Init(R, '~C~ancel', cmCancel, 0)));
    SelectNext(False);
   end;
  HowManySoldiers := Desktop^.ExecView(PDlg);
  {The next item is also very hand as it gets the number of whatever
   radio button is currently pushed and equates it to "SCOPE". One
   thing to remember though is that button numbers start with zero (0)}
  RB^.GetData(Scope);
  Case Scope of
   0: Glob.soldiers:=100; {If button 0 is pushed then this value is assigned to the record variable}
   1: Glob.soldiers:=150;
   2: Glob.soldiers:=200;
   3: Glob.soldiers:=250;
   4: Glob.soldiers:=300;
   5: Glob.soldiers:=350;
   6: Glob.soldiers:=400;
   7: Glob.soldiers:=450;
   8: Glob.soldiers:=500;
   9: Glob.soldiers:=550;
  End;
  Dispose(PDlg, Done); {Don't forget to do this!}

 End;


function HowManyTanks: Word;
var R    : TRect;
    PDlg : PDialog;
    RB   : PRadioButtons;
    AMask: LongInt;
    Scope: LongInt;

 Begin
   R.Assign(17, 1, 57, 16);
   PDlg := New(Pdialog, Init(R,'How Many Tanks?'));
   with PDlg^ do
   begin
    R.Assign(5, 1, 35, 11);
    RB := New(PRadioButtons, Init(R,
    NewSItem('1',
    NewSItem('2',
    NewSItem('3',
    NewSItem('4',
    NewSItem('5',
    NewSItem('6',
    NewSItem('7',
    NewSItem('8',
    NewSItem('9',
    NewSItem('10',
    nil))))))))))));
    Insert(RB);
    RB^.Press(2);
    AMask:=Rb^.EnableMask;
    IF Registered=False then RB^.SetButtonState(Amask,False);
    R.Assign(7, 12, 19, 14);
    Insert(New(PButton, Init(R, 'O~k~', cmOk, bfDefault)));
    R.Move(14, 0);
    Insert(New(PButton, Init(R, '~C~ancel', cmCancel, 0)));
    SelectNext(False);
   end;
  HowManyTanks := Desktop^.ExecView(PDlg);
  RB^.GetData(Scope);           {Get Value from Radio Buttons}
  Case Scope of
   0: Glob.Tanks:=1;
   1: Glob.Tanks:=2;
   2: Glob.Tanks:=3;
   3: Glob.Tanks:=4;
   4: Glob.Tanks:=5;
   5: Glob.Tanks:=6;
   6: Glob.Tanks:=7;
   7: Glob.Tanks:=8;
   8: Glob.Tanks:=9;
   9: Glob.Tanks:=10;
  End;
  Dispose(PDlg, Done);
End;

function HowMuchMoney: Word;
var R    : TRect;
    PDlg : PDialog;
    RB   : PRadioButtons;
    AMask: LongInt;
    Scope: LongInt;

 Begin
   R.Assign(17, 1, 57, 16);
   PDlg := New(Pdialog, Init(R,'How Much Money?'));
   with PDlg^ do
   begin
    R.Assign(5, 1, 35, 11);
    RB := New(PRadioButtons, Init(R,
    NewSItem('$500',
    NewSItem('$1000',
    NewSItem('$1500',
    NewSItem('$2000',
    NewSItem('$2500',
    NewSItem('$3000',
    NewSItem('$3500',
    NewSItem('$4000',
    NewSItem('$4500',
    NewSItem('$5000',
    nil))))))))))));
    Insert(RB);
    RB^.Press(3);
    AMask:=Rb^.EnableMask;
    IF Registered=False then RB^.SetButtonState(Amask,False);
    R.Assign(7, 12, 19, 14);
    Insert(New(PButton, Init(R, 'O~k~', cmOk, bfDefault)));
    R.Move(14, 0);
    Insert(New(PButton, Init(R, '~C~ancel', cmCancel, 0)));
    SelectNext(False);
   end;
  HowMuchMoney := Desktop^.ExecView(PDlg);
  RB^.GetData(Scope);           {Get Value from Radio Buttons}
  Case Scope of
   0: Glob.Money:=500;
   1: Glob.Money:=1000;
   2: Glob.Money:=1500;
   3: Glob.Money:=2000;
   4: Glob.Money:=2500;
   5: Glob.Money:=3000;
   6: Glob.Money:=3500;
   7: Glob.Money:=4000;
   8: Glob.Money:=4500;
   9: Glob.Money:=5000;
  End;
  Dispose(PDlg, Done);
End;


function HowManyGenerals: Word;
var R    : TRect;
    PDlg : PDialog;
    RB   : PRadioButtons;
    AMask: LongInt;
    Scope: LongInt;

 Begin
   R.Assign(17, 1, 57, 16);
   PDlg := New(Pdialog, Init(R,'How Many Generals?'));
   with PDlg^ do
   begin
    R.Assign(5, 1, 35, 11);
    RB := New(PRadioButtons, Init(R,
    NewSItem('1',
    NewSItem('2',
    NewSItem('3',
    NewSItem('4',
    NewSItem('5',
    NewSItem('6',
    NewSItem('7',
    NewSItem('8',
    NewSItem('9',
    NewSItem('10',
    nil))))))))))));
    Insert(RB);
    RB^.Press(0);
    AMask:=Rb^.EnableMask;
    IF Registered=False then RB^.SetButtonState(Amask,False);
    R.Assign(7, 12, 19, 14);
    Insert(New(PButton, Init(R, 'O~k~', cmOk, bfDefault)));
    R.Move(14, 0);
    Insert(New(PButton, Init(R, '~C~ancel', cmCancel, 0)));
    SelectNext(False);
   end;
  HowManyGenerals := Desktop^.ExecView(PDlg);
  RB^.GetData(Scope);           {Get Value from Radio Buttons}
  Case Scope of
   0: Glob.Generals:=1;
   1: Glob.Generals:=2;
   2: Glob.Generals:=3;
   3: Glob.Generals:=4;
   4: Glob.Generals:=5;
   5: Glob.Generals:=6;
   6: Glob.Generals:=7;
   7: Glob.Generals:=8;
   8: Glob.Generals:=9;
   9: Glob.Generals:=10;
  End;
  Dispose(PDlg, Done);
End;

End.