PROGRAM MouseTest;

{ *******************************************************************
    this program is a demo of the mouse routines for AzzaMouse v1.0
  ******************************************************************* }

USES Mouse, Graph;

PROCEDURE SetUp1024x768Mode;
VAR
  Gm, Gd : INTEGER;

BEGIN
  Gd := InstallUserDriver( 'SVGA256', NIL );
  Gm := 4;

  InitGraph( Gd, Gm, '' );

  IF GraphResult <> grOk
    THEN halt;
END;

{ -------------------------------------------------------------------- }

PROCEDURE Close1024x768Mode;
BEGIN
  CloseGraph;
END;

VAR
  s1, s2, st : STRING;

BEGIN
  WriteLn('AzzaMouse v1.0 - mouse test demo program.');
  WriteLn;
  WriteLn('press [ENTER] to continue.');
  ReadLn;

  IF MouseExist
    THEN BEGIN
           SetUp1024x768Mode;
           InitMouseDriver;

           SetFillStyle( SolidFill, Black );
           Bar( 0, 0, GetMaxX, GetMaxY );

           SetColor( LightRed );
           SetTextStyle( DefaultFONT, HorizDir, 3 );
           OutTextXY( 290, 20, 'MOUSE TEST PROGRAM' );

           SetColor( White );
           Rectangle( 0, 0, GetMaxX, GetMaxY );
           Rectangle( ( GetMaxX shr 1 ) - round(( GetMaxX shr 2 ) * 1.5 ) - 1,
                      ( GetMaxY shr 1 ) - round(( GetMaxY shr 2 ) * 1.5 ) - 1,
                      ( GetMaxX shr 1 ) + round(( GetMaxX shr 2 ) * 1.5 ) + 1,
                      ( GetMaxY shr 1 ) + round(( GetMaxY shr 2 ) * 1.5 ) + 1);

           SetMinMax( Horz,
                      ( GetMaxX shr 1 ) - round(( GetMaxX shr 2 ) * 1.5 ),
                      ( GetMaxX shr 1 ) + round(( GetMaxX shr 2 ) * 1.5 ));
           SetMinMax( Vert,
                      ( GetMaxY shr 1 ) - round(( GetMaxY shr 2 ) * 1.5 ),
                      ( GetMaxY shr 1 ) + round(( GetMaxY shr 2 ) * 1.5 ));
           ShowMouse;

           SetTextStyle( DefaultFONT, HorizDir, 2 );
           SetColor( Yellow );
           REPEAT
             ASM CLI; END;

             IF MouseData.Moved
               THEN BEGIN
                      SetFillStyle( SolidFill, Black );
                      Bar( 430, 70, 430 + ( 10 * 16 ), 70 + 16 );
                      Str( MouseData.x:4, s1 );
                      Str( MouseData.y:3, s2 );
                      OutTextXY( 430, 70, '(' + s1 + ',' + s2 + ')' );
                    END;
             MouseData.Moved := FALSE;

             ASM STI; END;
           UNTIL MouseData.bmask = 3;

           KillMouseDriver;
           Close1024x768Mode;
         END
    ELSE WriteLn( 'ERROR :- mouse driver not installed, cannot continue.');
END.