{ 

  This code is Copyright (c) 1994 by Jonathan E. Wright and AmoebaSoft.

  To communicate with the author, send internet mail to: NELNO@DELPHI.COM

  About this code:
    written for Turbo Assembler and links with NEWCRT.PAS.

   }

.286

DATA    SEGMENT WORD PUBLIC USE16

        public  KeyPrsd, RKey, NewInt9

        EXTRN   KeyFlags  : BYTE;
        EXTRN   KeyBuff   : BYTE;
        EXTRN   KeyBuffOn : BYTE;

        EXTRN   KeyHead   : WORD;
        EXTRN   KeyTail   : WORD;
        EXTRN   KeyChange : BYTE;

        EXTRN   KeyTran   : BYTE;
        EXTRN   ShiftTran : BYTE;
        EXTRN   KillFlag  : BYTE;
        EXTRN   IOCount   : WORD;

        EXTRN   Quit      : BYTE;

DATA    ENDS

CODE    SEGMENT WORD PUBLIC USE16
        ASSUME  CS:CODE,DS:DATA

; ͻ
;                                                                        
;  returns true if a key is in the buffer, false if not                  
;  always returns false if the buffer is not active                      
;                                                                        
; ͼ }

KeyPrsd PROC    FAR

        push    bp
        mov     bp,sp

	xor     ax,ax
        cmp     al,KeyBuffOn
        je      ENDKeyPrsd

	mov     bx,KeyTail
	cmp     bx,KeyHead
	je      ENDKeyPrsd

	mov     ax,1

ENDKeyPrsd:
        mov     sp,bp
        pop     bp

	ret

KeyPrsd ENDP

;ͻ
;                                                                       
; Returns first key in buffer and updates head and tail pointers        
; returns 0 if KeyBuffOn = 0                                            
;                                                                       
;ͼ }

RKey    PROC    FAR

        push    bp
        mov     bp,sp

	xor     ax,ax
	cmp     KeyBuffOn,0
	je      ENDRKey

WaitForKey:
	mov     bx,KeyTail
	cmp     bx,KeyHead
        je      WaitForKey

	cli
	mov     bx,KeyTail
	mov     al,[bx]
	inc     bx

	cmp     bx,OFFSET KeyBuff+255
	jne     NoWrap
        mov     bx,OFFSET KeyBuff

NoWrap:
        cmp     bx,KeyHead
	jne     KeysLeft

	mov     KeyChange,0

KeysLeft:
        mov     KeyTail,bx

ENDRKey:
        sti
	xor     ah,ah

        mov     sp,bp
        pop     bp

	ret

RKey    ENDP

;ͻ
;                                                                       
; reads a key from the keyboard and modifies the KeyFlags table.  If    
; KeyBuffOn <> 0 then the key is also placed in KeyBuff.  Up to 255     
; keys can be placed in the buffer.                                     
;                                                                       
; Flags table is set as follows:  the high bit of the flag is set to    
; 1 if the key is pressed and set to 0 when it is released.  The low    
; bit is set to 1 if it is pressed and unchanged when it is released    
;                                                                       
;ͼ }

NewInt9 PROC    FAR

        push    ax
        push    bx
        push    cx
        push    dx
        push    es
	push    di
        push    ds
        push    si
        pushf

	mov     ax,DATA
	mov     ds,ax

        mov     cx,IOCount

IODelayLoop2:
        loop    IODelayLoop2

        in      al,60h
        mov     bx,ax

;        mov     ax,bx
        and     bx,007Fh

	test    al,10000000b       ; Check if key was Released
	jnz     KeyReleased

	mov     byte ptr [OFFSET KeyFlags+BX],10000000b

	cmp     KeyBuffOn,0        ; is the buffer on?
	je      ENDNewInt9

        mov     di,KeyHead
	cmp     di,OFFSET KeyBuff+255
        jne     HeadNot255

        cmp     KeyTail,OFFSET KeyBuff
	jne     TailNot0
        jmp     ENDNewInt9

HeadNot255:
        inc     di

        cmp     KeyTail,di
	je      ENDNewInt9

	dec     di

TailNot0:
        cmp     byte ptr [OFFSET KeyFlags+2Ah],080h
        je      Shift
        cmp     byte ptr [OFFSET KeyFlags+36h],080h
        je      Shift

        cmp     byte ptr [OFFSET KeyFlags+38h],080h
        jne     NoShift

        cmp     bl,2Dh              ; Alt-X pressed?
        jne     NoShift             ; if no then jump

        mov     Quit,1              ; store TRUE in Quit
        jmp     ENDNewInt9

Shift:
        mov     bl,byte ptr [OFFSET ShiftTran+BX]
        jmp     Check0

NoShift:
        mov     bl,byte ptr [OFFSET KeyTran+BX]

Check0:
        cmp     bl,0
        je      ENDNewInt9

        cmp     KeyBuffOn,2
        jne     StoreBuff

        test    bl,10000000b       ; is this a function key or
        jnz     ENDNewInt9         ; keypad key?

StoreBuff:
        mov     [di],bl            ; Put key in buffer
	inc     KeyHead
	cmp     KeyHead,OFFSET KeyBuff+255
	jne     ENDNewInt9
	mov     KeyHead,OFFSET KeyBuff
	jmp     ENDNewInt9

KeyReleased:
        mov     byte ptr ds:[OFFSET KeyFlags+BX],00000000b

ENDNewInt9:
        mov     KeyChange,1

	mov     al,20h             ; send EOI
 	out     20h,al

        popf
        pop     si
	pop     ds
	pop     di
        pop     es
        pop     dx
        pop     cx
	pop     bx
	pop     ax

        iret

NewInt9 ENDP

CODE    ENDS

        END