               .MODEL         LARGE,PASCAL
               .386

               INCLUDE        XLIB.INC

CSEG           SEGMENT PARA PUBLIC USE16 'CODE'
               ASSUME CS:CSEG, DS:DSEG

;Function to calculate linear address from segment address on stack.
;Returns linear address in EAX and DX:AX.
LINADR         PROC FAR PUBLIC,
               SEGADR:DWORD                  ;Segment address of variable
               XOR            EAX,EAX        ;Clear high words
               XOR            EDX,EDX
               MOV            AX,WORD PTR SEGADR[2]
               MOV            DX,WORD PTR SEGADR[0]
               SHL            EAX,4         ;Calculate linear address
               ADD            EAX,EDX
               MOV            EDX,EAX
               SHR            EDX,16         ;Return linear address in DX:AX
               RET
LINADR         ENDP

;Structure defining control block for SUMARRAY.
ARRAYDATA      STRUCT
  CONDCODE     DWORD          0              ;Condition code
  N            DWORD          0              ;Number of elements to sum
  ADDRESS      DWORD          0              ;Address of first element
  SUM          DWORD          0              ;Sum of array elements
ARRAYDATA      ENDS

;Real-mode interface to SUMARRAY32.  Segment address of control block having
;structure ARRAYDATA should be on the stack.
SUMARRAY       PROC FAR PUBLIC,
               CBSEGADR:DWORD                ;Control block segment address
               MOV            EAX,CBSEGADR   ;Will convert to linear address
               PUSH           EAX
               CALL           LINADR         ;Will use linear address in EAX
               PUSHD          OFFSET SUMARRAY32
               CALL           ENTERPM        ;Execute SUMARRAY32 in protected
               RET
SUMARRAY       ENDP

CSEG           ENDS

TSEG           SEGMENT PARA PUBLIC USE32 'CODE'
               ASSUME CS:TSEG, SS:TSEG, DS:TSEG, ES:TSEG, FS:DSEG, GS:DGROUP

;Sum the elements of a single precision array.  Array parameters are stored
;in a control block having structure of ARRAYDATA.  The linear address of the
;control block is contained in EAX.  An error code of -1 is returned in the
;condition code of the control block if the number of array elements is zero.
;Observe that this routine will be called with DS = FLATDSEL (flat-model data
;descriptor).
SUMARRAY32     PROC NEAR
               MOV            EDX,ARRAYDATA.ADDRESS[EAX]    ;Get array address
               MOV            ESI,ARRAYDATA.N[EAX]          ;Get N
               SUB            ESI,1
               JB             NODATA                        ;Error:  N = 0
               FLDZ                                         ;Initialize sum
SUMLOOP:       FADD           DWORD PTR [EDX+4*ESI]
               SUB            ESI,1
               JAE            SUMLOOP
               FSTP           ARRAYDATA.SUM[EAX]            ;Save sum
               RET
NODATA:        MOV            ARRAYDATA.CONDCODE[EAX],-1    ;Record error code
               RET
SUMARRAY32     ENDP

TSEG           ENDS
               END
