
; *****************************************
;
;               Swallow v1.0
;
;   (c) 1995 by Topical Software
;
;   contains
;    - public data structures
;    - public constants
;
;  you can use them by include this
;  file into your assembler file
;
;
; *****************************************


false                   equ 0
true                    equ 1


;
; number of all kernel functions
;

knf_NoCheck             equ 8000h

knf_AllocLD             equ 0
knf_FreeLD              equ 1
knf_Seg2Selector        equ 2
knf_GetSegBase          equ 3
knf_SetSegBase          equ 4
knf_SetSegSize          equ 5
knf_SetDesRights        equ 6
knf_SetWholeDes         equ 7
knf_AllocInitLD         equ 8
knf_AllocAliasLD        equ 9

knf_AllocDosMem         equ 100h
knf_FreeDosMem          equ 101h
knf_ResizeDosMem        equ 102h

knf_GetLinearMemInfo    equ 200h
knf_AllocLinearMem      equ 201h
knf_FreeLinearMem       equ 202h
knf_ResizeLinearMem     equ 203h
knf_LockLinearMem       equ 204h
knf_UnlockLinearMem     equ 205h
knf_DiscardLinearMem    equ 206h
knf_CommitLinearMem     equ 207h
knf_UncommitLinearMem   equ 208h

knf_GetWatchedMemInfo   equ 300h
knf_GetWatchedLockedMemInfo equ 301h
knf_AllocWatchedMem     equ 302h
knf_FreeWatchedMem      equ 303h
knf_ResizeWatchedMem    equ 304h
knf_LockWatchedMem      equ 305h
knf_UnlockWatchedMem    equ 306h

knf_GetUnwatchedMemInfo equ 400h
knf_AllocUnwatchedMem   equ 401h
knf_FreeUnwatchedMem    equ 402h

knf_AllocCallBack       equ 500h
knf_ReleaseCallBack     equ 501h
knf_GetProtIntVec       equ 502h
knf_SetProtIntVec       equ 503h
knf_XchgProtIntVec      equ 504h
knf_GetUserIRQ          equ 505h
knf_SetUserIRQ          equ 506h
knf_XchgUserIRQ         equ 507h
knf_GetUserExc          equ 508h
knf_SetUserExc          equ 509h
knf_XchgUserExc         equ 50ah
knf_CallV86Int          equ 50bh
knf_CallV86Proc         equ 50ch
knf_CallV86IRet         equ 50dh

knf_AllocDMABuffer      equ 600h
knf_ReleaseDMABuffer    equ 601h

knf_UseBaseMem          equ 700h
knf_ShrinkMem           equ 701h
knf_Terminate           equ 702h
knf_InitSwapFile        equ 703h
knf_SetBreakCheck       equ 704h
knf_GetSelName          equ 705h
knf_SetSelName          equ 706h
knf_GetPhysAddr         equ 707h



;
; structures of parameters of system functions
;

;
; parameter structure of es:edx for calling a V86-Mode interrupt handler
; the registers will be stored into this structure after execution
;

_par_V86Int     struc
_par_V86Int_ds  dw   ?          ; V86-Mode segment registers
_par_V86Int_es  dw   ?
_par_V86Int_fs  dw   ?
_par_V86Int_gs  dw   ?
_par_V86Int_ax  equ  this word  ; left common use registers
_par_V86Int_al  equ  this byte
_par_V86Int_ah  equ  this byte + 1
_par_V86Int_eax dd   ?
_par_V86Int_dx  equ  this word
_par_V86Int_dl  equ  this byte
_par_V86Int_dh  equ  this byte + 1
_par_V86Int_edx dd   ?
_par_V86Int_int dd   ?          ; interrupt no. (only lowbyte regarded)
_par_V86Int     ends


;
; parameter structure of es:edx for calling a V86-Mode procedure
; the registers will be stored into this structure after execution
;

_par_V86Proc    struc
_par_V86Proc_ds dw   ?          ; V86-Mode segment registers
_par_V86Proc_es dw   ?
_par_V86Proc_fs dw   ?
_par_V86Proc_gs dw   ?
_par_V86Proc_ax equ  this word  ; left common use registers
_par_V86Proc_al equ  this byte
_par_V86Proc_ah equ  this byte + 1
_par_V86Proc_eax dd  ?
_par_V86Proc_dx equ  this word
_par_V86Proc_dl equ  this byte
_par_V86Proc_dh equ  this byte + 1
_par_V86Proc_edx dd  ?
_par_V86Proc_Addr dd ?          ; target address
_par_V86Proc     ends


;
; stack structure passed to an software interrupt handler
;
; the stack is always 16 bit for compatibility
; so your handler have to return via "iret"
; (even a 32 bit one)
;

_sta_int        struc
_sta_int_ip     dw   ?                  ; pointer to following instr.
_sta_int_cs     dw   ?
_sta_int_fl     dw   ?
_sta_int        ends


;
; stack structure passed to an user exception handler
;
; The program can be continuoued by "iretd"
; (even if your handler is 16 bit)
; Then the kernel will return to the address _sta_uxc_cs:_sta_uxc_eip
;
; The original handler has to be called by a far jump after restoring stack
; The standard handler terminate the program with an error message
;

_sta_uxc        struc
_sta_uxc_keip   dd   ?                  ; return address to kernel
_sta_uxc_kcs    dw   ?
		dw   ?
_sta_uxc_kefl   dd   ?
_sta_uxc_code   dd   ?                  ; error code
_sta_uxc_eip    dd   ?                  ; flags & addr. of interrupted code
_sta_uxc_cs     dw   ?
		dw   ?
_sta_uxc_efl    dd   ?
_sta_uxc_esp    dd   ?                  ; pointer to stack of interrupted code
_sta_uxc_ss     dw   ?
		dw   ?
_sta_uxc        ends

