
/*******************************************************


	      Swallow Borland C Adapter v1.0


    (c) 1995 by Topical Software

    All functions declared by this header are
    defined by the start-up code of Swallow.

    If you set command line option "/Real" the
    Real Mode emulator of Swallow will be loaded
    to emulate Swallow for debug purposes.

    If your debugger has problems with the emulator
    you can define "__NOSWALLOW" and include
    "Swallow.C" into your project. (If you remove
    the option "__NOSWALLOW" you can leave "Swallow.C"
    within your project but have to recompile it).
    Then no part of Swallow will be loaded and any
    debugger should work well.

 *******************************************************/


#ifndef __SWALLOW_H
#define __SWALLOW_H


// constants of Swallow functions, for assembler use only
#define knf_AllocLD             0
#define knf_FreeLD              1
#define knf_Seg2Selector        2
#define knf_GetSegBase          3
#define knf_SetSegBase          4
#define knf_SetSegSize          5
#define knf_SetDesRights        6
#define knf_SetWholeDes         7
#define knf_AllocInitLD         8
#define knf_AllocAliasLD        9

#define knf_AllocDosMem         0x100
#define knf_FreeDosMem          0x101
#define knf_ResizeDosMem        0x102

#define knf_GetLinearMemInfo    0x200
#define knf_AllocLinearMem      0x201
#define knf_FreeLinearMem       0x202
#define knf_ResizeLinearMem     0x203
#define knf_LockLinearMem       0x204
#define knf_UnlockLinearMem     0x205
#define knf_DiscardLinearMem    0x206

#define knf_GetGlobalMemInfo    0x300
#define knf_GetGlobalLockedMemInfo 0x301
#define knf_AllocGlobalMem      0x302
#define knf_FreeGlobalMem       0x303
#define knf_ResizeGlobalMem     0x304
#define knf_LockGlobalMem       0x305
#define knf_UnlockGlobalMem     0x306

#define knf_GetLocalMemInfo     0x400
#define knf_AllocLocalMem       0x401
#define knf_FreeLocalMem        0x402

#define knf_AllocCallBack       0x500
#define knf_ReleaseCallBack     0x501
#define knf_GetProtIntVec       0x502
#define knf_SetProtIntVec       0x503
#define knf_XchgProtIntVec      0x504
#define knf_GetUserIRQ          0x505
#define knf_SetUserIRQ          0x506
#define knf_XchgUserIRQ         0x507
#define knf_GetUserExc          0x508
#define knf_SetUserExc          0x509
#define knf_XchgUserExc         0x50a
#define knf_CallV86Int          0x50b
#define knf_CallV86Proc         0x50c
#define knf_CallV86IRet         0x50d

#define knf_AllocDMABuffer      0x600
#define knf_ReleaseDMABuffer    0x601

#define knf_UseBaseMem          0x700
#define knf_ShrinkMem           0x701
#define knf_Terminate           0x702
#define knf_InitSwapFile        0x703
#define knf_SetBreakCheck	0x704
#define knf_GetSelName          0x705
#define knf_SetSelName          0x706
#define knf_GetPhysAddr         0x707

#define knf_NoCheck		0x8000

// possible values of SwallowIsActive
#define swa_inactive	0
#define swa_protected	1
#define swa_emulated	2

// read only state flag of swallow, it contains one of the above
// listed values
extern int SwallowIsActive;

// selectors of most important segments
extern int Seg0040;
extern int SegA000;
extern int SegB000;
extern int SegB800;

#ifdef __cplusplus
extern "C" {
#endif

void *GetLockedMem(int Size);
void InitSwapFile(int Drive, long int LeftSpace);
void far * Seg2Sel(int Segment);
int SetBreakCheck(int CheckBreak);
void ShrinkMem(long int LeftSpace);
void UseBaseMem(void);
int UseUnwatchedMem(int UseIt);

#ifdef __cplusplus
}
#endif

#endif