/*
** SCSI Tape Control (Low Level)
**
** usage: mt [-e|r|l|n|s count|m count]
**
** Revision History:
**
** Version 1.0  09/09/90 Initial Release
**
*/
#include <stdio.h>
#include <fcntl.h>
#include <dos.h>

#define TRUE (1)
#define FALSE (0)
#define VERSION "mt Version 1.0 BWA"

extern int _doserrno;

struct cmd {
	short command;		/* command type */
	short arg1;			/* command args */
	short arg2;			/* command args */
} ioctl_data;
union REGS inregs, outregs;
struct SREGS segregs;
int fd;
char *device = "SCSITAPE", *operation = NULL;
char far *cp;

main(argc, argv)
int argc;
char *argv[];
{
	/*
	** say hello
	*/
	puts(VERSION);
	switch ( argc )
	{
		case 3:
		if (argv[1][0] != '-' || argv[1][2] != 0) usage();
		switch( argv[1][1] )
		{
			case 's':
			ioctl_data.command = 'S';
			ioctl_data.arg1 = atoi(argv[2]);
			ioctl_data.arg2 = 1;		/* space by filemark */
			if (ioctl_data.arg1 > 0)
				operation = "space forward";
			else if (ioctl_data.arg1 < 0)
				operation = "space backward";
			else
			{
				operation = "space EOD";
				ioctl_data.arg2 = 3;	/* space to EOD */
			}
			break;

			case 'm':
			ioctl_data.command = 'M';
			ioctl_data.arg1 = atoi(argv[2]);
			operation = "filemark";
			break;

			default:
			usage();
			break;
		}
		break;

		case 2:
		if (argv[1][0] != '-' || argv[1][2] != 0) usage();
		switch( argv[1][1] )
		{
			case 'e':
			/*
			** verify that this is what the user really wants to do
			*/
			printf("Do you really wish to erase the tape\n");
			printf("contained in the SCSITAPE unit (y,n)? ");
			fflush(stdout);
			if ( getchar() != 'y' )
			{
				printf("Aborting ....\n");
				exit(1);
			}
			operation = "erase";
			ioctl_data.command = 'E';
			break;

			case 'r':
			operation = "rewind";
			ioctl_data.command = 'R';
			break;

			case 'l':
			operation = "load enable";
			ioctl_data.command = 'L';
			break;

			case 'n':
			operation = "load disable";
			ioctl_data.command = 'N';
			break;

			default:
			usage();
			break;
		}
		break;

		default:
		usage();
		break;
	}

	/*
	** put together the command
	*/
	fd = open(device, O_WRONLY);
	if ( fd < 0 )
	{
		perror(device);
		exit(1);
	}
	inregs.h.ah = 0x44;			/* ioctl */
	inregs.h.al = 0x03;			/* write */
	inregs.x.bx = fd;			/* unit */
	inregs.x.cx = sizeof(struct cmd);
	cp = (char *) &ioctl_data;
	inregs.x.dx = FP_OFF(cp);
	segregs.ds = FP_SEG(cp);

	/*
	** start the format
	*/
	printf("Now performing %s command ....\n", operation);
	puts("Please wait ....");
	intdosx(&inregs, &outregs, &segregs);

	/*
	** see what happened
	*/
	if ( outregs.x.cflag )
		printf("DOS error %d occured during %s.\n", _doserrno, operation);
	close(fd);
	exit(0);
}

usage()
{
	puts("usage: mt [-e|r|l|n|s count|m count]");
	exit(1);
}
