;
; Data storage for local subroutines
;
cmd_ready	db	SCSI_TESTREADY,0,0,0,0,0
cmd_rewind	db	SCSI_REWIND,0,0,0,0,0
cmd_sense	db	SCSI_REQSENSE,0,0,0,size sense,0
cmd_format	db	SCSI_FORMATUNIT,0,0,0,0,0
cmd_space	db	SCSI_SPACE,1,0,0,0,0
		if extended_io
cmd_read	db	SCSI_READBLK,0,0,0,0,0,0,0,1,0
cmd_write	db	SCSI_WRITEBLK,0,0,0,0,0,0,0,1,0
		else
cmd_read	db	SCSI_READBLK,0,0,0,1,0
cmd_write	db	SCSI_WRITEBLK,0,0,0,1,0
		endif
cmd_tread	db	SCSI_READBLK,1,0,0,0,0
cmd_twrite	db	SCSI_WRITEBLK,1,0,0,0,0
cmd_twritefm	db	SCSI_WRITEFM,0,0,0,1,0
cmd_inquire	db	SCSI_INQUIRY,0,0,0,size inq,0
cmd_erase	db	SCSI_ERASE,1,0,0,0,0
cmd_load	db	SCSI_LOAD,0,0,0,0,0
cmd_capacity	db	SCSI_READSIZE,0,0,0,0,0,0,0,0,0
cmd_verify	db	SCSI_VERIFYBLK,0,0,0,0,0,0,0,SECT_TRACK,0

		even
docmd_cmd	dw	?
docmd_buf	dw	?
docmd_buf_seg	dw	?
docmd_len	dw	?
docmd_status	db	?
docmd_tempb	db	?

		if dump_sense
sense_msg	db	0dh,07h,'SCSI Unit: 0x'
sense_unit	db	'xx, Sense Status: 0x'
sense_code	db	'xx, Block Address: 0x'
		if extended_sense
sense_addr3	db	'xx'
		endif
sense_addr2	db	'xx'
sense_addr1	db	'xx'
sense_addr0	db	'xx',0dh,0ah,'$'
		endif

;
; Reset the SCSI Bus
;
scsi_reset	proc	near
		pusha

		mov	ax,SCSI_CARD_SEG	;Point at the command port
		mov	es,ax
		mov	si,SCSI_CMD_PORT

		mov	al,CMDBASE or CMDENABLE or CMDRST
		mov	es:[si],al		;Reset the bus
		call	wait1ms
		mov	al,CMDBASE
		mov	es:[si],al		;All done
		mov	cx,250			;Wait 250ms
reset_loop:	call	wait1ms
		loop	reset_loop

		popa
		ret
scsi_reset	endp

;
; Test the Ready Status of a unit
;
; al = return code, 'C' error
;
scsi_ready	proc	near
		lea	di,cmd_ready			;Command
		call	docmd
		ret
scsi_ready	endp

;
; Request Sense data from a unit and display the result
; Called after every SCSI command with the exit code in 'al'
;
scsi_sense	proc	near
		pushf
		pusha
		mov	di,cur_unit			;Unit
		lea	bx,[di].unit_sense_buf		;Buffer Offset
		push	ds				;Buffer Segment
		pop	es
		mov	cx,size sense			;Buffer Size
		lea	di,cmd_sense			;Command
		call	docmd
		if dump_sense
		jc	sense_exit
		mov	di,cur_unit
		mov	dl,[di].unit_select
		if reserve_addr
		and	dl,07Fh			;Remove Cards Bit
		endif
		lea	bx,sense_unit		;Unit
		call	hex2asc2
		mov	dl,[di].unit_sense_buf.sense_sense
		lea	bx,sense_code		;Sense
		call	hex2asc2
		if extended_sense
		mov	dl,[di].unit_sense_buf.sense_lba_b3
		lea	bx,sense_addr3		;Address
		call	hex2asc2
		endif
		mov	dl,[di].unit_sense_buf.sense_lba_b2
		lea	bx,sense_addr2
		call	hex2asc2
		mov	dl,[di].unit_sense_buf.sense_lba_b1
		lea	bx,sense_addr1
		call	hex2asc2
		mov	dl,[di].unit_sense_buf.sense_lba_b0
		lea	bx,sense_addr0
		call	hex2asc2
		lea	dx,sense_msg
		call	puts
		endif
sense_exit:	popa
		popf
		ret
scsi_sense	endp

;
; Inquire about the type of a unit
;
; al = return code, 'C' error indicates an error
;
scsi_inquire	proc	near
		push	cx
		mov	di,cur_unit			;Unit
		lea	bx,[di].unit_sense_buf		;Buffer Offset
		push	ds				;Buffer Segment
		pop	es
		mov	cx,size sense			;Buffer Size
		lea	di,cmd_sense			;Command
		call	docmd				;Always ask first
		jc	inquire_exit
		mov	di,cur_unit			;Unit
		lea	bx,[di].unit_inq_buf		;Buffer Offset
		push	ds				;Buffer Segment
		pop	es
		mov	cx,size inq			;Buffer Size
		lea	di,cmd_inquire			;Command
		call	docmd
		jnc	inquire_exit
		call	scsi_sense
inquire_exit:	pop	cx
		ret
scsi_inquire	endp

;
; Determine the size of a disk
;
; al = return code, 'C' error indicates an error
;
scsi_capacity	proc	near
		push	cx
		mov	di,cur_unit			;Unit
		lea	bx,[di].unit_cap_buf		;Buffer Offset
		push	ds				;Buffer Segment
		pop	es
		mov	cx,size cap			;Buffer Size
		lea	di,cmd_capacity			;Command
		call	docmd
		jnc	capacity_exit
		call	scsi_sense
capacity_exit:	pop	cx
		ret
scsi_capacity	endp

;
; Verify the Track given in an IOCTL Request
;
; al = return code, 'C' indicates an error
;
scsi_verify	proc	near
		mov	di,es:[bx].rh19_buf_ofs		;Command Offset
		mov	ax,es:[bx].rh19_buf_seg		;Command Segment
		mov	es,ax
		mov	ax,es:[di].ioctl_fmt_cyl	;Track
		shl	ax,SECT_2_CYL			;Convert to Sector

		mov	di,cur_bpb			;Add to Drive Offset
		mov	dx,[di].bpb_hs_msw

		lea	di,cmd_verify			;Command
		mov	[di].ver_cmd_lba_b3,dh		;Insert Sector
		mov	[di].ver_cmd_lba_b2,dl		; into Command
		mov	[di].ver_cmd_lba_b1,ah		;Insert Sector
		mov	[di].ver_cmd_lba_b0,al		; into Command
		call	docmd
		jnc	verify_exit
		call	scsi_sense
verify_exit:	ret
scsi_verify	endp

;
; Read Some Blocks from the disk given
; the request header in es:bx
;
; al = return code, 'C' indicates an error
;
disk_read	proc	near
		mov	di,bx
		mov	cx,es:[di].rh4_count		;Sector Count
		mov	dx,es:[di].rh4_start		;Starting Sector
		mov	bx,es:[di].rh4_buf_ofs		;Buffer Offset
		mov	ax,es:[di].rh4_buf_seg		;Buffer Segment
		mov	es,ax

		mov	si,cur_bpb
		lea	di,cmd_read			;Command
		mov	ax,[si].bpb_hs_msw		;Drive Sector Offset
		if extended_io
		mov	[di].io_cmd_lba_b3,ah		;Insert Sector
		endif
		mov	[di].io_cmd_lba_b2,al		;Into the Command

		if multi_sector
		mov	ax,cx				;Get Sector Count
		and	ax,CHUNK_MAX-1			;Mask Off the I/O Chunk
		jnz	disk_r_cok1			;Check for Boundary
		mov	ax,CHUNK_MAX
disk_r_cok1:	shl	ax,9				;Convert to Buffer Size
		add	ax,bx				;Check for Wrap
		else
		mov	ax,bx				;Check for Wrap
		add	ax,P_SECT			;The First Time
		endif
disk_r_loop:	jnc	disk_r_nowrap
		mov	ax,bx				;Normalize the
		shr	ax,4				;Segment and
		mov	si,es				;Offset so that
		add	si,ax				;It dosn't Wrap
		mov	es,si
		and	bx,000Fh
disk_r_nowrap:	push	cx
		mov	[di].io_cmd_lba_b1,dh		;Insert Sector
		mov	[di].io_cmd_lba_b0,dl		;Into the Command
		if multi_sector
		and	cx,CHUNK_MAX-1			;Mask Off the I/O Chunk
		jnz	disk_r_cok2			;Check for Boundary
		mov	cx,CHUNK_MAX
disk_r_cok2:
		if extended_io
		mov	[di].io_cmd_cnt_b1,ch		;Insert Sector Count
		endif
		mov	[di].io_cmd_cnt_b0,cl		;Into the Command
		shl	cx,9				;Convert to Buffer Size
		else
		mov	cx,P_SECT			;Buffer Size
		endif
		call	docmd
		pop	cx
		jc	disk_r_exit
		if multi_sector
		mov	ax,cx				;Get Sector Count
		and	ax,CHUNK_MAX-1			;Mask Off the I/O Chunk
		jnz	disk_r_cok3			;Check for Boundary
		mov	ax,CHUNK_MAX
disk_r_cok3:	sub	cx,ax				;Dec Sector Count
		jz	disk_r_exit
		add	dx,ax				;Bump to next Sector
		shl	ax,9				;Convert to Buffer Size
		add	bx,ax
		jmp	short disk_r_loop
		else
		inc	dx				;Bump to next Sector
		add	bx,P_SECT
		loop	disk_r_loop
		clc
		endif
disk_r_exit:	jnc	disk_r_exit2			;If no error occured
		call	scsi_sense			;Display Sense Status
disk_r_exit2:	mov	es,rh_seg
		mov	bx,rh_off
		pushf
		mov	ax,es:[bx].rh4_count		;Update the Count
		sub	ax,cx
		mov	es:[bx].rh4_count,ax
		popf
		ret
disk_read	endp

;
; Write Some Blocks to the disk given
; the request header in es:bx
;
; al = return code, 'C' indicates an error
;
disk_write	proc	near
		mov	di,bx
		mov	cx,es:[di].rh8_count		;Sector Count
		mov	dx,es:[di].rh8_start		;Starting Sector
		mov	bx,es:[di].rh8_buf_ofs		;Buffer Offset
		mov	ax,es:[di].rh8_buf_seg		;Buffer Segment
		mov	es,ax

		mov	si,cur_bpb
		lea	di,cmd_write			;Command
		mov	ax,[si].bpb_hs_msw		;Drive Sector Offset
		if extended_io
		mov	[di].io_cmd_lba_b3,ah		;Insert Sector
		endif
		mov	[di].io_cmd_lba_b2,al		;Into the Command

		if multi_sector
		mov	ax,cx				;Get Sector Count
		and	ax,CHUNK_MAX-1			;Mask Off the I/O Chunk
		jnz	disk_w_cok1			;Check for Boundary
		mov	ax,CHUNK_MAX
disk_w_cok1:	shl	ax,9				;Convert to Buffer Size
		add	ax,bx				;Check for Wrap
		else
		mov	ax,bx				;Check for Wrap
		add	ax,P_SECT			;The First Time
		endif
disk_w_loop:	jnc	disk_w_nowrap
		mov	ax,bx				;Normalize the
		shr	ax,4				;Segment and
		mov	si,es				;Offset so that
		add	si,ax				;It dosn't Wrap
		mov	es,si
		and	bx,000Fh
disk_w_nowrap:	push	cx
		mov	[di].io_cmd_lba_b1,dh		;Insert Sector
		mov	[di].io_cmd_lba_b0,dl		;Into the Command
		if multi_sector
		and	cx,CHUNK_MAX-1			;Mask Off the I/O Chunk
		jnz	disk_w_cok2			;Check for Boundary
		mov	cx,CHUNK_MAX
disk_w_cok2:
		if extended_io
		mov	[di].io_cmd_cnt_b1,ch		;Insert Sector Count
		endif
		mov	[di].io_cmd_cnt_b0,cl		;Into the Command
		shl	cx,9				;Convert to Buffer Size
		else
		mov	cx,P_SECT			;Buffer Size
		endif
		call	docmd
		pop	cx
		jc	disk_w_exit
		if multi_sector
		mov	ax,cx				;Get Sector Count
		and	ax,CHUNK_MAX-1			;Mask Off the I/O Chunk
		jnz	disk_w_cok3			;Check for Boundary
		mov	ax,CHUNK_MAX
disk_w_cok3:	sub	cx,ax				;Dec Sector Count
		jz	disk_w_exit
		add	dx,ax				;Bump to next Sector
		shl	ax,9				;Convert to Buffer Size
		add	bx,ax
		jmp	short disk_w_loop
		else
		inc	dx				;Bump to next Sector
		add	bx,P_SECT
		loop	disk_w_loop
		clc
		endif
disk_w_exit:	jnc	disk_w_exit2			;If no error occured
		call	scsi_sense			;Display Sense Status
disk_w_exit2:	mov	es,rh_seg
		mov	bx,rh_off
		pushf
		mov	ax,es:[bx].rh8_count		;Update the Count
		sub	ax,cx
		mov	es:[bx].rh8_count,ax
		popf
		ret
disk_write	endp

;
; Read Some Blocks from the Tape
;
tape_read	proc	near
		mov	write_flag,FALSE		;Cancel if READ seen
		mov	di,bx
		mov	cx,es:[di].rh4_count		;Byte Count
		mov	ax,cx				;Test for invalid
		and	ax,P_SECT-1			;Byte Count
		jz	tape_r_ok
		mov	es:[di].rh4_count,0		;Nothing Read
		stc					;Oops
		ret
tape_r_ok:	mov	bx,es:[di].rh4_buf_ofs		;Buffer Offset
		mov	ax,es:[di].rh4_buf_seg		;Buffer Segment
		mov	es,ax
		mov	ax,bx				;Normalize the
		shr	ax,4				;Segment and
		mov	si,es				;Offset so that
		add	si,ax				;It dosn't Wrap
		mov	es,si
		and	bx,000Fh
		lea	di,cmd_tread
		mov	ax,cx				;Convert Bytes
		shr	ax,9				;to Blocks
		mov	[di].tio_cmd_cnt_b1,ah		;Insert into Command
		mov	[di].tio_cmd_cnt_b0,al
		call	docmd
		jnc	tape_r_exit
		call	scsi_sense
tape_r_exit:	ret
tape_read	endp

;
; Write Some Blocks to the Tape
;
tape_write	proc	near
		mov	write_flag,TRUE			;Write Done
		mov	di,bx
		mov	cx,es:[di].rh8_count		;Byte Count
		mov	ax,cx				;Test for invalid
		and	ax,P_SECT-1			;Byte Count
		jz	tape_w_ok
		mov	es:[di].rh8_count,0		;Nothing Write
		mov	write_flag,FALSE		;Cancel if ERROR!
		stc					;Oops
		ret
tape_w_ok:	mov	cx,es:[di].rh8_count		;Byte Count
		mov	bx,es:[di].rh8_buf_ofs		;Buffer Offset
		mov	ax,es:[di].rh8_buf_seg		;Buffer Segment
		mov	es,ax
		mov	ax,bx				;Normalize the
		shr	ax,4				;Segment and
		mov	si,es				;Offset so that
		add	si,ax				;It dosn't Wrap
		mov	es,si
		and	bx,000Fh
		lea	di,cmd_twrite
		mov	ax,cx				;Convert Bytes
		shr	ax,9				;to Blocks
		mov	[di].tio_cmd_cnt_b1,ah		;Insert into Command
		mov	[di].tio_cmd_cnt_b0,al
		call	docmd
		jnc	tape_w_exit
		mov	write_flag,FALSE		;Cancel if ERROR!
		call	scsi_sense
tape_w_exit:	ret
tape_write	endp

;
; Do a command
;
; bx => buffer for returned information
; cx = buffer len
; di => command string
; es = buffer segment for returned information
;
; al = return code, 'C' indicates an error
;
docmd		proc	near
		pusha
		push	es

		mov	docmd_buf,bx		;Save our arguments
		mov	docmd_buf_seg,es
		mov	docmd_len,cx
		mov	docmd_cmd,di

		mov	ax,SCSI_CARD_SEG	;Point at the Card
		mov	es,ax
		mov	si,SCSI_CMD_PORT	;Command Port

;
; Wait for the Bus to become free
;
		mov	cx,65535
idle_loop:	mov	al,es:[si]		;Get the Status
		and	al,FREE_MASK
		jz	try_sel
		loop	idle_loop

		call	scsi_reset
		mov	al,CBUSBUSY		;Bus still BUSY?
		jmp	docmd_exit

try_sel:	mov	al,CMDBASE		;Try to select target
		mov	es:[si],al

		mov	di,cur_unit
		mov	al,[di].unit_select	;Get our Select Bit
		mov	di,SCSI_DATA_PORT	;Data Port
		mov	es:[di],al

		call	wait100us		;Spec says wait 90us here
		mov	al,CMDBASE or CMDENABLE or CMDSEL
		mov	es:[si],al

;
; Wait 250 ms for the Target to be SELected
;
		mov	cx,2500
sel_loop:	test	byte ptr es:[si],STBSY	;Look for BSY bit
		jnz	cmd_xfer
		call	wait100us
		loop	sel_loop

		mov	al,CMDBASE or CMDSEL	;Release the data BUS
		mov	es:[si],al
		call	wait100us		;Spec says wait 290us
		call	wait100us		;to abort selection phase
		call	wait100us
		test	byte ptr es:[si],STBSY	;Look one final time
		jnz	cmd_xfer		;Device did answer
		mov	al,CNOCONNECT		;Nothing Answered
		jmp	docmd_exit

;
; Start the Command
;
cmd_xfer:	call	wait100us		;Spec say wait 90us here
		mov	al,CMDBASE or CMDENABLE	;Drop SEL and begin talking
		mov	es:[si],al
xfer_loop:	mov	al,es:[si]
		test	al,STBSY		;Look for BSY bit
		jz	xfer_error
		test	al,STREQ		;And REQ bit
		jz	xfer_loop

		and	al,REQ_MASK		;Look at REQ type

		cmp	al,REQ_DATAOUT		;Is it Data Out?
		jnz	try_datain
		call	send_data
		jmp	short xfer_loop

try_datain:	cmp	al,REQ_DATAIN		;Is it Data In?
		jnz	try_cmdout
		call	receive_data
		jmp	short xfer_loop

try_cmdout:	cmp	al,REQ_CMDOUT		;Is it Command Out?
		jnz	try_statin
		call	send_cmd
		jmp	short xfer_loop

try_statin:	cmp	al,REQ_STATIN		;Is it Status In?
		jnz	try_msgout
		mov	al,es:[di]		;Get the Status Byte
		mov	docmd_status,al
		jmp	short xfer_loop

try_msgout:	cmp	al,REQ_MSGOUT		;Is it Message Out?
		jnz	try_msgin
		call	send_nop
		jmp	short xfer_loop

try_msgin:	cmp	al,REQ_MSGIN		;Is it Message In?
		jnz	xfer_error

		mov	al,es:[di]		;Get Message Byte
		cmp	al,MSG_COMPLETE		;Are We All Done?
		jnz	short xfer_loop
		mov	al,docmd_status
		or	al,al			;Did we have an error?
		mov	al,COK			;Preload OK code
		jz	docmd_exit

xfer_error:	mov	al,CERROR		;Command Failed Somehow

docmd_exit:	mov	docmd_tempb,al
		mov	al,CMDBASE		;Release the BUS
		mov	es:[si],al
		pop	es
		popa
		mov	al,docmd_tempb
		cmp	al,COK
		jz	docmd_exit_ok
		stc
docmd_exit_ok:	ret
docmd		endp

;
; Receive a Data Stream from the card
; On entry es:[di] points at the data port
;          es:[si] points at the command port
;
receive_data	proc	near
		mov	dx,es			;Save ES

		mov	bx,si
		mov	ax,es
		mov	cx,docmd_len		;Length
		mov	di,docmd_buf		;Dest Offset
		mov	es,docmd_buf_seg	;Dest Segment
		mov	si,SCSI_DATA_PORT	;Source Offset
		mov	ds,ax			;Source Segment
		mov	al,STREQ
		mov	ah,STBSY
		cld

receive_loop:	movsb
		if multi_sector
		dec	si			;Don't blow the card buffer
		endif
		dec	cx
		jz	receive_exit
receive_wait:	test	byte ptr [bx],al	;Ready?
		jnz	receive_loop
		test	byte ptr [bx],ah	;Busy?
		jz	receive_exit
		jmp	short receive_wait

receive_exit:	mov	si,SCSI_CMD_PORT	;Restore the Environment
		mov	di,SCSI_DATA_PORT
		mov	ax,cs
		mov	ds,ax
		mov	es,dx
		ret
receive_data	endp

;
; Send a Command to the card
; On entry es:[di] points at the data port
;          es:[si] points at the command port
;
send_cmd	proc	near
		mov	bx,docmd_cmd		;Get Command Pointer
		mov	al,[bx]			;Get a Command Byte
		mov	es:[di],al		;Send it to Card
		inc	bx			;Bump for Next Time
		mov	docmd_cmd,bx
		ret
send_cmd	endp

;
; Send a Data Stream to the card
; On entry es:[di] points at the data port
;          es:[si] points at the command port
;
send_data	proc	near
		mov	bx,si
		mov	cx,docmd_len		;Get the Data Count
		mov	si,docmd_buf		;Source Offset
		mov	ds,docmd_buf_seg	;Source Segment
		mov	al,STREQ
		mov	ah,STBSY
		cld

send_loop:	movsb
		if multi_sector
		dec	di			;Don't blow the card buffer
		endif
		dec	cx
		jz	send_exit
send_wait:	test	byte ptr es:[bx],al	;Ready?
		jnz	send_loop
		test	byte ptr es:[bx],ah	;Busy?
		jz	send_exit
		jmp	short send_wait

send_exit:	mov	si,SCSI_CMD_PORT	;Restore the Environment
		mov	di,SCSI_DATA_PORT
		mov	ax,cs
		mov	ds,ax
		ret
send_data	endp

;
; Send a NOP Message
;
send_nop	proc	near
		mov	al,MSG_NOP		;Oops, send a nop
		mov	es:[di],al
		mov	al,CMDBASE or CMDENABLE
		mov	es:[si],al
		ret
send_nop	endp

;
; Wait One Milli second
;
; The value of 'cx' is computed for an 8 Mhz Clock
;
wait1ms		proc	near
		push	cx		;   (3) = 375ns
		mov	cx,798		;   (2) = 250ns
wait_m_loop:	loop	wait_m_loop	;  (10) = 1250ns * X
		pop	cx		;   (5) = 625ns
		ret			; (11+) = 1375ns
wait1ms		endp

;
; Wait One Hundred Micros Seconds
;
; The value of 'cx' is computed for an 8 Mhz Clock
;
wait100us	proc	near
		push	cx		;   (3) = 375ns
		mov	cx,78		;   (2) = 250ns
wait_u_loop:	loop	wait_u_loop	;  (10) = 1250ns * X
		pop	cx		;   (5) = 625ns
		ret			; (11+) = 1375ns
wait100us	endp
