;
; Process an ioctl request for the current unit
;
; return 'C' on error
;
scsi_ioctl	proc
		mov	al,es:[bx].rh19_minor		;Get the minor number

		cmp	al,40h				;Set Device Params?
		jnz	scsi_i_42h
		clc
		jmp	short scsi_i_exit

scsi_i_42h:	cmp	al,42h				;Format and Verify?
		jnz	scsi_i_60h
		call	scsi_verify
		jmp	short scsi_i_exit

scsi_i_60h:	cmp	al,60h				;Get Device Params?
		jnz	scsi_i_62h
		mov	si,cur_bpb			;Get the Current BPB
		mov	di,es:[bx].rh19_buf_ofs		;Get the Param Buffer
		mov	ax,es:[bx].rh19_buf_seg
		mov	es,ax
		mov	es:[di].dpb_special,05h		;Sect Same/Use Cur BPB
		mov	es:[di].dpb_type,05h		;Fixed Disk
		mov	es:[di].dpb_attr,0001h		;Not Removable
		mov	ax,[si].bpb_ts
		shr	ax,SECT_2_CYL			;Convert Sect to Cyl
		mov	es:[di].dpb_cyl,ax
		mov	es:[di].dpb_media,0		;????
		mov	es:[di].dpb_sectors,SECT_TRACK	;Sectors per Track

		push	di
		lea	di,es:[di].dpb_bpb		;Copy the bpb into
		mov	cx,size bpb			;the requestors buffer
		cld
	rep	movsb
		pop	di

		lea	di,es:[di].dpb_track		;Build the Track List
		mov	cx,SECT_TRACK
		mov	ax,0				;Start with Sector 0
scsi_i_t_loop:	mov	es:[di],ax			;Sector Number
		inc	ax
		inc	di
		inc	di
		mov	word ptr es:[di],P_SECT		;Sector Size
		inc	di
		inc	di
		loop	scsi_i_t_loop
		clc
		jmp	short scsi_i_exit

scsi_i_62h:	cmp	al,62h				;Verify?
		jnz	scsi_i_error
		call	scsi_verify
		jmp	short scsi_i_exit

scsi_i_error:	stc
scsi_i_exit:	ret
scsi_ioctl	endp

;
; Process an ioctl_write request
;
scsi_ioctl_write proc
		mov	di,es:[bx].rh12_buf_ofs		;Get The Command
		mov	ax,es:[bx].rh12_buf_seg		;Buffer
		mov	es,ax
		mov	ax,es:[di].ioc_command		;What Command

;
; Format Disk Unit
;
		cmp	al,'F'				;Format?
		jnz	try_erase
		mov	ax,es:[di].ioc_param1		;Get Interleave
		lea	di,cmd_format			;Insert into Command
		mov	[di].fmt_cmd_il_b1,ah
		mov	[di].fmt_cmd_il_b0,al
		call	docmd
		jnc	format_exit
		call	scsi_sense
format_exit:	jmp	scsi_i_w_exit

;
; Erase Tape Unit
;
try_erase:	cmp	al,'E'				;Erase?
		jnz	try_rewind
		lea	di,cmd_erase			;Now Erase Tape
		call	docmd
		jnc	scsi_i_w_exit
		call	scsi_sense
		jmp	scsi_i_w_error

;
; Rewind Tape Unit
;
try_rewind:	cmp	al,'R'				;Rewind?
		jnz	try_load
		lea	di,cmd_rewind			;Now Rewind Tape
		call	docmd
		jnc	scsi_i_w_exit
		call	scsi_sense
		jmp	scsi_i_w_error

;
; Load Tape on Open
;
try_load:	cmp	al,'L'				;Load?
		jnz	try_noload
		mov	load_flag,TRUE
		jmp	scsi_i_w_exit

;
; No Load Tape on Open
;
try_noload:	cmp	al,'N'				;No Load?
		jnz	try_space
		mov	load_flag,FALSE
		jmp	scsi_i_w_exit

;
; Space Tape
;
try_space:	cmp	al,'S'				;Space?
		jnz	try_filemark
		mov	ax,es:[di].ioc_param1		;Get Count
		mov	bx,es:[di].ioc_param2		;Get Type
		lea	di,cmd_space			;Insert into Command
		mov	[di].space_cmd_code,bl
		mov	[di].space_cmd_cnt2,ah		;Dup of ah
		mov	[di].space_cmd_cnt1,ah
		mov	[di].space_cmd_cnt0,al
		call	docmd
		jnc	scsi_i_w_exit
		call	scsi_sense
		jmp	scsi_i_w_exit

;
; Write Filemarks
;
try_filemark:	cmp	al,'M'				;Mark?
		jnz	scsi_i_w_error
		mov	ax,es:[di].ioc_param1		;Get Count
		lea	di,cmd_twritefm			;Insert into Command
		mov	[di].fm_cmd_cnt_b1,ah
		mov	[di].fm_cmd_cnt_b0,al
		call	docmd
		jnc	scsi_i_w_exit
		call	scsi_sense
		jmp	scsi_i_w_exit

scsi_i_w_error:	stc
scsi_i_w_exit:	ret
scsi_ioctl_write endp
