/*
 * xpalette.s - low level palette setting routines
 *
 * DESCRIPTION
 * Routines to set either full (256 color) or partial palettes
 *
 * USAGE
 *
 * NOTES
 * Based on code from VGL 2.0 by Mark Morley.
 *
 * REVISION HISTORY
 * Date         Reason
 * 27 Jun 95    Initial Release
 *
 */

        .text
        .globl  _x_set_palette
        .globl  _x_set_part_palette
        .globl  _x_set_palette_noVR
        .globl  _x_set_part_palette_noVR

/**************************************************************/
/* x_set_palette(char * palette); sets all 256 palette entries  */
/**************************************************************/
_x_set_palette:
        pushl   %ebp
        movl    %esp, %ebp
        pushl   %esi
        pushl   %eax
        pushl   %ecx
        pushl   %edx

        movl    8(%ebp), %esi
        cli
        movb    $0, %al         /* Start at entry 0 */
        movw    $0x3c8, %dx
        outb    %al, %dx

        movw    $0x3da, %dx
SPWaitnoVRA:
        inb     %dx, %al
        testb   $0x08, %al
        jnz     SPWaitnoVRA
SPWaitVRA:
        inb     %dx, %al
        testb   $0x08, %al
        jz      SPWaitVRA

        movl    $0x300, %ecx    /* does all 768 entries at once */
        movw    $0x3c9, %dx
        cli
SPOutColorA:
        movb    (%esi), %al
        outb    %al, %dx
        inc     %esi
        dec     %ecx
        jnz     SPOutColorA
        
        sti

        popl    %edx
        popl    %ecx
        popl    %eax
        popl    %esi
        popl    %ebp
        ret

/**************************************************************************/
/* _x_set_part_palette(int start_color, int num_colors, char * palette);      */
/*    Sets num_colors entries starting at start_color - done in one shot  */
/**************************************************************************/
_x_set_part_palette:
        pushl   %ebp
        movl    %esp, %ebp
        pushl   %esi
        pushl   %eax
        pushl   %ecx
        pushl   %edx

        movl    16(%ebp), %esi
        movl    12(%ebp), %ecx
        imull   $3, %ecx             /* 3 entries / color */
        
        movl    8(%ebp), %eax        /* Starting entry */
        movw    $0x3c8, %dx
        outb    %al, %dx
        
/* Wait for retrace */
        movw    $0x3da, %dx
SPPWaitnoVRA:
        inb     %dx, %al
        testb   $0x08, %al
        jnz     SPPWaitnoVRA
SPPWaitVRA:
        inb     %dx, %al
        testb   $0x08, %al
        jz      SPPWaitVRA

        movw    $0x3c9, %dx
        cli
SPPColorLoop:
        movb    (%esi), %al
        outb    %al, %dx
        incl    %esi
        decl    %ecx
        jnz     SPPColorLoop

        sti

        popl    %edx
        popl    %ecx
        popl    %eax
        popl    %esi
        popl    %ebp
        ret

/* Same as x_set_palette() except doesn't wait for retrace.
** For use with VR timing module. (Doing all 256 entries
** might be too slow)
*/
_x_set_palette_noVR:
        pushl   %ebp
        movl    %esp, %ebp
        pushl   %esi
        pushl   %eax
        pushl   %ecx
        pushl   %edx

        movl    8(%ebp), %esi
        movb    $0, %al         /* Start at entry 0 */
        movw    $0x3c8, %dx
        outb    %al, %dx

        movl    $0x300, %ecx    /* does all 768 entries at once */
        movw    $0x3c9, %dx
        cli
SPVROutColorA:
        movb    (%esi), %al
        outb    %al, %dx
        inc     %esi
        dec     %ecx
        jnz     SPVROutColorA
        
        sti

        popl    %edx
        popl    %ecx
        popl    %eax
        popl    %esi
        popl    %ebp
        ret


/* Same as x_set_part_palette() with no wait for retrace.
** For use with VR timer, good for rotating small parts
** of palette, etc.
*/
_x_set_part_palette_noVR:
        pushl   %ebp
        movl    %esp, %ebp
        pushl   %esi
        pushl   %eax
        pushl   %ecx
        pushl   %edx

        movl    16(%ebp), %esi
        movw    12(%ebp), %ecx
        imul    $3, %ecx             /* 3 entries / color */
        
        movl    8(%ebp), %eax        /* Starting entry */
        movl    $0x3c8, %dx
        outb    %al, %dx

        movw    $0x3c9, %dx
        cli
SPPVRColorLoop:
        movb    (%esi), %al
        outb    %al, %dx
        incl    %esi
        decl    %ecx
        jnz     SPPVRColorLoop

        sti

        popl    %edx
        popl    %ecx
        popl    %eax
        popl    %esi
        popl    %ebp
        ret
