/*
 * xbitmap.c - bitmap conversion and manipulation functions
 *
 * DESCRIPTION
 *
 * USAGE
 *
 * NOTES
 * Parts based on xlib60 for BC by Themie Goumas
 *
 * REVISION HISTORY
 * Date         Reason
 * 27 Jun 95    Initial Release
 *  3 Aug 95    Changed bitmap w and h to words
 *
 */

#include "defines.h"
#include "xlib.h"

/*************************************************
** Convert linear to planar bitmap - assumes
** memory has been allocated
*************************************************/
void x_BM_to_PBM(BYTE * linear, BYTE * planar)
{
  int i, j, k;

  i = linear[0] + (linear[1] << 8);
  planar[0] = (i >> 2) & 0xff;
  planar[1] = i >> 10;

  j = linear[2] + (linear[3] << 8);
  planar[2] = j & 0xff;
  planar[3] = j >> 8;

  i = (i * j) >> 2;

  for (k=0; k<i; k++)
  {  
    planar[k+4] = linear[(k<<2)+4];
    planar[k+i+4] = linear[(k<<2)+5];
    planar[k+(2*i)+4] = linear[(k<<2)+6];
    planar[k+(3*i)+4] = linear[(k<<2)+7];
  }
}


/*********************************************************
** Convert planar bitmap to RLE encoded format (use for
** masked bitmaps).  Returns size of RLE data used.
** Requires pre-allocation of memory for RLE bitmap - use
** XSizeofRLE() to determine memory requirements.
*********************************************************/
int x_PBM_to_RLE(BYTE * pbm, BYTE * rle, int ScreenByteWidth)
{
  int i, j;
  int zerocount = 0;            /* # pixels to skip */
  int rlecount = 0;             /* sizeof rle array */
  int rowcount = 0;             /* # pixels processed in this row */
  int width = (int)pbm[0] + (int)(pbm[1] << 8);
  int height = (int)pbm[2]+ (int)(pbm[3] << 8);
  int rowincr = ScreenByteWidth - width;
  
  for (i=0; i<4; i++)   /* plane loop */
  {
    for (j=0; j<(height * width); j++)
    {
      rowcount ++;
      if (zerocount)  /* currently counting 0 bytes */
      {
        if(pbm[i*height*width + j + 4] != 0)  /* finish zero run */
        {
          rle[rlecount] = (char)zerocount;
          rle[rlecount+1] = pbm[i*height*width + j + 4];
          rlecount += 2;
          zerocount = 0;
        }
        else
        {
          if (zerocount < 255)
          {
            zerocount ++;
          }
          else
          {
            rle[rlecount] = (char)zerocount;
            rle[rlecount+1] = 0;
            rlecount += 2;
            zerocount = 1;
          }
        }
        if (rowcount == width)
        {
          rowcount = 0;
          if (!zerocount)       /* start 0 run to next row */
          {
            rle[rlecount] = 0;
            rlecount ++;
          }
          if (zerocount < (255-rowincr))
          {
            zerocount += rowincr;
          }
          else
          {
            rle[rlecount] = (char)zerocount;
            rle[rlecount+1] = 0;
            rlecount += 2;
            zerocount = rowincr;
          }
        }
      }
      else
      {
        if (pbm[i*height*width + j + 4] != 0)
        {  
          rle[rlecount] = pbm[i*height*width + j + 4];
          rlecount ++;
        }
        else    /* start zero counting */
        {
          rle[rlecount] = 0;
          rlecount ++;
          zerocount ++;
        }
        if (rowcount == width)
        {
          rowcount = 0;
          if (!zerocount)       /* start 0 run to next row */
          {
            rle[rlecount] = 0;
            rlecount ++;
          }
          zerocount += rowincr;
        }
      }
    }
    /* done plane - finish rlecount and write 0, 0 */
    if (zerocount)
    {
      rle[rlecount] = 0;
      rlecount ++;
    }
    else
    {
      rle[rlecount] = 0;
      rle[rlecount+1] = 0;
      rlecount += 2;
    }
    zerocount = 0;
    rowcount = 0;
  }
  return(rlecount);
}

/******************************************************
** Calculate and return size of an RLE bitmap without
** actually converting it.
******************************************************/
int x_sizeof_RLE(BYTE * pbm, BYTE ScreenByteWidth)
{
  int i, j;
  int zerocount = 0;            /* # pixels to skip */
  int rlecount = 0;             /* sizeof rle array */
  int rowcount = 0;             /* # pixels processed in this row */
  int width = (int)pbm[0] + (int)(pbm[1] << 8);
  int height = (int)pbm[2]+ (int)(pbm[3] << 8);
  int rowincr = ScreenByteWidth - width;
  
  for (i=0; i<4; i++)   /* plane loop */
  {
    for (j=0; j<(height * width); j++)
    {
      rowcount ++;
      if (zerocount)  /* currently counting 0 bytes */
      {
        if(pbm[i*height*width + j + 4] != 0)  /* finish zero run */
        {
          rlecount += 2;
          zerocount = 0;
        }
        else
        {
          if (zerocount < 255)
          {
            zerocount ++;
          }
          else
          {
            rlecount += 2;
            zerocount = 1;
          }
        }
        if (rowcount == width)
        {
          rowcount = 0;
          if (!zerocount)       /* start 0 run to next row */
          {
            rlecount ++;
          }
          if (zerocount < (255-rowincr))
          {
            zerocount += rowincr;
          }
          else
          {
            rlecount += 2;
            zerocount = rowincr;
          }
        }
      }
      else
      {
        if (pbm[i*height*width + j + 4] != 0)
        {  
          rlecount ++;
        }
        else    /* start zero counting */
        {
          rlecount ++;
          zerocount ++;
        }
        if (rowcount == width)
        {
          rowcount = 0;
          if (!zerocount)       /* start 0 run to next row */
          {
            rlecount ++;
          }
          zerocount += rowincr;
        }
      }
    }
    /* done plane - finish rlecount and write 0, 0 */
    if (zerocount)
    {
      rlecount ++;
    }
    else
    {
      rlecount += 2;
    }
    zerocount = 0;
    rowcount = 0;
  }
  return(rlecount);
}
