/*
 * xutils.s - general low-level mode-x functions
 *
 * DESCRIPTION
 * Includes routines to set the offset in video ram (x_show_page),
 * return to text mode, and clear the entire video buffer.
 *
 * USAGE
 *
 * NOTES
 * Based on xlib60 for BC by Themie Goumas
 *
 * REVISION HISTORY
 * Date         Reason
 * 27 Jun 95    Initial Release
 *
 */

        .data
        .globl  _InGraphics
        .globl  _VisiblePageOffs
        .globl  _HiddenPageOffs
        .globl  _OldVideoMode
        .globl  _core_select

        .text
        .globl  _x_set_text_mode
        .globl  _x_show_page
        .globl  _x_clear_buffer

/**************************************************************/
/* x_set_text_mode(); - sets color text mode 3                   */
/**************************************************************/
_x_set_text_mode:
        pushl   %ebp
        pushl   %eax
        movl    %esp, %ebp
        movl    _OldVideoMode, %eax     /* restore old text mode */
        int     $0x10
        movb    $0, _InGraphics
        popl    %eax
        popl    %ebp
        ret

/********************************************************************/
/* x_show_page(WORD PageOffset); - sets visible page, waits for VR    */
/*               %ebp+8                                             */
/********************************************************************/
_x_show_page:
        pushl   %ebp
        movl    %esp, %ebp
        pushl   %eax
        pushl   %ebx
        pushl   %ecx
        pushl   %edx

/* Pre-load for fastest flip after Display Enable */
        movb    $0x0d, %bl      /* 0x0d - start address low */
        movb    8(%ebp), %bh
        movb    $0x0c, %cl      /* 0x0c - start address high */
        movb    9(%ebp), %ch
        movw    $0x3da, %dx     /* Input Status 1 */
WaitDE:
        inb     %dx, %al
        test    $1, %al
        jnz     WaitDE
/* DE is now active low - set start offset in display memory */
        movw    $0x3d4, %dx     /* CRTC Index */
        movw    %bx, %ax
        outw    %ax, %dx
        movw    %cx, %ax
        outw    %ax, %dx
        movw    $0x3da, %dx     /* Input Status 1 */
/* Wait for VSync so other page will be invisible when we draw */
WaitVS:
        inb     %dx, %al
        test    $8, %al
        jz      WaitVS

/* Update hidden/visible page addresses */
        movw    (_VisiblePageOffs), %ax
        movw    (_HiddenPageOffs), %bx
        movw    %bx, (_VisiblePageOffs)
        movw    %ax, (_HiddenPageOffs)

        popl    %edx
        popl    %ecx
        popl    %ebx
        popl    %eax
        pop     %ebp
        ret

/***************************************************/
/* x_clear_buffer(); - clears all video ram (256k)   */
/***************************************************/
_x_clear_buffer:
        pushl   %eax
        pushl   %ebx
        pushl   %ecx
        pushl   %edx
        pushw   %gs
        movw    $0x3c4, %dx
        movw    $0x0f02, %ax
        outw    %ax, %dx        /* enable writes to all 4 planes */
        movzwl  _core_select, %eax
        movw    %ax, %gs
        movl    $0xa0000, %eax
        movl    $0x4000, %ecx
        xor     %ebx, %ebx
        movl    $0x04, %edx
Clrscreen:        
        movl    %ebx, %gs:(%eax)
        addl    %edx, %eax
        decl    %ecx
        jnz     Clrscreen
        
        popl    %edx
        popl    %ecx
        popl    %ebx
        popl    %eax
        popw    %gs
        ret

