/*
 * fileio.c - binary and other file i/o routines
 *
 * DESCRIPTION
 *
 * USAGE
 *
 * NOTES
 *
 * REVISION HISTORY
 * Date         Reason
 * 17 Jul 95    Initial Release (non-xlib specific functions)
 *
 */

#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <malloc.h>
#include <sys/stat.h>

#include "defines.h"
#include "archive.h"


/********************************************
** file_sizeof() - returns size of a binary file
********************************************/
int file_sizeof(char * filename)
{
  int i = 0;
  struct stat sbuf;

  i = stat(filename, &sbuf);
  if (i != 0)
    return 0;
  
  return (int)sbuf.st_size;
}

/********************************************************************** 
** loads a binary file into the specified buffer, no formatting done.
** mallocs the required memory.
** Returns number of bytes read on success, 0 on failure.
**********************************************************************/
int read_binary(char * filename, BYTE ** buffer)
{
  FILE * fin;
  struct stat sbuf;
  int size;
  
  if (filename == NULL)
    return 0;

  stat(filename, &sbuf);
  size = (int)sbuf.st_size;
  
  fin = fopen(filename, "rb");
  if (fin == NULL)
    return 0;
  
  (*buffer) = (BYTE *)malloc(size);
  if ((*buffer) == NULL)
  {
    fclose(fin);
    return 0;
  }
  
  fread((*buffer), size, 1, fin);
  fclose(fin);
  return size;
}

/*************************************************************************** 
** Writes the buffer with given length to filename.  Write mode depends
** on mode:
** 0 = Create
** 1 = Append
** 2 = Replace(overwrite) - currently just starts at offset 0 - needs a seek
** Returns:  1 = success,  0 = failure
** NOTE:  No warning is given of files about to be destroyed
** OTHER NOTE:  FUNCTION NOT TESTED - ESPECIALLY APPENDING/REPLACING
***************************************************************************/
int write_binary(char * filename, int mode, BYTE * buffer, int length)
{
  FILE * fout;
  
  if (length <= 0)
    return FALSE;
  if ((buffer == NULL) || (filename == NULL))
    return FALSE;
  
  switch(mode)
  {
    case 0:     /* Create */
      fout = fopen(filename, "wb");
      if (fout == NULL)
        return FALSE;
      fwrite(buffer, length, 1, fout);
      break;
    case 1:     /* Append */
      fout = fopen(filename, "ab");
      if (fout == NULL)
        return FALSE;
      fwrite(buffer, length, 1, fout);
      break;
    case 2:     /* Replace/Overwrite */
      fout = fopen(filename, "r+b");
      if (fout == NULL)
        return FALSE;
      fwrite(buffer, length, 1, fout);
      break;
    default:
      return FALSE;
      break;
  }
  fclose(fout);
  return TRUE;
}

/*************************************************************************
** reads a binary file from an archive, allocating memory for the buffer
** Returns:  number of bytes read on success, 0 on failure
*************************************************************************/
int read_binary_archive(char * filename, char * arcname, BYTE ** buffer)
{
  int size, i;

  size = arc_query(arcname, filename);
  if (size <= 0)
    return 0;
  (*buffer) = (BYTE *)malloc(size);
  if ((*buffer) == NULL)
    return 0;
  i = arc_read(arcname, filename, (*buffer));
  if (i != 0)
  {
    free((*buffer));
    return 0;
  }
  return size;
}

