# makefile for libxlib.a - library of mode-x functions
# note: make install is setup for my directory structure
#
# -g for debug info, -Wall for all warning messages, -v for verbose
CFLAGS  = -Wall -O
CC      = gcc
AR      = ar
LIBPATH = c:\dj20\lib
INCLUDE = c:\dj20\include\usr

.c.o.s: 
	$(CC) $(CFLAGS) -c $<

OBJS    = \
	xmode.o xutils.o xpalette.o xbitmap.o \
	xbm.o xpal.o xrect.o xtext.o xprintf.o \
	xpixel.o xline.o xmouse.o xcbitmap.o archive.o \
	fileio.o joystick.o xpbmclip.o

xlib.a: $(OBJS)
	ar rcv libxlib.a $(OBJS)
	
install:        
	copy libxlib.a $(LIBPATH)
	copy xlib.h $(INCLUDE)

uninstall:
	del $(LIBPATH)\libxlib.a
	del $(INCLUDE)\xlib.h

clean:
	del x*.o
	del archive.o
	del fileio.o
	del joystick.o
	del libxlib.a
	del $(LIBPATH)\libxlib.a
	del $(INCLUDE)\xlib.h

# Dependencies:
xmode.o:        xmode.c xlib.h defines.h
xutils.o:       xutils.s xlib.h defines.h
xpalette.o:     xpalette.s xlib.h defines.h
xbitmap.o:      xbitmap.c xlib.h defines.h
xbm.o:          xbm.s xlib.h defines.h
xpal.o:         xpal.c xlib.h defines.h
xrect.o:        xrect.s xlib.h defines.h
xtext.o:        xtext.s xlib.h defines.h
xprintf.o:      xprintf.c xlib.h defines.h
xpixel.o:       xpixel.s xlib.h defines.h
xline.o:        xline.s xlib.h defines.h
xmouse.o:       xmouse.c xlib.h defines.h
xcbitmap.o:     xcbitmap.c xlib.h defines.h
archive.o:      archive.c archive.h defines.h
fileio.o:       fileio.c archive.h defines.h
joystick.o:     joystick.c defines.h
xpbmclip.o:     xpbmclip.s xlib.h defines.h
