/* timings test - compares normal rect fill, specialized screen clear,
**                tile draw and vram->vram copy.  I was suprised how
**                slow the vram->vram copy was on both an ISA and a
**                fast PCI VRAM card.
**
** 14 Aug 95 - added timing of fast clear screen using the DPMI
** nearptr "hack".  Do a few runs to see which is faster.  I have
** found them to be consistently the same (within timer accuracy)
** on both a #9GXE PCI P60 and an ISA ET4000 486, and this timing
** doesn't count the setup time for _djgpp_enable_nearptr();
*/

#include <stdio.h>
#include <pc.h>
#include <go32.h>
#include <malloc.h>
#include <time.h>
#include <dos.h>
#include <sys/nearptr.h>

#include "defines.h"
#include "xlib.h"
#include "archive.h"

BYTE * palette;
BYTE * font1;
BYTE * tiles;

static int newbase;

void main(int argc, char * argv[])
{
  int i, j, k, m, n, nptr;
  int tpbm, tpbmclip;
  int t1, t2;
  
  read_binary("standard.pal", &palette);
  read_binary("fixed6x8.fnt", &font1);
  read_binary("advent1.bmp", &tiles);
  
  x_set_mode(X_320X240);
  x_set_palette(palette);
  
  
  t1 = clock();
  for (k=0; k<200; k++)
    for (i=0; i<20; i++)
      for (j=0; j<15; j++)
        x_put_PBM_masked_clipxy(i<<4, j<<4, Page0_Offs, &tiles[2860]);
  t2 = clock();
  tpbmclip = (int)(t2-t1);
  
  t1 = clock();
  for (k=0; k<200; k++)
    for (i=0; i<20; i++)
      for (j=0; j<15; j++)
        x_put_PBM_masked(i<<4, j<<4, Page0_Offs, &tiles[2340]);
  t2 = clock();
  tpbm = (int)(t2-t1);
  
  t1 = clock();
  for (k=0; k<200; k++)
    for (i=0; i<20; i++)
      for (j=0; j<15; j++)
        x_tile16(i<<4, j<<4, Page0_Offs, &tiles[2600]);
  t2 = clock();
  
  i = (int)(t2-t1);

  t1 = clock();
  for (k=0; k<200; k++)
    x_rect_fill(0,0,320,240,Page0_Offs,4);
  t2 = clock();
  
  j = (int)(t2-t1);
  
  t1 = clock();
  for (k=0; k<400; k++)
  {
    asm ("
        pushl   %eax
        pushl   %ebx
        pushl   %ecx
        pushl   %edx
        pushw   %gs
        movw    $0x3c4, %dx
        movw    $0x0f02, %ax
        outw    %ax, %dx        /* enable writes to all 4 planes */
        movzwl  _core_select, %eax
        movw    %ax, %gs
        movl    $0xa0000, %eax
        movl    $4800, %ecx
        movl    $0x03030303, %ebx
        movl    $0x04, %edx
Clrscreen:        
        movl    %ebx, %gs:(%eax)
        addl    %edx, %eax
        decl    %ecx
        jnz     Clrscreen
        
        popw    %gs
        popl    %edx
        popl    %ecx
        popl    %ebx
        popl    %eax
    ");
  }
  t2 = clock();
  n = (int)(t2-t1);
  
  __djgpp_nearptr_enable();
  
  newbase = __djgpp_conventional_base;
  t1 = clock();
  for (k=0; k<400; k++)
  {
    asm ("
        pushl   %eax
        pushl   %ebx
        pushl   %ecx
        pushl   %edx
        
        movw    $0x3c4, %dx
        movw    $0x0f02, %ax
        outw    %ax, %dx        /* enable writes to all 4 planes */
        movl    $0xa0000, %eax
        addl    _newbase, %eax
        movl    $4800, %ecx
        movl    $0x09090909, %ebx
        movl    $0x04, %edx
Clrscreen2:        
        movl    %ebx, (%eax)
        addl    %edx, %eax
        decl    %ecx
        jnz     Clrscreen2
        
        popl    %edx
        popl    %ecx
        popl    %ebx
        popl    %eax
    ");
  }
  t2 = clock();
  nptr = (int)(t2-t1);
  __djgpp_nearptr_disable();
  
  x_rect_fill(0,0,320,240,Page1_Offs,5);
  
  /* screen -> screen is VERY slow on my test systems! */
  t1 = clock();

  for (k=0; k<200; k++)
    x_cp_vid_rect(0,0,320,240,0,0,Page1_Offs,Page0_Offs,320,320);
  
  t2 = clock();
  
  m = (int)(t2-t1);
  
  getkey();
  
  x_set_text_mode();
  printf("200 masked pbm screens in %d clocks.\n", tpbm);
  printf("%d FPS\n\n", (int)(200*CLOCKS_PER_SEC)/tpbm);
  printf("200 clipped masked pbm screens in %d clocks.\n", tpbmclip);
  printf("%d FPS\n\n", (int)(200*CLOCKS_PER_SEC)/tpbmclip);

  printf("200 tiled screens in %d clocks.\n", i);
  printf("%d FPS\n\n", (int)(200*CLOCKS_PER_SEC)/i);
  printf("200 clear screens in %d clocks.\n", j);
  printf("%d FPS\n\n", (int)(200*CLOCKS_PER_SEC)/j);
  printf("400 fast clear screens in %d clocks.\n", n);
  printf("%d FPS\n\n", (int)(400*CLOCKS_PER_SEC)/n);
  printf("400 VRAM hack fast clear screens in %d clocks.\n", nptr);
  printf("%d FPS\n\n", (int)(400*CLOCKS_PER_SEC)/nptr);
  printf("__djgpp_conventional_base is %d\n\n", newbase);
  printf("200 screen to screen copies in %d clocks.\n", m);
  printf("%d FPS\n", (int)(200*CLOCKS_PER_SEC)/m);
  
  free(font1);
  free(palette);
  free(tiles);
}
