/*
 * xline.s - draws lines to screen in mode-x
 *
 * DESCRIPTION
 *
 * USAGE
 *
 * NOTES
 * Based on xlib60 for BC by Themie Goumas
 *
 * REVISION HISTORY
 * Date         Reason
 * 27 Jun 95    Initial Release
 *
 */
	
	.data
vertincr:
	.long   0
incr1:
	.long   0
incr2:
	.long   0
routine:
	.long   0
	
	.text
	.globl  _x_line
	.extern _ScrnLogicalByteWidth
	.extern _core_select

/********************************************************************
** x_line(int X1, int Y1, int X2, int Y2, int PageBase, char Color);
**   %ebp+  8       12      16      20         24           28
********************************************************************/
_x_line:
	pushl   %ebp
	movl    %esp, %ebp
	pushl   %esi
	pushl   %edi
	pushl   %eax
	pushl   %ebx
	pushl   %ecx
	pushl   %edx
	pushw   %es

	movw    $0x3c4, %dx
	movw    _core_select, %ax
	movw    %ax, %es

/* check for vertical line */
	movl    _ScrnLogicalByteWidth, %esi
	movl    16(%ebp), %ecx
	subl    8(%ebp), %ecx
	jz      VertLine

/* force x1 < x2 */
	jns     L01

	negl    %ecx

	movl    16(%ebp), %ebx
	xchgl   8(%ebp), %ebx
	movl    %ebx, 16(%ebp)
	movl    20(%ebp), %ebx
	xchgl   12(%ebp), %ebx
	movl    %ebx, 20(%ebp)

/* calc dy = abs(y2 - y1) */
L01:
	movl    20(%ebp), %ebx
	subl    12(%ebp), %ebx
	jnz     skip
	jmp     HorizLine
skip:           
	jns     L03

	negl    %ebx
	negl    %esi

/* select appropriate routine for slope of line */
L03:
	movl    %esi, vertincr
/* LoSlopeLine */
	movl    $1, routine
	cmpl    %ecx, %ebx
	jle     L04
/* HiSlopeLine */
	movl    $2, routine
	xchgl   %ecx, %ebx

/* calc initial decision variable and increments */
L04:
	shll    $1, %ebx
	movl    %ebx, incr1
	subl    %ecx, %ebx
	movl    %ebx, %esi
	subl    %ecx, %ebx
	movl    %ebx, incr2

/* calc first pixel address */

	pushl   %ecx
	movl    12(%ebp), %eax
	movl    8(%ebp), %ebx
	
/*        ModeXAddr */
	movb    %bl, %cl
	pushl   %edx
	movl    _ScrnLogicalByteWidth, %edx
	imul    %edx
	popl    %edx
	shrl    $2, %ebx
	addl    %eax, %ebx
	addl    24(%ebp), %ebx
	addl    $0xa0000, %ebx
	andl    $0x0fffffff, %ebx
	andb    $3, %cl
	
	movl    %ebx, %edi
	movb    $1, %al
	shlb    %cl, %al
	movb    %al, %ah
	shlb    $4, %al
	addb    %al, %ah
	movb    %ah, %bl
	popl    %ecx
	incl    %ecx

	cmp     $1, routine
	je      LoSlopeLine
	jmp     HiSlopeLine

/* routine for verticle lines */

VertLine:
	movl    12(%ebp), %eax
	movl    20(%ebp), %ebx
	movl    %ebx, %ecx
	subl    %eax, %ecx
	jge     L31
	negl    %ecx
	movl    %ebx, %eax
L31:
	incl    %ecx
	movl    8(%ebp), %ebx
	pushl   %ecx
	
/*        ModeXAddr */
	movb    %bl, %cl
	pushl   %edx
	movl    _ScrnLogicalByteWidth, %edx
	imul    %dx
	popl    %edx
	shrl    $2, %ebx
	addl    %eax, %ebx
	addl    24(%ebp), %ebx
	addl    $0xa0000, %ebx
	andl    $0x0fffffff, %ebx    /* Clear any linear access bits */
	andb    $3, %cl

	movb    $1, %ah
	shlb    %cl, %ah
	movb    $0x02, %al      /* Map Mask */
	outw    %ax, %dx
	popl    %ecx
	movb    28(%ebp), %al

/* draw the line */
L32:
	movb    %al, %es:(%ebx)
	addl    %esi, %ebx
	loop    L32
	jmp     Lexit

/* routine for horizontal line */
HorizLine:
	movl    12(%ebp), %eax
	movl    8(%ebp), %ebx
	
/*        ModeXAddr */
	movb    %bl, %cl
	pushl   %edx
	movl    _ScrnLogicalByteWidth, %edx
	imul    %dx
	popl    %edx
	shrl    $2, %ebx
	addl    %eax, %ebx
	addl    24(%ebp), %ebx
	addl    $0xa0000, %ebx
	andl    $0x0fffffff, %ebx    /* Clear any linear access bits */
	andb    $3, %cl

	movl    %ebx, %edi
	movb    $0x0f, %dl
	shlb    %cl, %dl

	movl    16(%ebp), %ecx
	andb    $3, %cl
	movb    $0x0e, %dh
	shlb    %cl, %dh
	notb    %dh

/* determine byte offset of first and last pixel in line */

	movl    16(%ebp), %eax
	movl    8(%ebp), %ebx

	shrl    $2, %eax
	shrl    $2, %ebx
	movl    %eax, %ecx
	subl    %ebx, %ecx

	movw    %dx, %ax
	movw    $0x3c4, %dx
	xorl    %ebx, %ebx
	movb    28(%ebp), %bl

/* set pixels in leftmost byte of line */

	orl     %ecx, %ecx
	jnz     L42
	andb    %al, %ah
	jmp     L44

L42:            
	pushl   %eax
	movb    %al, %ah
	movb    $0x02, %al
	outw    %ax, %dx
	movb    %bl, %al
	stosb
	decl    %ecx

/* draw remainder of the line */
L43:
	movw    $0x0f02, %ax
	outw    %ax, %dx
	movb    %bl, %al
	rep     
	stosb
	popl    %eax

/* set pixels in rightmost byte of line */
L44:
	movb    $0x02, %al
	outw    %ax, %dx
	movb    %bl, %es:(%edi)
	jmp     Lexit

/* routine for dy >= dx (slope <= 1) */
LoSlopeLine:
	movb    $0x02, %al
	movb    28(%ebp), %bh
L10:
	movb    %bl, %ah
L11:
	orb     %bl, %ah
	rolb    $1, %bl
	jc      L14

/* bit mask not shifted out */

	orl     %esi, %esi
	jns     L12
	addl    incr1, %esi
	loop    L11

	outw    %ax, %dx
	movb    %bh, %es:(%edi)
	jmp     Lexit

L12:
	addl    incr2, %esi
	outw    %ax, %dx
	movb    %bh, %es:(%edi)
	addl    vertincr, %edi
	loop    L10
	jmp     Lexit

/* bit mask shifted out */
L14:            
	outw    %ax, %dx
	movb    %bh, %es:(%edi)
	incl    %edi
	orl     %esi, %esi
	jns     L15
	addl    incr1, %esi
	loop    L10
	jmp     Lexit

L15:
	addl    incr2, %esi
	addl    vertincr, %edi
	loop    L10
	jmp     Lexit

/* routine for dy > dx (slope > 1) */
HiSlopeLine:
	movl    vertincr, %ebx
	movb    $0x02, %al
L21:            
	outw    %ax, %dx
	pushl   %eax
	movb    28(%ebp), %al
	movb    %al, %es:(%edi)
	popl    %eax
	addl    %ebx, %edi

L22:
	orl     %esi, %esi
	jns     L23

	addl    incr1, %esi
	loop    L21
	jmp     Lexit

L23:
	addl    incr2, %esi
	rolb    $1, %ah
	adcl    $0, %edi
lx21:   
	loop    L21

/* return to caller */
Lexit:
	popw    %es
	popl    %edx
	popl    %ecx
	popl    %ebx
	popl    %eax
	popl    %edi
	popl    %esi
	popl    %ebp
	ret
