/* Just a simple demo program of some of the functions available */

#include <stdio.h>
#include <pc.h>
#include <go32.h>
#include <malloc.h>
#include <time.h>
#include <dos.h>

#include "defines.h"
#include "xlib.h"
#include "archive.h"
#include "colors.h"

BYTE * palette;
BYTE palsave[768];
BYTE * font[12];
BYTE * cfont1;

BYTE * rle;
BYTE * cbm;
BYTE * ball; /* this will be the PBM ball */

BYTE lin_ball[] = {
         32,  0, 32,  0, 
          0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
          0,  0, 47, 47, 47, 47, 47, 47, 47,  0,  0,  0,
          0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
          0,  0,  0,  0,  0,  0,  0, 78, 78, 78, 47, 47,
         47, 47, 47, 47, 47, 78, 78, 78,  0,  0,  0,  0,
          0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
          0, 78, 78, 78, 78, 78, 47, 47, 47, 47, 47, 47,
         47, 78, 78, 78, 78, 78,  0,  0,  0,  0,  0,  0,
          0,  0,  0,  0,  0,  0,  0,  0, 78, 78, 78, 78,
         78, 78, 47, 47, 47, 47, 47, 47, 47, 78, 78, 78,
         78, 78, 78,  0,  0,  0,  0,  0,  0,  0,  0,  0,
          0,  0,  0, 63, 78, 78, 78, 78, 78, 78, 47, 47,
         47, 47, 47, 47, 47, 78, 78, 78, 78, 78, 78, 95,
          0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 63, 63,
         78, 78, 78, 78, 78, 78, 47, 47, 47, 47, 47, 47,
         47, 78, 78, 78, 78, 78, 78, 95, 95,  0,  0,  0,
          0,  0,  0,  0,  0, 63, 63, 63, 78, 78, 78, 78,
         78, 78, 47, 47, 47, 47, 47, 47, 47, 78, 78, 78,
         78, 78, 78, 95, 95, 95,  0,  0,  0,  0,  0,  0,
         63, 63, 63, 63, 78, 78, 78, 78, 78, 78, 47, 47,
         47, 47, 47, 47, 47, 78, 78, 78, 78, 78, 78, 95,
         95, 95, 95,  0,  0,  0,  0,  0, 63, 63, 63, 63,
         78, 78, 78, 78, 78, 78, 47, 47, 47, 47, 47, 47,
         47, 78, 78, 78, 78, 78, 78, 95, 95, 95, 95,  0,
          0,  0,  0, 63, 63, 63, 63, 63, 78, 78, 78, 78,
         78, 78, 47, 47, 47, 47, 47, 47, 47, 78, 78, 78,
         78, 78, 78, 95, 95, 95, 95, 95,  0,  0,  0, 63,
         63, 63, 63, 63, 78, 78, 78, 78, 78, 78, 47, 47,
         47, 47, 47, 47, 47, 78, 78, 78, 78, 78, 78, 95,
         95, 95, 95, 95,  0,  0,  0, 63, 63, 63, 63, 63,
         78, 78, 78, 78, 78, 78, 47, 47, 47, 47, 47, 47,
         47, 78, 78, 78, 78, 78, 78, 95, 95, 95, 95, 95,
          0,  0, 63, 63, 63, 63, 63, 63, 78, 78, 78, 78,
         78, 78, 47, 47, 47, 47, 47, 47, 47, 78, 78, 78,
         78, 78, 78, 95, 95, 95, 95, 95, 95,  0, 63, 63,
         63, 63, 63, 63, 78, 78, 78, 78, 78, 78, 47, 47,
         47, 47, 47, 47, 47, 78, 78, 78, 78, 78, 78, 95,
         95, 95, 95, 95, 95,  0, 63, 63, 63, 63, 63, 63,
         78, 78, 78, 78, 78, 78, 47, 47, 47, 47, 47, 47,
         47, 78, 78, 78, 78, 78, 78, 95, 95, 95, 95, 95,
         95,  0, 63, 63, 63, 63, 63, 63, 78, 78, 78, 78,
         78, 78, 47, 47, 47, 47, 47, 47, 47, 78, 78, 78,
         78, 78, 78, 95, 95, 95, 95, 95, 95,  0, 63, 63,
         63, 63, 63, 63, 78, 78, 78, 78, 78, 78, 47, 47,
         47, 47, 47, 47, 47, 78, 78, 78, 78, 78, 78, 95,
         95, 95, 95, 95, 95,  0, 63, 63, 63, 63, 63, 63,
         78, 78, 78, 78, 78, 78, 47, 47, 47, 47, 47, 47,
         47, 78, 78, 78, 78, 78, 78, 95, 95, 95, 95, 95,
         95,  0, 63, 63, 63, 63, 63, 63, 78, 78, 78, 78,
         78, 78, 47, 47, 47, 47, 47, 47, 47, 78, 78, 78,
         78, 78, 78, 95, 95, 95, 95, 95, 95,  0,  0, 63,
         63, 63, 63, 63, 78, 78, 78, 78, 78, 78, 47, 47,
         47, 47, 47, 47, 47, 78, 78, 78, 78, 78, 78, 95,
         95, 95, 95, 95,  0,  0,  0, 63, 63, 63, 63, 63,
         78, 78, 78, 78, 78, 78, 47, 47, 47, 47, 47, 47,
         47, 78, 78, 78, 78, 78, 78, 95, 95, 95, 95, 95,
          0,  0,  0, 63, 63, 63, 63, 63, 78, 78, 78, 78,
         78, 78, 47, 47, 47, 47, 47, 47, 47, 78, 78, 78,
         78, 78, 78, 95, 95, 95, 95, 95,  0,  0,  0,  0,
         63, 63, 63, 63, 78, 78, 78, 78, 78, 78, 47, 47,
         47, 47, 47, 47, 47, 78, 78, 78, 78, 78, 78, 95,
         95, 95, 95,  0,  0,  0,  0,  0, 63, 63, 63, 63,
         78, 78, 78, 78, 78, 78, 47, 47, 47, 47, 47, 47,
         47, 78, 78, 78, 78, 78, 78, 95, 95, 95, 95,  0,
          0,  0,  0,  0,  0, 63, 63, 63, 78, 78, 78, 78,
         78, 78, 47, 47, 47, 47, 47, 47, 47, 78, 78, 78,
         78, 78, 78, 95, 95, 95,  0,  0,  0,  0,  0,  0,
          0,  0, 63, 63, 78, 78, 78, 78, 78, 78, 47, 47,
         47, 47, 47, 47, 47, 78, 78, 78, 78, 78, 78, 95,
         95,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 63,
         78, 78, 78, 78, 78, 78, 47, 47, 47, 47, 47, 47,
         47, 78, 78, 78, 78, 78, 78, 95,  0,  0,  0,  0,
          0,  0,  0,  0,  0,  0,  0,  0, 78, 78, 78, 78,
         78, 78, 47, 47, 47, 47, 47, 47, 47, 78, 78, 78,
         78, 78, 78,  0,  0,  0,  0,  0,  0,  0,  0,  0,
          0,  0,  0,  0,  0, 78, 78, 78, 78, 78, 47, 47,
         47, 47, 47, 47, 47, 78, 78, 78, 78, 78,  0,  0,
          0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
          0,  0,  0, 78, 78, 78, 47, 47, 47, 47, 47, 47,
         47, 78, 78, 78,  0,  0,  0,  0,  0,  0,  0,  0,
          0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
          0,  0, 47, 47, 47, 47, 47, 47, 47,  0,  0,  0,
          0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
          0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
          0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
          0,  0,  0,  0,  0,  0,  0,  0  };

BYTE tile1[] = {
          4,  0, 16,  0, 
         29, 29, 29, 29, 29, 34, 34, 34, 29, 34,
         35, 34, 29, 34, 35, 31, 29, 35, 35, 35, 29, 35,
         35, 35, 29, 35, 35, 35, 29, 35, 35, 35, 29, 35,
         35, 35, 29, 35, 35, 35, 29, 35, 35, 35, 29, 34,
         35, 34, 29, 34, 35, 31, 29, 35, 35, 35, 29, 35,
         35, 35, 29, 31, 31, 31, 29, 29, 29, 29, 34, 34,
         34, 34, 34, 35, 35, 34, 34, 35, 35, 34, 34, 35,
         35, 35, 34, 35, 35, 35, 34, 35, 35, 35, 34, 35,
         35, 35, 34, 35, 35, 35, 34, 35, 35, 35, 34, 35,
         35, 35, 34, 35, 35, 34, 34, 35, 35, 34, 34, 35,
         35, 35, 34, 35, 35, 35, 31, 31, 31, 31, 29, 29,
         29, 29, 34, 34, 34, 34, 35, 35, 35, 35, 35, 35,
         35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
         35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
         35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35,
         35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 31, 31,
         31, 31, 29, 29, 29, 31, 34, 34, 34, 31, 34, 35,
         35, 31, 31, 35, 35, 31, 35, 35, 35, 31, 35, 35,
         35, 31, 35, 35, 35, 31, 35, 35, 35, 31, 35, 35,
         35, 31, 35, 35, 35, 31, 35, 35, 35, 31, 34, 35,
         35, 31, 31, 35, 35, 31, 35, 35, 35, 31, 35, 35,
         35, 31, 31, 31, 31, 31,  0,  0  };

void getnext();

int main()
{
  int i, j;

  /* Load the palette and a bunch of fonts */
  read_binary("standard.pal", &palette);
  read_binary("fixed6x8.fnt", &font[0]);
  read_binary("crisp6x9.fnt", &font[1]);
  read_binary("modernb.fnt", &font[2]);
  read_binary("smalthin.fnt", &font[3]);
  read_binary("timpani.fnt", &font[4]);
  read_binary("tiny4.fnt", &font[5]);
  read_binary("varswisl.fnt", &font[6]);
  read_binary("varswisb.fnt", &font[7]);
  read_binary("var6x8.fnt", &font[8]);
  read_binary("colfnt1.fnt", &cfont1);
  
  memcpy(palsave, palette, 768);

  ball = (BYTE *)malloc(1028);
  x_BM_to_PBM(lin_ball, ball);

  i = x_sizeof_RLE(ball, 80);
  rle = (BYTE *)malloc(i);
  x_PBM_to_RLE(ball, rle, 80);
  
  i = x_sizeof_cbitmap(80, lin_ball);
  cbm = (BYTE *)malloc(i);
  x_compile_bitmap(80, lin_ball, cbm);
  
  x_set_mode(X_320X240);
  x_set_palette(palette);
  x_init_mouse();
  
  x_rect_fill(0, 0, 320, 240, Page0_Offs, 25);

  x_printf(41, 21, Page0_Offs,  0, font[8], "MODE-X FUNCTIONS FOR DJGPP");
  x_printf(40, 20, Page0_Offs, 15, font[8], "MODE-X FUNCTIONS FOR DJGPP");

  x_put_PBM(20, 40, Page0_Offs, ball);
  x_printf(60, 40, Page0_Offs, 15, font[8], "Planar bitmap");
  x_put_PBM_masked(20, 80, Page0_Offs, ball);
  x_printf(60, 80, Page0_Offs, 15, font[8], "Masked Planar bitmap");
  x_put_RLE(20, 120, Page0_Offs, rle);
  x_printf(60, 120, Page0_Offs, 15, font[8], "RLE encoded bitmap");
  x_put_cbitmap(20, 160, Page0_Offs, cbm);
  x_printf(60, 160, Page0_Offs, 15, font[8], "Compiled bitmap");
  x_tile16(20, 200, Page0_Offs, tile1);
  x_tile32(40, 200, Page0_Offs, ball);
  x_printf(100, 200, Page0_Offs, 15, font[8], "16x16 and 32x32 tiles");

  x_printf(20, 230, Page0_Offs, 15, font[8], "Left Click or press a key ...");
  getnext();
  x_cp_vid_rect(0, 0, 120, 160, 160, 30, Page0_Offs, Page0_Offs, 320, 320);
  x_printf(40, 30, Page0_Offs, 15, font[8], "Fast screen to screen copies");
  getnext();
  
  x_rect_fill(0, 0, 320, 240, Page0_Offs, 0);

  for (i=0; i<9; i++)
    x_printf(20, 15*i+10, Page0_Offs, 15, font[i], 
             "Fixed and variable width fonts. #%d", i);
  x_cprintf(20, 200, Page0_Offs, cfont1, "THIS IS A CHEAP COLOR FONT!");

  getnext();
  
  x_rect_fill(0, 0, 320, 240, Page0_Offs, 0);
  x_set_cliprect(30, 40, 57, 199);
  
  x_line((XClipMin<<2)-1, YClipMin-1 , (XClipMax+1)<<2, YClipMin-1,
         Page0_Offs, WHITE);
  x_line((XClipMin<<2)-1, YClipMax+1 , (XClipMax+1)<<2, YClipMax+1,
         Page0_Offs, WHITE);
  x_line((XClipMin<<2)-1, YClipMin-1 , (XClipMin<<2)-1, YClipMax+1,
         Page0_Offs, WHITE);
  x_line((XClipMax+1)<<2, YClipMin-1 , (XClipMax+1)<<2, YClipMax+1,
         Page0_Offs, WHITE);
  
  x_printf(20, 20, Page0_Offs, WHITE, font[8], "PBM and text clipping");
  x_printf_clipxy(109, 38, Page0_Offs, LT_GREY, font[8], "This is a testabcdefgh");
  x_printf_clipxy(117, 48, Page0_Offs, LT_GREY, font[8], "This is a testabcdefgh");
  x_printf_clipxy(118, 58, Page0_Offs, LT_GREY, font[8], "This is a testabcdefgh");
  x_printf_clipxy(119, 68, Page0_Offs, LT_GREY, font[8], "This is a testabcdefgh");
  x_printf_clipxy(120, 78, Page0_Offs, LT_GREY, font[8], "This is a testabcdefgh");
  x_printf_clipxy(116, 88, Page0_Offs, LT_GREY, font[8], "This is a testabcdefgh");
  x_printf_clipxy(115, 98, Page0_Offs, LT_GREY, font[8], "This is a testabcdefgh");
  
  x_put_PBM_masked_clipxy(110, 110, Page0_Offs, ball);
  x_put_PBM_masked_clipxy(110, 190, Page0_Offs, ball);
  x_put_PBM_masked_clipxy(210, 180, Page0_Offs, ball);
  x_put_PBM_masked_clipxy(230, 130, Page0_Offs, ball);
  x_put_PBM_masked_clipxy(225, 33, Page0_Offs, ball);
  x_cprintf_clipxy(100, 120, Page0_Offs, cfont1, "CLIPPED IN COLOR TOO!");
  
  getnext();
  x_set_mouse_cursor(ball);
  
  for (i=0; i<20; i++)
    for(j=0; j<15; j++)
      x_tile16(i<<4, j<<4, Page0_Offs, tile1);
  
  x_cprintf(22, 20, Page0_Offs, cfont1, "CUSTOM MOUSE CURSORS.");
  x_show_mouse();
  for (;;)
  {
    x_mouse_get_event();
    if (kbhit()) 
    {
      getkey();
      break;
    }
    if (MouseButtonStatus == 1)
      break;
  }
  
  while (MouseButtonStatus != 0)
    x_mouse_get_event();
  
  x_fade_out(palette);
  x_set_text_mode();
  
  free(palette);
  for (i=0; i<9; i++)
    free(font[i]);
  free(cfont1);
  free(cbm);
  free(rle);
  free(ball);

  printf("Acknowledgements and thanks to:\n\n");
  printf("DJ Delorie and the DJGPP dev. team for a great DOS development environment\n");
  printf("Themie Goumas for the XLIB graphics package\n");
  printf("Ed. Mueller for the PBM clipping functions\n");
  printf("Mark Morley for the palette functions\n");
  printf("Dave Roberts for the retrace sync and detection functions\n\n");
  printf("... and anyone else I've forgotten to mention who's code or ideas have\n");
  printf("contributed to this effort.\n");
  
  return 0;
}

void getnext()
{
  for(;;)
  {
    if (kbhit()) 
    {
      getkey();
      break;
    }
    x_mouse_get_event();
    if(MouseButtonStatus == 1)
    {  
      while (MouseButtonStatus != 0)
        x_mouse_get_event();
      break;
    }
  }
}
