MASM
Comment 
ͻ
 Joystick Interface Routines - V1.0a Copyright 1994 Phil Carlisle & MAGE     
Ķ
 Techie Notes                                                                
                                                                 
 Ok, basically, for joystick routines, we need to test certain bits at port  
 address 201 hex, the buttons are digital values, with the XY values, we     
 have to write 0 to port 201h this starts the capacitors charging, and sets  
 bits to 1 for all XY values, then as the values drop to logic 0, we store   
 the count reached in our counter variables as the XY values for the position
                                                                             
 basically this means that the bloody thing is slow, but thats a limit of    
 the hardware, you can expect this to take ~3ms or so.. I use ADC with the   
 counters to keep an even timing in our counter loop.. we also need a dead   
 zone with some play, because centreing isnt always reliable.                
ͼ

PORT LAYOUT - For those interested :)

GamePort - PC bus
=================

   Read bits at address 201 (gameport)
   ===================================

   =================================
   | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
   =================================
     |   |   |   |   |   |   |   |
     |   |   |   |   |   |   |   +---- Axis       Joystick A, X-Axis
     |   |   |   |   |   |   +-------- Timer      Joystick A, Y-Axis
     |   |   |   |   |   +------------ Status     Joystick B, X-Axis
     |   |   |   |   +---------------- Bits       Joystick B, Y-Axis
     |   |   |   |
     |   |   |   +-------------------- Digital    Joystick A, Button #1
     |   |   +------------------------ Button     Joystick A, Button #2
     |   +---------------------------- Inputs     Joystick B, Button #1
     +--------------------------------            Joystick B, Button #2

History of routines


V1.0a - Initial...

26-07-94 Version 1.0a started.. using information found in the pcgpe and
the gravis gamepad/analog pro sdk

01-08-94 Version 1.0aa - testing the buttons found a problem with reading on
current stick, works if the button a of stick 2 is pressed, need to debug, also
need to find a better port detection method

23-08-94 Version 1.0aaa - finally fixed the detection so it works, now this 
routine returns a int to watcom, so you can do while (!JDetect); fun..
added some calibration routines, so you can ask the user to push top left etc

28-08-94 Version 1.0aaaa - problems with the calibration routines, in that the
buttons need to be debounced, but I havent found a reliable way to do so as
yet.. a stop gap will be to use a space bar press in the calibration routine,
this would make it simpler, but more awkward for the user.. 

03-09-94 V1.0a-x fixed this asm file so it would compile and work with Watcom
C++ not just watcom C

05-09-94 V1.0a-z decided to do the calibration in the main class, that way
I can just read the values and adjust as needed easier.. doesnt matter
much either way, finally got a debounce! (kinda crap) done in the class,
and state switching added to the class (ie it can tell when youve pressed
and released the damn buttons, maybe i will add that to this asm later.)
     


IDEAL
p386
model flat
locals
jumps

;Global Procedures...


Dataseg                                                                      

;first here's our button vars

PUBLIC  _JSABut1         ;:byte     
PUBLIC  _JSABut2         ;:byte
PUBLIC  _JSBBut1         ;:byte
PUBLIC  _JSBBut2         ;:byte

;First here's our analogue values...
     
PUBLIC  _JSAX            ;:word    
PUBLIC  _JSAY            ;:word
PUBLIC  _JSBX            ;:word
PUBLIC  _JSBY            ;:word

;values set by our calibration procedure

PUBLIC  _JSAMinX         ;:word
PUBLIC  _JSAMaxX         ;:word
PUBLIC  _JSAMinY         ;:word
PUBLIC  _JSAMaxY         ;:word
PUBLIC  _JSACentreX      ;:word
PUBLIC  _JSACentreY      ;:word
PUBLIC  _JSBMinX         ;:word
PUBLIC  _JSBMaxX         ;:word
PUBLIC  _JSBMinY         ;:word
PUBLIC  _JSBMaxY         ;:word
PUBLIC  _JSBCentreX      ;:word
PUBLIC  _JSBCentreY      ;:word
                        
;Now the state vars for sort of digital type reading..

PUBLIC  JAStateX        ;:byte
PUBLIC  JAStateY        ;:byte
PUBLIC  JBStateX        ;:byte
PUBLIC  JBStateY        ;:byte

;Now some var's and equates used in our procedures

JPort                   equ     201h    ;joystick port
JCounterTimeOutVal      equ     0ffffh  ;timeout counter value
PUBLIC  _JCounter        ;:word
PUBLIC  _JSPresent       ;:byte

_JSABut1         db      0
_JSABut2         db      0
_JSBBut1         db      0
_JSBBut2         db      0

;First here's our analogue values...
     
_JSAX    dw      0       ;Joystick A X value
_JSAY    dw      0       ;       "   Y  "
_JSBX    dw      0       ;       " B X  "
_JSBY    dw      0       ;       "   Y  "

;values set by our calibration procedure

_JSAMinX         dw      0
_JSAMaxX         dw      0
_JSAMinY         dw      0
_JSAMaxY         dw      0
_JSACentreX      dw      0
_JSACentreY      dw      0
_JSBMinX         dw      0
_JSBMaxX         dw      0
_JSBMinY         dw      0
_JSBMaxY         dw      0
_JSBCentreX      dw      0
_JSBCentreY      dw      0

;Now the state vars for sort of digital type reading..

JAStateX        db      0       ;Joystick State (Pseudo Digi)
JAStateY        db      0       ;0=centred 1=left 2=right
JBStateX        db      0       ;
JBStateY        db      0       ;

;Now some var's and equates used in our procedures

_JCounter        dw      0       ;Joystick counter (for timeout)
_JSPresent       db      0       ;Joystick Presence Flag

;and finally some procedures :))

PUBLIC  PollJoystick_    ;:NEAR            ;hmm...
PUBLIC  JDetect_         ;:NEAR
PUBLIC  JButtons_        ;:NEAR
PUBLIC  JACalTL_         ;:NEAR           ;stick A calibration top left
PUBLIC  JACalBR_         ;:NEAR           ;    "              bottom right
PUBLIC  JACalCentre_     ;:NEAR
PUBLIC  JButtonPressed_  ;:NEAR
 
Codeseg


;Ŀ
;Proc JDetect           This routine detects the presence of joysticks      
;                       by writing a byte to port 201h and waiting for the  
;                       bits to return to zero.. indicating presence        
;Ĵ
;In      -       Nothing                                                     
;Out     -       1 in JSPresent = gameport here...                           
;Destroys        Nothing                                                     
;Note            See Global Variables above....                              
;

PROC    JDetect_     
        push    ecx edx 
        pushf
        clc                             ;clear carry flag for later
        cli                             ;no ints... we are timing..
        mov     ecx,0                   ;reset loop counter
        mov     dx,JPort
        mov     al,1
        out     dx,al                   ;this sets off the timers
        mov     cx,JCounterTimeOutVal   ;time out count
@jdloop:                                ;poll loop        
        in      al,dx                   ;byte now in al = Status
        and     al,00000001b            ;and the joystick XY vals
        cmp     al,0
        je      @jhere                  ;done this poll
        loop    @jdloop
        mov     [_jsPresent],0
        jmp short @donejdpoll
@jhere:        
        mov     [_JSPresent],1
@donejdpoll:        
        xor     eax,eax
        mov     al,[_JSPresent]
        sti
        popf
        pop     edx ecx
        ret                                                   
ENDP 

;Ŀ
;Proc PollJoystick      Polls the joystick, returning analogue values       
;                       in variables for both stick A and B, sets Buttons   
;                       at the same time....                                
;Ĵ
;In      -       Nothing                                                     
;Out     -       Values in the global vars                                   
;Destroys        Nothing                                                     
;Note            See Global Variables above....                              
;

PROC    PollJoystick_     
        pushad
        pushf
        clc                             ;clear carry flag for later
        cli                             ;no ints... we are timing..
        mov     [_JCounter],0            ;reset loop counter
        mov     [_JSAX],0
        mov     [_JSAY],0
        mov     [_JSBX],0
        mov     [_JSBY],0
        mov     [_JSABut1],0
        mov     [_JSABut2],0
        mov     [_JSBBut1],0
        mov     [_JSBBut2],0             ;clear button vars                
          
        mov     dx,JPort
        mov     al,0
        out     dx,al                   ;this sets off the timers
@jsloop:                                ;poll loop        
        in      al,dx                   ;byte now in al = Status
        mov     ah,al                   ;need to test if no vals..
        and     al,00001111b            ;and the joystick XY vals
        je      @donejspoll             ;done this poll
        shr     al,1                    ;Stick A X axis
        adc     [_JSAX],0                ;inc counter if bit high
        clc                             ;clear for next bit
        shr     al,1                    ;Stick A Y axis
        adc     [_JSAY],0                ;inc if bit high
        clc                             ;
        shr     al,1                    ;Stick B X axis
        adc     [_JSBX],0                ;
        clc                             ;
        shr     al,1                    ;Stick B Y axis
        adc     [_JSBY],0                ;
        inc     [_JCounter]              ;
        cmp     [_JCounter],JCounterTimeOutVal
        jge     @jsloop
@donejspoll:        
        mov     al,ah                   ;we only want top 4 bits of al..
        shr     al,4                    ;prepare buttons only..         
        clc                             ;right, now time for buttons..
        shr     al,1                    ;ok now load button vars
        adc     [_JSABut1],0
        clc
        shr     al,1
        adc     [_JSABut2],0
        clc
        shr     al,1
        adc     [_JSBBut1],0
        clc
        shr     al,1
        adc     [_JSBBut2],0
        sti
        popf
        popad
        ret                                                   
ENDP 
 

;Ŀ
;Proc JButtons          This routine reads the status of the various        
;                       joystick buttons using the usual method.. :))       
;Ĵ
;In      -       Nothing                                                     
;Out     -       Fills button vars                                           
;Destroys        Nothing                                                     
;Note            See Global Variables above....                              
;

PROC    JButtons_
        pushad
        pushf
        mov     dx,JPort
        mov     al,1
        out     dx,al
        mov     [_JSABut1],0
        mov     [_JSABut2],0
        mov     [_JSBBut1],0
        mov     [_JSBBut2],0            ;clear button vars &                       
        mov     dx,JPort                ;waste some time for jstick to settle
        in      al,dx                   ;byte now in al = Status
        shr     al,4                    ;get rid of XY data
        clc                             ;right, now time for buttons..
        shr     al,1                    ;ok now load button vars
        adc     [_JSABut1],0
        clc
        shr     al,1
        adc     [_JSABut2],0
        clc
        shr     al,1
        adc     [_JSBBut1],0
        clc
        shr     al,1
        adc     [_JSBBut2],0        
        popf
        popad
        ret                                                   
ENDP 

PROC    JButtonPressed_            ;button pressed??
        mov     eax,0
        call    JButtons_
        cmp     [_JSABut1],0
        je      @Isapress
        cmp     [_JSABut2],0
        je      @Isapress
        jmp     @nopress
@Isapress:
        mov     eax,1
@nopress:
        ret
ENDP




; forget all this, its easier in C  :)


PROC    JACalTL_
        push    ax
;@TLWaitbutton:        
        call    PollJoystick_
;        cmp     [_JSABut1],0
;        je      @CalTL
;        cmp     [_JSABut2],0
;        je      @CalTL
;        jmp     @TLWaitbutton
;@CalTL:        
;        call    PollJoystick        
;        cmp     [_JSABut1],1
;        je      @CalTLread
;        cmp     [_JSABut2],1
;        je      @CalTLread
;        jmp     @CalTL
;@CalTLread:        
        mov     ax,[_JSAX]
        mov     [_JSAMinX],ax
        mov     ax,[_JSAY]
        mov     [_JSAMinY],ax
        pop     ax
        ret
ENDP

PROC    JACalBR_
        push    ax
;@BRWaitbutton:        
        call    PollJoystick_
;        cmp     [_JSABut1],0
;        je      @CalTL
;        cmp     [_JSABut2],0
;        je      @CalBR
;        jmp     @BRWaitbutton
;@CalBR:        
        mov     ax,[_JSAX]
        mov     [_JSAMaxX],ax
        mov     ax,[_JSAY]
        mov     [_JSAMaxY],ax
        pop     ax
        ret
ENDP

PROC    JACalCentre_
        push    ax
;@CentreWaitbutton:        
        call    PollJoystick_
;        cmp     [_JSABut1],0
;        je      @CalTL
;        cmp     [_JSABut2],0
;        je      @CalCentre
;        jmp     @CentreWaitbutton
;@CalCentre:        
        mov     ax,[_JSAX]
        mov     [_JSACentreX],ax
        mov     ax,[_JSAY]
        mov     [_JSACentreY],ax
        pop     ax
        ret
ENDP

 
END 
 
 
 
 
 
 
 
