#ifndef _VGA16_H_
#define _VGA16_H_

#ifdef __cplusplus
extern "C" {    /* Use C linkage when in C++ mode */
#endif


#include <mytypes.h>

/*
  Set/get pixel values in VGA 16-color graphics mode with values in *src/dest.
  The pixel line set is horizontal starting at (x,y) and line is xlen
  pixels long.
  Taken from book by Wilton p.142 and p.96 and reworked for efficiency.
  Requires a call to VGAinit to be made prior to calling this routine.
  Does not work when VGAinit is called a priori
*/
void  VGA16drawLine( int x, uchar *videoAdrs, int xlen, uchar *src );
void  VGA16getLine(  int x, uchar *videoAdrs, int xlen, uchar *dest );

/* Draw/get blocks in 640x480 16 color mode.
*/
int  VGA16drawBlock( int x, int y, int xlen, int ylen, uchar *src );
int  VGA16getBlock( int x, int y, int xlen, int ylen, uchar *dest );
int  VGA16drawTranspBlock( int x, int y, int xlen, int ylen, uchar *src );

void VGA16setTransparent( int flag );

/* Primitives for HW control
*/
void VGA16selectBitPlane( char bitPlane );
void VGA16setupRegs( void );
void VGA16resetRegs( void );


#ifndef  VGA16_PACKAGE

extern uchar  VGA16getBitMask[];

#endif


#ifdef __cplusplus
};
#endif

#endif
