#ifndef _PM_H_
#define _PM_H_

#ifdef __cplusplus
extern "C" {    /* Use C linkage when in C++ mode */
#endif

#include <mytypes.h>



typedef struct    /* Real mode memory management */
{
  ushort selector;
  ushort segment;
} PM_REALPTR;



/* Real mode call structure used by the DPMI interface
*/
typedef struct
{
  long  EDI, ESI, EBP, reserved;
  long  EBX, EDX, ECX, EAX;
  short flags;
  short ES, DS, FS, GS, IP, CS, SP, SS;
} PM_RMI;



void  *PMgetLinearAddr( uint base, uint limit);
void  far *PMallocDosMem( unsigned bytes, PM_REALPTR *ptr );
void  PMfreeDosMem( PM_REALPTR * ptr );
void  PMcleanup( void );


#ifdef __cplusplus
};
#endif

#endif
