#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <graph.h>
#include <conio.h>
#include <io.h>
#include <fcntl.h>
#include <time.h>

#include <vmouse.h>
#include <svga.h>
#include <pragmas.h>
#include <gtxt.h>
#include <int.h>

#include "button.h"
#include "ball.h"

static int  ReadFileRaw( char *name, short mode );
static int  Scale( void );
static int  ShowXY( uint x, uint y );
static void ColorStrips( int xres, int yres );
static VMOUSEcurShape  *GetMyCursor( void );
static int  ToggleTime( int x, int y );
static int  ToggleSquare( int );
static int  RandomIt( int iLimit );
static void DoAnimation();

int main( int, char ** );

#define TabSiz  2
static char *Images[ TabSiz ] = 
{
  "earth.raw",  "shuttle.raw"
};
static int curTab[] =
{
  VMOUSEcurPointer,  VMOUSEcurClock,  VMOUSEcurQuestion,  VMOUSEcurCrossHair,
  VMOUSEcurHand
};
static int curCnt=1;



int main( int argc, char **argv )
{
  int  c, x, y, xlen, ylen;
  uint event, butDown = 0;
  int  linear = 0, status, key = 0;
  int  iusewatcom = 0;
  char buf[100];
  VMOUSEinitType  initT;

//  ushort mode = _SVRES256COLOR;  /* 800*600x256 */
  ushort mode = _VRES256COLOR;  /* 640*480x256 */
//  ushort mode = _SVRES16COLOR;  /* 800*600x16 */
//  ushort mode = _VRES16COLOR;  /* 640*480x16 */

  if ( argc == 1 )
  {
    printf("Usage: %s videomode [linearframebuf]\n", argv[0] );
    exit(0);
  }
  if ( argc >= 2 )   mode = (short )atoi( argv[1] );
  if ( argc == 3 )   linear = atoi( argv[2] );

/*
  initT.UseLFB = linear;
  initT.SetVideoMode = 1;
  if ( VMOUSEinit( mode, &initT, 0, 0, 0, 0 ) != EXIT_SUCCESS )
*/
  iusewatcom = 0;
  if ( SVGAinit( mode, iusewatcom, linear, 1, &status ) != EXIT_SUCCESS )
  {
    _setvideomode(3);
    printf("SVGAinit failed with reason [%d]\n", status );
    SVGAfailPrint( status );
    exit(-2);
  }
  initT.UseWatcomLib = 0;
  initT.UseLFB = linear;
  initT.SetVideoMode = 0;
  if ( VMOUSEinit( mode, &initT, 0, 0, 0, 0 ) != EXIT_SUCCESS )
  {
    _setvideomode(3);
    printf("Mouse init failed.\n");
    exit(-1);
  }
  SVGAgetVideoRes( &xlen, &ylen );
  VMOUSEsetPos( xlen/2, ylen/2 );
  key = RandomIt( TabSiz );   /* Pick an image from the table */
  ReadFileRaw( Images[ key ], mode );
  ColorStrips( xlen, ylen );
  BUTTONinit( xlen-145, ylen*8/10-20 );
  VMOUSEshow();

  for (;;)
  {
    if ( kbhit()) 
    {
      if (( c = getch()) == 0 )
        c = getch();
      if ( c == ' ' || c == 'q' )   break;
    }
    event = VMOUSEgetEvent( &x, &y );   /* Get mouse event */
    if ( event == 0 )    continue;

    if ( ToggleTime( x, y ))  ToggleSquare( 1 );
    else                      ToggleSquare( 0 );

    /* You can take action on both button press and release
    */
    if ( event & VMOUSEleftPres )
    {
      if (status = BUTTONcheck( x, y, event ))
      {
        status &= ~BUTTONedit;
        if ( status == 1 )
        {
          VMOUSEsetCursor( curTab[ curCnt++ ] );
          if ( curCnt == 5 )   curCnt = 0;
        }
      }
    }
    else if ( event & VMOUSEleftRele )
    {
      if ( status = BUTTONcheck( x, y, event ))
      {
        status &= ~BUTTONedit;
        if ( status == 0 )
          DoAnimation();
        else if ( status == 2 )  // quit
        {
          (void )VMOUSEgetEvent( &x, &y );  // flush queue
          break;
        }
      }
    }
    else if ( event & VMOUSEmidRele )
    {
      VMOUSEsetCustomCursor( BALLcursor());
    }
    else if ( event & VMOUSErightPres )
    {
      DoAnimation();

#ifdef OLD

//      if ( VMOUSEsetCustomCursor( GetMyCursor()) != EXIT_SUCCESS )
//        break;

      VMOUSEsetCustomCursor( BALLcursor());
#endif
    }
    ShowXY( x, y );
  }

  VMOUSEhide();
  VMOUSErestore();
  _setvideomode( 3 );

  return 0;
}


static void  DoAnimation()
{
  SetupAnim();

  cMessage( "Snoooozing.." );  // Emulate machine busy..
  sleep( 5 );      // like saving to disk or working out an FFT
  cMessage( "Waking up..." );

  VMOUSEhide();
  VMOUSEanimateCurStop();
  VMOUSEsetCursor( curTab[ curCnt ] );
  VMOUSEshow();
}



extern VMOUSEcurShape   *HourGlassCur1( void );
extern VMOUSEcurShape   *HourGlassCur2( void );
extern VMOUSEcurShape   *HourGlassCur3( void );
extern VMOUSEcurShape   *HourGlassCur4( void );

static int   SetupAnim()
{
  VMOUSEcurShape cs[4], *c;
  c = HourGlassCur1();  cs[0] = *c;
  c = HourGlassCur2();  cs[1] = *c;
  c = HourGlassCur3();  cs[2] = *c;
  c = HourGlassCur4();  cs[3] = *c;
  return ( VMOUSEanimateCursor( cs, 4, 8, TRUE ));
}



static int ShowXY( uint x, uint y )
{
  char buf[100];

  GTXTgotoxy( 0, 23 );
  GTXTsetForeground( 14 );
  sprintf( buf, "Mouse pos: %d, %d   ", x, y );
  GTXTouttext( buf );
/*
  _settextposition( 22, 1 );
  _settextcolor( 14 );
  sprintf( buf, "Mouse pos: %d, %d    ", x, y );
  _outtext( buf );
*/
  return 0;
}

static int cMessage( char *buf )
{
  GTXTgotoxy( 0, 24 );
  GTXTsetForeground( 14 );
  GTXTouttext( buf );
  return 0;
}


#define  MENUCOLW   8
#define  MENUHGT   10

static void ColorStrips( int xres, int yres )
{
  int  x, y, i, j, color;
  y = yres - 40, x = 0;
  for ( color=0, i=0; i < 320/MENUCOLW; i++, color++ )
  {
    for ( j=0; j < MENUHGT; j++ )
    {
      SVGAmoveto( x+i*MENUCOLW, y+j );
      SVGAlineto( x+i*MENUCOLW+MENUCOLW, y+j, color );
    }
  }

  y += MENUHGT, x = 0;
  for ( i=0; i < 320/MENUCOLW; i++, color++ )
  {
    for ( j=0; j < MENUHGT; j++ )
    {
      SVGAmoveto( x+i*MENUCOLW, y+j );
      SVGAlineto( x+i*MENUCOLW+MENUCOLW, y+j, color );
    }
  }
}




/* Read raw file into video memory
*/
static int  ReadFileRaw( char *name, short mode )
{
  int  fd, x, y;
  uchar *buf, *buf2;
  int    width, height, iSiz;
  uchar  palette[256*3];
  SVGAdata *sd;

  if (( fd = open( name, O_BINARY | O_RDONLY, 0644 )) != -1 )
  {
    read( fd, (char *)&width, sizeof( int ));
    read( fd, (char *)&height,sizeof( int ));
    read( fd, (char *)palette, 3*256 );
    if ( width < 2000 && height < 2000 && 
         width > 0    && height > 0)
    {
      iSiz = height * width;   /* Assume file OK */
      if (( buf = (uchar *)malloc( iSiz )) != NULL )
      {
        if ( read( fd, (uchar *)buf, iSiz ) == iSiz )
        {
          if ( SVGAisTrueColorMode() || SVGA16colorMode( mode ))
          {
            /* True color conversion
             */
            buf2 = buf;
            buf = SVGAbufferConvert( buf2, width, height );
            free( buf2 );
            if ( buf == NULL )
              return -1;
          }
          sd = SVGAgetData();
          x = max( 0, sd->XPixels - width );
          y = max( 0, sd->YPixels - height );
          (void )SVGAdrawBlock( x, y, width, height, buf );
        }
        else
          putch(7), putch(7);
        free(buf);
      }
    }
    else
      putch(7);
    close( fd );
  }
  return 0;
}




#define MY_C_X 150
#define MY_C_Y 150

static uchar  szCursor[MY_C_X*MY_C_Y];
static VMOUSEcurShape  *GetMyCursor( void )
{
  static VMOUSEcurShape  shape;
  int i, j;

  for ( i=0; i < MY_C_Y; i++ )
  {
    j = i % 15;
    memset( &szCursor[i*MY_C_X], j, MY_C_X );
  }

  shape.buf = szCursor;
  shape.xsiz = MY_C_X;
  shape.ysiz = MY_C_Y;
  shape.xhot = MY_C_X/2;
  shape.yhot = MY_C_Y/2;

  return &shape;
}




#define SQ_LEN   50
#define T_X     100
#define T_Y      80


static int  ToggleTime( int x, int y )
{
  return ( x >= T_X && x < (T_X+SQ_LEN) &&
           y >= T_Y && y < (T_Y+SQ_LEN) );
}



static int  ToggleSquare( int On )
{
  static int isOn = 0;
  static uchar *red = NULL;
  static uchar *back;

  if ( red == NULL )
  {
    if (( red = (uchar *)malloc( SQ_LEN*SQ_LEN )) == NULL )
      return -1;
    if (( back= (uchar *)malloc( SQ_LEN*SQ_LEN )) == NULL )
      return -1;
    memset( red, 4, SQ_LEN*SQ_LEN );

    if ( SVGAisTrueColorMode())
    {
      /* True color conversion
      */
      uchar *tmp = red;
      red = SVGAbufferConvert( tmp, SQ_LEN, SQ_LEN );
      free( tmp );
      free( back );
      back = SVGAbufferAlloc( SQ_LEN, SQ_LEN );
      if ( red == NULL || back == NULL )
        return -1;
    }
  }

  if ( On && !isOn )
  {
    isOn = 1;
    VMOUSEhide();
    (void )SVGAgetBlock(  T_X, T_Y, SQ_LEN, SQ_LEN, back );
    (void )SVGAdrawBlock( T_X, T_Y, SQ_LEN, SQ_LEN, red );
    VMOUSEshow();
  }
  else if ( !On && isOn )
  {
    isOn = 0;
    VMOUSEhide();
    (void )SVGAdrawBlock( T_X, T_Y, SQ_LEN, SQ_LEN, back );
    VMOUSEshow();
  }
  return 0;
}




static int  RandomIt( int iLimit )
{
  long l, l2;
  l = time( NULL );
  l2 = l % iLimit;
  return (int )l2;
}




/* Scale up the original picture by the scale factor
*/
static int Scale( void )
{
#ifdef  SCALE

  uchar  *src, *result;
  int     xl, yl, nxl, nyl, nx, ny, x, y, i, j, nys, ys, intr;
  float   tempx, tempy, scale, inv_scale;
  char    buf[100];

  xl = 320, yl = 170;   /* Original image size */
  scale = 1.4;          /* Scale to get new image */

  tempx = xl*scale;  tempy = yl*scale;
  nxl = (int )tempx;  nyl = (int )tempy;

  if (( src = (uchar *)malloc( 320*170 )) == NULL )
    return -1;
  if (( result = (uchar *)calloc( 1, nxl*nyl )) == NULL )
    return -2;
  SVGAgetBlock( 0, 0, 320, 170, src );

  inv_scale = 1. / scale;
  for ( intr=0, ny=0; ny < nyl; ny++ )
  {
    if ( kbhit())
    {
      intr = 1;
      break;
    }
    tempy = ny * inv_scale;   y = (int )tempy;
    nys = ny*nxl;
    ys  = y*xl;

    tempx = 0;
    for ( nx=0; nx < nxl; nx++ )    
    {
/*      tempx = nx * inv_scale;  */  x = (int )tempx;
      tempx += inv_scale;

      i = nys + nx;
      j = ys + x;
      result[ i ] = src[j];
    }
  }
  if ( !intr )
    SVGAdrawBlock( 0, 0, nxl, nyl, result );

  free( src );
  free( result );

#endif

  return 0;
}
