/* Package definitions for drawing functions based on Watcom standard libraries

   The library package has been compiled with the foll. switches:
      CC=wcc386
      CFLAGS= -3s -zq -bt=dos4g -j -oil+ -ort -oau -s -e6
*/

#ifndef _WVGA_H_
#define _WVGA_H_

#ifdef __cplusplus
extern "C" {    /* Use C linkage when in C++ mode */
#endif

#include <mytypes.h>

#ifndef TRUE
#define TRUE   1
#define FALSE  0
#endif

/*
  The WVGAdrawBlock function copies the content of the srcBlock buffer
  to the display starting at (startx, starty) and the size of the
  displayed rectangle is xlen in x and ylen in y.
  The WVGAdrawTranspBlock is similar, but draws only the non-null pixel
  values in the source buffer.
  The WVGAgetBlock is the opposite of WVGAdrawBlock.
  WVGAgetData can be called after init to check various current mode
  parameters. See the WVGAdata data structure above.
  The WVGAfailPrint function can be used to print status message output
  by the WVGAinit function via the status parameter.
  The WVGAsetResolution is used to enable proper clipping.
*/

int  WVGAdrawBlock( int startx, int starty,
                    int xlen,   int ylen,   uchar *srcBlock );
int  WVGAdrawTranspBlock( int startx, int starty,
                          int xlen,   int ylen, uchar *srcBlock );
int  WVGAgetBlock( int startx, int starty,
                   int xlen,   int ylen,   uchar *destBlock );
void WVGAsetResolution( int XPixels,  int YPixels );

/* Miscellaneous routines
*/
#ifdef NOT_YET

void  WVGAputPixel( int x, int y, uchar color );
int   WVGAgetPixel( int x, int y );
void  WVGAmoveto( int x, int y );
void  WVGAlineto( int x, int y, uchar Color );
int   WVGAfailPrint( int reason );

#endif

#ifdef __cplusplus
};
#endif

#endif
