/*
   This package contains the functions to implement a Watcom library-based
   variant of the block copy operations found in SVGA.c
   The code in here was mostly used for debugging since it will work
   in any video mode supported by Watcom's run-time library.

   Written by Arve Holmbo.
   Released to public domain March 1996.
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <graph.h>

#include "pragmas.h"
#include "wvga.h"

#pragma inline _setcolor;

static ushort wwidth=320, wheight=200;  /* Some nominal values for resolution*/



/* Draw to display the block, starting at x, y.
   Length of each line in the block is xlen.

   It is a pity that Watcom's _putimage routine could not be used to
   copy stuff from main memory to video memory.
 */
int  WVGAdrawBlock( int x, int y, int xlen, int ylen, uchar *src )
{
  register int i, j;
  int  xclip = min( xlen, wwidth - x );
  int  yclip = min( ylen, wheight- y );
  if ( xclip <= 0 || yclip <= 0 )  return EXIT_FAILURE;

  for ( i=0; i < yclip; i++, y++ )
  {
    for ( j=0; j < xclip; j++ )
    {
      _setcolor( src[j] );     /* Slow..  */
      _setpixel( x+j, y );     /* ..but steady */
    }
    src += xlen;
  }
  return  EXIT_SUCCESS;
}




/* Draw pixels from the src that are not NULL.  This differs from
   SVGAdrawBlock only in the way pixels are drawn.  The effect is that
   when a rectangle with zero pixels in it is drawn the background
   pixels are not overwritten by a null-pixel in the source.
   This can be used to draw any sprite shape on the screen.
*/
int  WVGAdrawTranspBlock( int x, int y, int xlen, int ylen, uchar *src )
{
  static uchar *dest = NULL;
  static int len;
  register int  i;

  if ( dest == NULL )
  {
    len = xlen * ylen;
    dest = (uchar *)malloc( len );
  }
  else if ( len != xlen * ylen )
  {
    len = xlen * ylen;
    dest = (uchar *)realloc( dest, len );
  }
  if ( dest == NULL )
  {
    putch(7);
    return EXIT_FAILURE;
  }

  if ( WVGAgetBlock( x, y, xlen, ylen, dest ) == EXIT_SUCCESS )
  {
    /* Fill in source pixels */ 
    for ( i=0; i < len; i++ )   if ( src[i] != 0 )  dest[i] = src[i];

    return WVGAdrawBlock( x, y, xlen, ylen, dest );
  }
  return EXIT_FAILURE;
}





/* Get from display the block, starting at x, y.
   Length of each line in the block is xlen.
   Opposite function of WVGAdrawBlock
 */
int  WVGAgetBlock( int x, int y, int xlen, int ylen, uchar *dest )
{
//  _getimage((short )x, (short )y, (short )(x+xlen), (short )(y+ylen),
//      (char *)dest );
  register int i, j;

  int  xclip = min( xlen, wwidth - x );
  int  yclip = min( ylen, wheight- y );
  if ( xclip <= 0 || yclip <= 0 )  return EXIT_FAILURE;

  for ( i=0; i < yclip; i++, y++ )
  {
    for ( j=0; j < xclip; j++ )  dest[ j ] = _getpixel( x+j, y );
    dest += xlen;
  }
  return EXIT_SUCCESS;
}



/* Store display resolution
*/
void   WVGAsetResolution( ushort XPixels, ushort YPixels )
{
  wwidth = XPixels;
  wheight= YPixels;
}
