/*
   Common VGA routines that should work in all video modes
   Written by Arve Holmbo.
   Released to public domain March 1996.
*/

#include <conio.h>
#include <string.h>

#include "vga.h"


/*
 *  VGAsetPal:  Function to set palette values in VGA color modes
 *  VGAgetPal:  Function to get palette values.
 */
void  VGAsetPal( int index, int howmany, uchar *pals, uchar backgrnd )
{
  /*
   * index tells the color index in the range  0{color}255
   * howmany tells how many colors to set palette values for
   * pals is pointer to palette values
   * backgrnd gives the background color
   */
  uchar ind = (uchar  )index;
  uint  howm = howmany*3;

  extern void setPal( uchar ind, int howm, uchar *pals, uchar backg );

#pragma aux setPal =  \
  "mov  dx, 03dah" /* input status for vertical retrace */\
 "WaitVs: in al, dx" \
  "test al, 8"     \
  "jz   WaitVs"    \
\
  "mov  dx, 03c6h" /* Set palette register mask */\
  "mov  al, 0ffh"  \
  "out  dx, al"    \
\
  "mov  al, ah"    /* index */\
  "mov  dx, 03c8h" \
  "out  dx, al"    \
  "mov  dx, 03c9h" \
  "rep  outsb"     \
  modify [dx al]   \
  parm [ah][ecx][esi][bh];

  setPal( ind, howm, pals, backgrnd );
}



/* Set palette function for GIF viewer
*/
void  VGAsetGIFpal( int index, int howmany, uchar *pals, uchar backgrnd )
{
  /*
   * index tells the color index in the range  0{color}255
   * howmany tells how many colors to set palette values for
   * pals is pointer to palette values
   * backgrnd gives the background color
   */
  int  i;
  uchar ind = (uint )index;
  uint  howm = howmany*3;
  uchar *p = pals;

  VGAwaitVertRetrace();
/*   old code, new code for GIF viewer
  outp( 0x3C6, 0xFF );
  outp( 0x3C8, index );
  for ( i=0; i < (howmany*3); i++ )
    outp( 0x3C9, (*p++) & 0x3F );
*/
  outp( 0x3C6, 0xFF );
  for ( i=0; i < howmany; i++ )
  {
    outp( 0x3C8, i );
    outp( 0x3C9, (*p++) >> 2 );
    outp( 0x3C9, (*p++) >> 2 );
    outp( 0x3C9, (*p++) >> 2 );
  }
/*
  _asm {
    mov  ax, 1001h
    mov  bh, backgrnd
    int  10h
  }
*/
}



/*
 * Read the palette values starting at color = index
 */
void  VGAgetPal( int index, int howmany, uchar *pals )
{
  uchar ind = index;
  uint  howm = howmany*3;
  uint  i;

#ifdef TOO_FAST
  extern void getPal( uchar ind, int howm, uchar *pals );

#pragma aux getPal = \
  "mov  dx, 3C7h" \
  "out  dx, al"   \
  "mov  dx, 3C9h" \
  "cld"           \
  "rep insb"       /* Input the palette values in one burst */\
  parm [al][ecx][edi] \
  modify [al dx ecx];

  getPal( ind, howm, pals );
#else

  outp( 0x3C7, ind );
  for ( i=0; i < howm; i++ )
    pals[i] = inp( 0x3C9 );

#endif
}



/* Fade in the picture by manipulating the palette values
*/
void  VGAfadeIn( uchar *pals )
{
  register uint j, pal;
  int           i;
  uchar         startPal[ 3*256 ];

  memset( startPal, 0, 3*256 );
  VGAscreenOff();
  VGAsetPal( 0, 256, startPal, 0 );
  VGAscreenOn();
  for ( i=0; i < 256; i+=2 )
  {
    for ( j=0; j < 3*256; j++ )
    {
      pal = pals[ j ] * i;
      pal = pal / 256;
      startPal[ j ] = pal;
    }
    VGAsetPal( 0, 256, startPal, 0 );
  }
}



/* Fade out the picture by manipulating the palette values
*/
void  VGAfadeOut( void )
{
  uchar startPal[ 3*256 ], pals[ 3*256 ];
  uint  pal;
  int   i, j;

  VGAgetPal( 0, 256, pals );
  for ( i=255; i > 0; i-=2 )
  {
    for ( j=0; j < 3*256; j++ )
    {
      pal = pals[ j ] * i;
      pal = pal / 256;
      startPal[ j ] = pal;
    }
    VGAsetPal( 0, 256, startPal, 0 );
  }
}



/*
  Turn off display while graphics memory update (to speed this up)
  This turns off the display so that all the graphics memory cycles
  go to the CPU
*/
void  VGAscreenOff( void )
{
  extern void screenOff( void );
#pragma aux screenOff = \
  "mov  dx, 3C4h"      /* R/W sequencer clocking mode */\
  "mov  ax, 2101h"     /* 00100001 out to register 1 */\
  "out  dx, ax"   \
  modify [ax dx];

  screenOff();
}



/*
  Turn screen back on again.  The converse of VGAscreenOff
*/
void  VGAscreenOn( void )
{
  extern void screenOn( void );
#pragma aux screenOn = \
  "mov  dx, 3C4h" \
  "mov  ax, 101h"    /* 00000001  out to register 1 */\
  "out  dx, ax"   \
  modify [ax dx];

  screenOn();
}






/* Wait for the vertical video retrace to occur
*/
void  VGAwaitVertRetrace( void )
{
  extern void waitRetrace( void );

#pragma aux waitRetrace = \
     "mov  dx, 3DAh" \
 "l1: in   al, dx"   \
     "and  al, 8"    \
     "jnz  l1"       \
 "l2: in   al, dx"   \
     "and  al, 8"    \
     "jz   l2"       \
  modify [al dx];
  waitRetrace();
}


