/*
   This package contains code to define parts of memory as
   non-swappable.

   Written by Arve Holmbo.
   Released to public domain March 1996.
*/

#include <dos.h>
#include <conio.h>
#include <i86.h>

#pragma off (check_stack)
#pragma off (loop_opt)

#include "lock.h"


/* Function to lock areas in memory against being swapped to disk
   during VMM execution.  If can't lock, then zero is returned
   */
int LOCKregion( void *address, unsigned length )
{
  union REGS regs;
  unsigned linear;

  /* Thanks to DOS/4GW's zero-based flat memory model, converting
    a pointer of any type to a linear address is trivial.
  */
  linear = (unsigned) address;

  regs.w.ax = 0x600;      /* DPMI Lock Linear Region */
  regs.w.bx = (unsigned short) (linear >> 16); /* Linear address in BX:CX */
  regs.w.cx = (unsigned short) (linear & 0xFFFF);
  regs.w.si = (unsigned short) (length >> 16); /* Length in SI:DI */
  regs.w.di = (unsigned short) (length & 0xFFFF);
  int386 (0x31, &regs, &regs);
  return (! regs.w.cflag);    /* Return 0 if can't lock */
}
