/* This package provides a generic interface to install interrupt
   handlers to service interrupt 8.  Compile with watcom using the
   /od switch to disable optimizations, this should be considered
   driver code.
   */
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <i86.h>

#include "mytypes.h"
#include "int.h"

#pragma off ( check_stack );
#pragma off ( loop_opt );
#pragma off ( check_pointer );   /* No pointer checking */

#define  INT_VECT   0x8   /* HW interrupt vector */

static volatile void   (*CallBack)( void ) = NULL;
static volatile short  _ds_seg_app, _es_seg_app, _ss_seg_app;
static volatile short  _ds, _es, _ss;

static int    set = 0;
static void   (__interrupt __far *OldISR)();

/* Code to set up segment registers in the ISR
*/
extern void    _SetSegments( short _ds, short _es, short _ss );
#pragma inline _SetSegments;
#pragma aux    _SetSegments =\
  "cli" "mov  ds, ax" "mov  es, bx" "mov  ss, cx" "sti"  parm [ax][bx][cx];
extern short   _GetDS( void );
extern short   _GetES( void );
extern short   _GetSS( void );
#pragma inline _GetDS;
#pragma aux    _GetDS =  "mov  ax, ds"  value [ax];
#pragma inline _GetES;
#pragma aux    _GetES =  "mov  ax, es"  value [ax];
#pragma inline _GetSS;
#pragma aux    _GetSS =  "mov  ax, ss"  value [ax];

static void interrupt  ISR_8( void )
{
  if ( CallBack != NULL )
  {
    _ds = _GetDS();   /* Use application's segment register values */
    _es = _GetES();   /* otherwise we can't call regular funcs from here */
    _ss = _GetSS();
    _SetSegments( _ds_seg_app, _es_seg_app, _ss_seg_app );
    (*CallBack)();
    _SetSegments( _ds, _es, _ss );   // done, so reset registers
  }
  _chain_intr( OldISR );
}
static void dummy()  { }



/* Install custom callback function to be called
   by the keyboard HW ISR
   */
int  INTinit( void (*CallbackFunc)( void ) )
{
  if ( !set )
  {
    if ( atexit( INTend ) != 0 )  return  EXIT_FAILURE;

    if ( LOCKregion((void near *)ISR_8,
                    (char *)dummy - (char near *)ISR_8 ))
    {
      _ds_seg_app = _GetDS();   /* Get application segment regs */
      _es_seg_app = _GetES();
      _ss_seg_app = _GetSS();
      CallBack = CallbackFunc;  /* Set up callback function */
      OldISR = _dos_getvect( INT_VECT );
      _dos_setvect( INT_VECT, ISR_8 );

      set = 1;
      return  EXIT_SUCCESS;
    }
  }
  return  EXIT_FAILURE;
}



/* Terminate keyboard driver
*/
void  INTend( void )
{
  if ( set )
  {
    set = 0;
    _dos_setvect( INT_VECT, OldISR );
  }
}

/* EOF */
