/* Unit to implement text in graphics modes.  It uses the font
   stored in the BIOS area (intended used in mode 13h) and
   the SVGA interface to output blocks of text in the current
   graphics mode.
   */
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>

#include <svga.h>
#include <mytypes.h>
#include <pragmas.h>

static void  RomToChar( uchar  Char, char *buffer, int len );
static void  PutString( uchar *str );

static int    tx=0;
static int    ty=0;
static uchar  Backg = 0;
static uchar  Foreg = 15;
static int    Transp = 0;

#define  TW  8
#define  TH  8

/* Output text at current text location
*/
void  GTXTouttext( uchar *str )
{
  static char *block = NULL;
  static int   scanlinelen, maxnumchar;

  int    textlen, i;
  uchar *p;
  SVGAdata *sd;

  textlen = strlen( str ) * TW;   // length in num. of pixels
  sd      = SVGAgetData();

  if ( block == NULL )        // Make sure our text block is large enough
  {
    scanlinelen = sd->XPixels;
    maxnumchar  = scanlinelen / TW;
    block = (char *)malloc( scanlinelen * TH );
  }
  else if ( scanlinelen != sd->XPixels )
  {
    scanlinelen = sd->XPixels;
    maxnumchar  = scanlinelen / TW;
    block = realloc( block, scanlinelen * TH );
  }

  textlen = min( textlen, scanlinelen );
  for ( i=0; str[i] && i < maxnumchar; i++ )
    RomToChar( str[i], &block[i*TW], textlen );

  if ( SVGAisTrueColorMode())
  {
    /* True color conversion
    */
    uchar *buf2 = block;
    block = SVGAbufferConvert( buf2, textlen, TH );
    free( buf2 );
  }
  SVGAdrawBlock( tx, ty, textlen, TH, block );

  ty += TH;   // Goto next line
  if ( ty >= sd->YPixels )  ty = 0;   // Back to top
  tx = 0;
}




static uchar  buff[ 8*8 ];
#define romFont   (uint )0xFFA6E   // This is where it is located

/* Read characters from ROM and convert to 8x8 character cells
*/
static void  RomToChar( uchar  Char, char *buffer, int len )
{
  int   i, j, offs = (int )Char * 8;
  register uchar *src, *dest;
  uchar  mask;

  dest = buffer;
  src  = (uchar *)(romFont + offs);

  for ( i=0; i < 8; i++, src++ )
  {
    for ( mask = 0x80, j=0; j < 8; j++, dest++ )
    {
      if ( *src & mask )  *dest = Foreg;
      else if ( !Transp ) *dest = Backg;
      mask >>= 1;
    }
    dest += len-8;   // Advance to next scanline in buffer */
  }
}




/*  Put imaginary text cursor at given text coordinates
*/
void  GTXTgotoxy( int x, int y )  {  tx = x*TW;  ty = y*TH;  }

/* Set text background color, return previous one
*/
uchar GTXTsetBackground( uchar newCol )
{  uchar old = Backg;  Backg = newCol;  return old;  }

/* Set text foreground color, return previous one
*/
uchar GTXTsetForeground( uchar newCol )
{  uchar old = Foreg;  Foreg = newCol;  return old;  }

/* Set transparence mode on/off.  If on then the text background
   will not be set to the background color (or any other)
*/
void  GTXTsetTransparent( int on )  {  Transp = on;  }
