/* Compiling: bcc -ml view.c        */
/* All code is not from my own head */
/* Made by Antti Sinkman            */

typedef unsigned char byte;
typedef unsigned int word;

#include <dos.h>         
#include <stdio.h>       
#include <alloc.h>       

void wtsync( void );
void BlackPal( void );
void FadeOut( char *pal );
void FadeIn( char *pal );          
void GetPal( FILE *fp, char *pal );     
void Show( char *buffer, unsigned int width, unsigned int height );
void SetMode( int mode );
void getch( void );              

char *screen = (char *) 0xA0000000; 
typedef struct tagPCXHEAD           
{
    char manufacturer;
    char version;
    char encoding;
    char bits_per_pixel;
    int xmin, ymin;
    int xmax, ymax;
    int hres;
    int vres;
    char palette[48];
    char reserved;
    char color_planes;
    int bytes_per_line;
    int palette_type;
    char filler[58];
} PCXHEAD;

void main( int argc, char *argv[] )
{
    unsigned char pal[768];
    int byte1, byte2;
    int version, planes, bits;
    unsigned int width, height, image_bytes, i;
    char *buffer;
    PCXHEAD pcxh;
    FILE *pcx;
    printf( "PCX Viewer 1.0, Antti Sinkman 1996\n\n" );
    if( argc != 2 )
    {
        printf( "Usage: VIEW pcxfile\n" );
        return;
    }
    pcx = fopen( argv[1], "rb" );            
    if( !pcx )                               
    {
        printf( "Can't open file\n" );
        return;
    }
    fread( (char *) &pcxh, 1, sizeof( PCXHEAD ), pcx );
    if( pcxh.manufacturer != 10 )        
    {                                    
        printf( "This is not PCX file\n" );
        return;
    }
    version = pcxh.version;
    planes = pcxh.color_planes;
    bits = pcxh.bits_per_pixel;
    width = pcxh.xmax - pcxh.xmin + 1;      
    height = pcxh.ymax - pcxh.ymin + 1;
    image_bytes = width * height;
    if( pcxh.color_planes != 1 || pcxh.bits_per_pixel != 8 || width > 320 || height > 200 )
    {
        printf( "Unknown format\n" );
        return;
    }
    GetPal( pcx, pal );           
    buffer = malloc( image_bytes );
    fseek( pcx, 128, SEEK_SET );       
    i=0;
    while( i<image_bytes )
    {
        byte1 = fgetc( pcx );
        if( byte1 > 192 )
        {
            byte2 = fgetc( pcx );
            for( ; byte1>192; byte1-- )
                buffer[i++] = byte2;
        }
        else
            buffer[i++] = byte1;
    }
    printf( "Image Dimensions: %d x %d\n", width, height );
    printf( "Version         : %d\n", version );
    printf( "Color Planes    : %d\n", planes );
    printf( "Bits per Pixel  : %d\n", bits );
    printf( "\nPress any key to see the picture..." );
    getch();
    for( i=0; i<768; i++ ) pal[i] = pal[i] >> 2;
    SetMode( 0x13 );           
    BlackPal();
    Show( buffer, width, height ); 
    FadeIn( pal );             
    getch();                   
    FadeOut( pal );
    free( buffer );            
    SetMode( 0x03 );
    printf( "PCX Viewer 1.0, Antti Sinkman 1996\n" );
}

void GetPal( FILE *fp, char *pal )
{
    fseek( fp, -768, SEEK_END );
    fread( pal, 1, 768, fp );
}

void FadeIn( char *pal )
{
    word i,j, r, g, b;
    byte pal2;
    for( j=0; j<64; j++ )
    {
        wtsync();
        outportb( 0x3c8, 0 );
        for( i=0; i<768; i++ )
        {
            pal2 = pal[i] * j/64;
            outportb( 0x3c9, pal2 );
        }      
    }
}

void SetMode( int mode )
{
    union REGS r;
    r.x.ax = mode;
    int86( 0x10, &r, &r );
}

void Show( char *buffer, unsigned int width, unsigned int height )
{
    int xx, yy, temp;
    for( yy=0, temp=0; yy<height; yy++ )
        for( xx=0; xx<width; xx++, temp++ )
            screen[ (yy<<8) + (yy<<6) +xx ] = buffer[temp]; 
}

void getch( void )
{
    asm
    {
        mov     al,0
        mov     ah,1
        int     21h
    }
}

void BlackPal( void )
{
    word i;
    outportb( 0x3c8, 0 );
    for( i=0; i<768; i++ )
        outportb( 0x3c9, 0 );
}

void wtsync( void )
{
    while( (inportb( 0x3da ) & 8) != 0 );
    while( (inportb( 0x3da ) & 8) == 0 );
}    

void FadeOut( char *pal )
{
    int i,j;
    byte pal2;
    for( j=63; j>(-1); j-- )
    {
        wtsync();
        outportb( 0x3c8, 0 );
        for( i=0; i<768; i++ )
        {
            pal2 = pal[i] * j/64;
            outportb( 0x3c9, pal2 );
        }
    }
}
