/*------------------------------------------------------------*/
/* filename -       tview.cpp                                 */
/*                                                            */
/* function(s)                                                */
/*                  TView member functions                    */
/*------------------------------------------------------------*/

/*------------------------------------------------------------*/
/*                                                            */
/*    Turbo Vision -  Version 1.0                             */
/*                                                            */
/*                                                            */
/*    Copyright (c) 1991 by Borland International             */
/*    All Rights Reserved.                                    */
/*                                                            */
/*------------------------------------------------------------*/

#define Uses_TKeys
#define Uses_TView
#define Uses_TCommandSet
#define Uses_TPoint
#define Uses_TGroup
#define Uses_TRect
#define Uses_TEvent
#define Uses_TEventQueue
#define Uses_TScreen
#define Uses_opstream
#define Uses_ipstream
#include <tv.h>

#include <dos.h>
#include <limits.h>
#include <string.h>
#include <stdio.h>
#include <go32.h>
#if defined( DJGPP ) && ( DJGPP > 1 )
#include <dpmi.h>
#include <sys/movedata.h>
#define REGS __dpmi_regs
#define INTR(nr,r) __dpmi_int(nr,&r)
#else
#define REGS union REGS
#define INTR(nr,r) int86(nr,&r,&r)
#endif

TPoint shadowSize = {2,1};
uchar shadowAttr = 0x08;
Boolean near TView::showMarkers = False;
uchar near TView::errorAttr = 0xCF;
Boolean near TView::commandSetChanged = False;

extern TView *TheTopView;

static TCommandSet initCommands()
{
    TCommandSet temp;
    for( int i = 0; i < 1024; i++ )
        temp.enableCmd( i );
    temp.disableCmd( cmZoom );
    temp.disableCmd( cmClose );
    temp.disableCmd( cmResize );
    temp.disableCmd( cmNext );
    temp.disableCmd( cmPrev );
    return temp;
}

TCommandSet near TView::curCommandSet = initCommands();

TView::TView( const TRect& bounds) :
    next( 0 ),
    options( 0 ), eventMask( evMouseDown | evKeyDown | evCommand ),
    state( sfVisible ),
    growMode( 0 ), dragMode( dmLimitLoY ), helpCtx( hcNoContext ),
    owner( 0 )
{
    setBounds( bounds);
    cursor.x = cursor.y = 0;
}

TView::~TView()
{
}

void TView::blockCursor()
{
     setState(sfCursorIns, True);
}

#define grow(i) (( (growMode & gfGrowRel)) ? \
                (i = (i * s + ((s - d) >> 1)) / (s - d)) : (i += d))

inline int range( int val, int min, int max )
{
    if( val < min )
        return min;
    else if( val > max )
        return max;
    else
        return val;
}
                
void TView::calcBounds( TRect& bounds, TPoint delta )
{
    bounds = getBounds();

    short s = owner->size.x;
    short d = delta.x;

    if( (growMode & gfGrowLoX) != 0 )
        grow(bounds.a.x);

    if( (growMode & gfGrowHiX) != 0 )
        grow(bounds.b.x);

    s = owner->size.y;
    d = delta.y;

    if( (growMode & gfGrowLoY) != 0 )
        grow(bounds.a.y);

    if( (growMode & gfGrowHiY) != 0 )
        grow(bounds.b.y);

    TPoint minLim, maxLim;
    sizeLimits( minLim, maxLim );
    bounds.b.x = bounds.a.x + range( bounds.b.x-bounds.a.x, minLim.x, maxLim.x );
    bounds.b.y = bounds.a.y + range( bounds.b.y-bounds.a.y, minLim.y, maxLim.y );
}

void TView::changeBounds( const TRect& bounds )
{
    setBounds(bounds);
    drawView();
}

void TView::clearEvent( TEvent& event )
{
    event.what = evNothing;
    event.message.infoPtr = this;
}

Boolean TView::commandEnabled( ushort command )
{
    return Boolean((command > 0x3FF) || curCommandSet.has(command));
}

uint32 TView::dataSize()
{
    return 0;
}

void TView::disableCommands( TCommandSet& commands )
{
    commandSetChanged = Boolean( commandSetChanged ||
                                !(curCommandSet & commands).isEmpty());
    curCommandSet.disableCmd(commands);
}

void TView::disableCommand( ushort command )
{
    commandSetChanged = Boolean( commandSetChanged ||
                                 curCommandSet.has(command) );
    curCommandSet.disableCmd(command);
}

void TView::moveGrow( TPoint p,
                      TPoint s,
                      TRect& limits,
                      TPoint minSize,
                      TPoint maxSize,
                      uchar mode
                    )
{
    TRect   r;
    s.x = min(max(s.x, minSize.x), maxSize.x);
    s.y = min(max(s.y, minSize.y), maxSize.y);
    p.x = min(max(p.x, limits.a.x - s.x+1), limits.b.x-1);
    p.y = min(max(p.y, limits.a.y - s.y+1), limits.b.y-1);

    if( (mode & dmLimitLoX) != 0 )
        p.x = max(p.x, limits.a.x);
    if( (mode & dmLimitLoY) != 0 )
        p.y = max(p.y, limits.a.y);
    if( (mode & dmLimitHiX) != 0 )
        p.x = min(p.x, limits.b.x-s.x);
    if( (mode & dmLimitHiY) != 0 )
        p.y = min(p.y, limits.b.y-s.y);
    r = TRect(p.x, p.y, p.x +  s.x, p.y +  s.y);
    locate(r);
}

extern unsigned short getshiftstate(void);

void TView::change( uchar mode, TPoint delta, TPoint& p, TPoint& s )
{
   unsigned char shiftstate = getshiftstate();
   unsigned char *shiftState = &shiftstate;

    if( (mode & dmDragMove) != 0 && (*shiftState & 3) == 0 )
        p += delta;
    else if( (mode & dmDragGrow) != 0 && (*shiftState & 3) != 0 )
        s += delta;
}

void TView::dragView( TEvent& event,
                      uchar mode,
                      TRect& limits,
                      TPoint minSize,
                      TPoint maxSize
                    )
{
    TRect saveBounds;

    TPoint p, s;
    setState( sfDragging, True );

    if( event.what == evMouseDown )
        {
        if( (mode & dmDragMove) != 0 )
            {
            p = origin - event.mouse.where;
            do  {
                event.mouse.where += p;
                moveGrow( event.mouse.where,
                          size,
                          limits,
                          minSize,
                          maxSize,
                          mode
                        );
                } while( mouseEvent(event,evMouseMove) );
            }
        else
            {
            p = size - event.mouse.where;
            do  {
                event.mouse.where += p;
                moveGrow( origin,
                          event.mouse.where,
                          limits,
                          minSize,
                          maxSize,
                          mode
                        );
                } while( mouseEvent(event,evMouseMove) );
            }
        }
    else
        {
        static TPoint 
            goLeft      =   {-1, 0}, 
            goRight     =   { 1, 0}, 
            goUp        =   { 0,-1}, 
            goDown      =   { 0, 1}, 
            goCtrlLeft  =   {-8, 0}, 
            goCtrlRight =   { 8, 0};
            
        saveBounds = getBounds();
        do  {
            p = origin;
            s = size;
            keyEvent(event);
            switch (event.keyDown.keyCode & 0xFF00)
                {
                case kbLeft:
                    change(mode,goLeft,p,s);
                    break;
                case kbRight:
                    change(mode,goRight,p,s);
                    break;
                case kbUp:
                    change(mode,goUp,p,s);
                    break;
                case kbDown:
                    change(mode,goDown,p,s);
                    break;
                case kbCtrlLeft:
                    change(mode,goCtrlLeft,p,s);
                    break;
                case kbCtrlRight:
                    change(mode,goCtrlRight,p,s);
                    break;
                case kbHome:
                    p.x = limits.a.x;
                    break;
                case kbEnd:
                    p.x = limits.b.x - s.x;
                    break;
                case kbPgUp:
                    p.y = limits.a.y;
                    break;
                case kbPgDn:
                    p.y = limits.b.y - s.y;
                    break;
                }
            moveGrow( p, s, limits, minSize, maxSize, mode );
            } while( event.keyDown.keyCode != kbEsc &&
                     event.keyDown.keyCode != kbEnter
                   );
        if( event.keyDown.keyCode == kbEsc )
            locate(saveBounds);
        }
    setState(sfDragging, False);
}

void TView::draw()
{
    TDrawBuffer  b;

    b.moveChar( 0, ' ', getColor(1), size.x );
    writeLine( 0, 0, size.x, size.y, b );
}

void TView::drawCursor()
{
    if( (state & sfFocused) != 0 )
        resetCursor();
}

void TView::drawHide( TView* lastView )
{
    drawCursor();
    drawUnderView(Boolean(state & sfShadow), lastView);
}

void TView::drawShow( TView* lastView )
{
    drawView();
    if( (state & sfShadow) != 0 )
        drawUnderView( True, lastView );
}

void TView::drawUnderRect( TRect& r, TView* lastView )
{
    owner->clip.intersect(r);
    owner->drawSubViews(nextView(), lastView);
    owner->clip = owner->getExtent();
}

void TView::drawUnderView( Boolean doShadow, TView* lastView )
{
    TRect r = getBounds();
    if( doShadow != False )
        r.b += shadowSize;
    drawUnderRect( r, lastView );
}

void TView::drawView()
{
    if (exposed())
        {
        draw();
        drawCursor();
        }
}

void TView::enableCommands( TCommandSet& commands )
{
    commandSetChanged = Boolean( commandSetChanged ||
                                ((curCommandSet&commands) != commands) );
    curCommandSet += commands;
}

void TView::enableCommand( ushort command )
{
    commandSetChanged = Boolean( commandSetChanged ||
                                 !curCommandSet.has( command ) );
    curCommandSet += command;
}

void TView::endModal( ushort command )
{
    if( TopView() != 0 )
        TopView()->endModal(command);
}

Boolean  TView::eventAvail()
{
    TEvent event;
    getEvent(event);
    if( event.what != evNothing )
        putEvent(event);
    return Boolean( event.what != evNothing );
}

TRect TView::getBounds()
{
    return TRect( origin, origin+size );
}

ushort  TView::execute()
{
    return cmCancel;
}

TRect TView::getClipRect()
{
    TRect clip = getBounds();
    if( owner != 0 )
        clip.intersect(owner->clip);
    clip.move(-origin.x, -origin.y);
    return clip;
}

ushort TView::getColor( ushort color )
{
    ushort colorPair = color >> 8;

    if( colorPair != 0 )
        colorPair = mapColor(colorPair) << 8;

    colorPair |= mapColor( uchar(color) );

    return colorPair;
}

void TView::getCommands( TCommandSet& commands )
{
    commands = curCommandSet;
}

void TView::getData( void * )
{
}

void TView::getEvent( TEvent& event )
{
    if( owner != 0 )
        owner->getEvent(event);
}

TRect TView::getExtent()
{
    return TRect( 0, 0, size.x, size.y );
}

ushort TView::getHelpCtx()
{
    if( (state & sfDragging) != 0 )
        return hcDragging;
    return helpCtx;
}

TPalette& TView::getPalette() const
{
    static char ch = 0;
    static TPalette palette( &ch, 0 );
    return palette;
}

Boolean TView::getState( ushort aState )
{
    return Boolean( (state & aState) == aState );
}

void TView::growTo( short x, short y )
{
    TRect r = TRect(origin.x, origin.y, origin.x + x, origin.y + y);
    locate(r);
}

void TView::handleEvent(TEvent& event)
{
    if( event.what == evMouseDown )
        {
        if(!(state & (sfSelected | sfDisabled)) && (options & ofSelectable) )
            {
            select();
            if( !(options & ofFirstClick) )
                clearEvent(event);
            }
        }
}

void TView::hide()
{
    if( (state & sfVisible) != 0 )
        setState( sfVisible, False );
}

void TView::hideCursor()
{
    setState( sfCursorVis, False );
}

void TView::keyEvent( TEvent& event )
{
    do {
       getEvent(event);
        } while( event.what != evKeyDown );
}

#define range(Val, Min, Max)    (((Val < Min) ? Min : ((Val > Max) ? Max : Val)))

void TView::locate( TRect& bounds )
{
    TPoint   min, max;
    sizeLimits(min, max);
    bounds.b.x = bounds.a.x + range(bounds.b.x - bounds.a.x, min.x, max.x);
    bounds.b.y = bounds.a.y + range(bounds.b.y - bounds.a.y, min.y, max.y);
    TRect r = getBounds();
    if( bounds != r )
        {
        changeBounds( bounds );
        if( owner != 0 && (state & sfVisible) != 0 )
            {
            if( (state & sfShadow) != 0 )
                {
                r.Union(bounds);
                r.b += shadowSize;
                }
            drawUnderRect( r, 0 );
            }
        }
}

void TView::makeFirst()
{
    putInFrontOf(owner->first());
}

TPoint TView::makeGlobal( TPoint source )
{
    TPoint temp = source + origin;
    TView *cur = this;
    while( cur->owner != 0 )
        {
        cur = cur->owner;
        temp += cur->origin;
        }
    return temp;
}

TPoint TView::makeLocal( TPoint source )
{
    TPoint temp = source - origin;
    TView* cur = this;
    while( cur->owner != 0 )
        {
        cur = cur->owner;
        temp -= cur->origin;
        }
    return temp;
}

Boolean TView::mouseEvent(TEvent& event, ushort mask)
{
    do {
       getEvent(event);
        } while( !(event.what & (mask | evMouseUp)) );

    return Boolean(event.what != evMouseUp);
}

Boolean TView::mouseInView(TPoint mouse)
{
     mouse = makeLocal( mouse );
     TRect r = getExtent();
     return r.contains(mouse);
}

void TView::moveTo( short x, short y )
{
     TRect r( x, y, x+size.x, y+size.y );
     locate(r);
}

TView *TView::nextView()
{
    if( this == owner->last )
        return 0;
    else
        return next;
}

void TView::normalCursor()
{
    setState(sfCursorIns, False);
}

TView *TView::prev()
{
    TView* res = this;
    while( res->next != this )
        res = res->next;
    return res;
}

TView *TView::prevView()
{
    if( this == owner->first() )
        return 0;
    else
        return prev();
}

void TView::putEvent( TEvent& event )
{
    if( owner != 0 )
        owner->putEvent(event);
}

void TView::putInFrontOf( TView *Target )
{
    TView *p, *lastView;

    if( owner != 0 && Target != this && Target != nextView() &&
         ( Target == 0 || Target->owner == owner)
      )
        if( (state & sfVisible) == 0 )
            {
            owner->removeView(this);
            owner->insertView(this, Target);
            }
        else
            {
            lastView = nextView();
            p = Target;
            while( p != 0 && p != this )
                p = p->nextView();
            if( p == 0 )
                lastView = Target;
            state &= ~sfVisible;
            if( lastView == Target )
                drawHide(lastView);
            owner->removeView(this);
            owner->insertView(this, Target);
            state |= sfVisible;
            if( lastView != Target )
                drawShow(lastView);
            if( (options & ofSelectable) != 0 )
                owner->resetCurrent();
            }
}

void TView::select()
{
    if( (options & ofTopSelect) != 0 )
        makeFirst();
    else if( owner != 0 )
        owner->setCurrent( this, normalSelect );
}

void TView::setBounds( const TRect& bounds )
{            
    origin = bounds.a;
    size = bounds.b - bounds.a;
}

void TView::setCommands( TCommandSet& commands )
{
    commandSetChanged = Boolean( commandSetChanged ||
                                (curCommandSet != commands ));
    curCommandSet = commands;
}

void TView::setCursor( short x, short y )
{
    cursor.x = x;
    cursor.y = y;
    drawCursor();
}

void TView::setData( void * )
{
}

void TView::setState( ushort aState, Boolean enable )
{
    if( enable == True )
        state |= aState;
    else
        state &= ~aState;

    if( owner == 0 )
        return;

    switch( aState )
        {
        case  sfVisible:
            if( (owner->state & sfExposed) != 0 )
                setState( sfExposed, enable );
            if( enable == True )
                drawShow( 0 );
            else
                drawHide( 0 );
            if( (options & ofSelectable) != 0 )
                owner->resetCurrent();
            break;
        case  sfCursorVis:
        case  sfCursorIns:
            drawCursor();
            break;
        case  sfShadow:
            drawUnderView( True, 0 );
            break;
        case  sfFocused:
            resetCursor();
            message( owner,
                     evBroadcast,
                     (enable == True) ? cmReceivedFocus : cmReleasedFocus,
                     this
                   );
            break;
        }
}

void TView::show()
{
    if( (state & sfVisible) == 0 )
        setState(sfVisible, True);
}

void TView::showCursor()
{
    setState( sfCursorVis, True );
}

void TView::sizeLimits( TPoint& min, TPoint& max )
{
    min.x = min.y = 0;
    if( owner != 0 )
        max = owner->size;
    else
        max.x = max.y = INT_MAX;
}

TView* TView::TopView()
{
    if( TheTopView != 0 )
        return TheTopView;
    else
        {
        TView* p = this;
        while( p != 0 && !(p->state & sfModal) )
            p = p->owner;
        return p;
        }
}

Boolean TView::valid( ushort )
{
    return True;
}

Boolean TView::containsMouse( TEvent& event )
{
    return Boolean( (state & sfVisible) != 0 &&
                    mouseInView( event.mouse.where )
                  );
}

void TView::shutDown()
{
    hide();
    if( owner != 0 )
        owner->remove( this );
    TObject::shutDown();
}

void TView::write( opstream& os )
{
    ushort saveState =
        state & ~( sfActive | sfSelected | sfFocused | sfExposed );

    os << origin << size << cursor
       << growMode << dragMode << helpCtx
       << saveState << options << eventMask;
}

void *TView::read( ipstream& is )
{
    is >> origin >> size >> cursor
       >> growMode >> dragMode >> helpCtx
       >> state >> options >> eventMask;
    owner = 0;
    next = 0;
    return this;
}

TStreamable *TView::build()
{
    return new TView( streamableInit );
}

TView::TView( StreamableInit )
{
}

uchar TView::mapColor( uchar color )
{
    if( color == 0 )
        return errorAttr;
    TView *cur = this;
    do  {
        TPalette& p = cur->getPalette();
        if( p[0] != 0 )
            {
            if( color > p[0] )
                return errorAttr;
            color = p[color];
            if( color == 0 )
                return errorAttr;
            }
        cur = cur->owner;
        } while( cur != 0 );
    return color;
}

#define int10 INTR(0x10,r)

void TView::resetCursor()
{
  short ax,cx,dx;
  REGS r;
  TView *self=this,*view;
  if ((~state) & (sfVisible | sfCursorVis | sfFocused)) goto lab4;
  ax = cursor.y;
  dx = cursor.x;
lab1:
  if ( (ax<0) || (ax>=self->size.y) ) goto lab4;
  if ( (dx<0) || (dx>=self->size.x) ) goto lab4;
  ax += self->origin.y;
  dx += self->origin.x;
  if (!self->owner) goto lab5;
  view = self->owner->last;
lab2:
  view = view->next;
  if (view == self)
  {
    self = view->owner;
    goto lab1;
  }
  if (!(view->state & sfVisible)) goto lab2;
  if (ax<view->origin.y) goto lab2;
  if (ax>=view->origin.y+view->size.y) goto lab2;
  if (dx<view->origin.x) goto lab2;
  if (dx>=view->origin.x+view->size.x) goto lab2;
lab4:
  cx = 0x2000;
  goto lab6;
lab5:
  r.x.dx = ((ax & 0x00ff) << 8) | (dx & 0x00ff);
  r.h.bh = TScreen::GetPage();
  r.h.ah = 2;
  int10;
  cx = TScreen::cursorLines;
  if (!(state & sfCursorIns)) goto lab6;
  cx &= 0x00ff;
  if (!cx) cx = 7;
lab6:
  r.x.cx = cx;
  r.h.ah = 1;
  r.h.bh = TScreen::GetPage();
  int10;
}

#define VIEW ((TGroup *)(view))

static TView *target;

enum call_lab {lab_10,lab_11,lab_20};
Boolean call(call_lab LAB,TView * &view,short &ax,short &bx,short &cx,short &si);

Boolean call(call_lab LAB,TView * &view,short &ax,short &bx,short &cx,short &si)
{
  TView *retttarget,*rettview;
  short rettax,rettcx,rettsi;
  Boolean flag;
  switch (LAB)
  {
    case lab_10 : goto lab10;
    case lab_11 : goto lab11;
    case lab_20 : goto lab20;
  }
  return False;
lab10:
  view = view->owner;
  if (VIEW->buffer) return True;
lab11:
  target = view;
  ax += view->origin.y;
  si = view->origin.x;
  bx += si;
  cx += si;
  view = view->owner;
  if (!view) return True;
  if (ax<VIEW->clip.a.y) return False;
  if (ax>=VIEW->clip.b.y) return False;
  if (bx<VIEW->clip.a.x) bx = VIEW->clip.a.x;
  if (cx>VIEW->clip.b.x) cx = VIEW->clip.b.x;
  if (bx>=cx) return False;
  view = VIEW->last;
lab20:
  view = view->next;
  if (view == target) goto lab10;
  if (!(view->state & sfVisible)) goto lab20;
  si = view->origin.y;
  if (ax<si) goto lab20;
  si += view->size.y;
  if (ax>=si) goto lab20;
  si = view->origin.x;
  if (bx<si) goto lab22;
  si += view->size.x;
  if (bx>=si) goto lab20;
  bx = si;
  if (bx<cx) goto lab20;
  return False;
lab22:
  if (cx<=si) goto lab20;
  si += view->size.x;
  if (cx>si) goto lab23;
  cx = view->origin.x;
  goto lab20;
lab23:
  retttarget = target;
  rettview = view;
  rettsi = si;
  rettcx = cx;
  rettax = ax;
  cx = view->origin.x;
  flag = call(lab_20,view,ax,bx,cx,si);
  ax = rettax;
  cx = rettcx;
  bx = rettsi;
  view = rettview;
  target = retttarget;
  if (!flag) goto lab20;
  return True;
}

Boolean TView::exposed()
{
  short ax,bx,cx,si;
  short rettax;
  Boolean flag;
  TView *view = this;
  if (!(state & sfExposed)) return False;
  ax = 0;
  if (size.x<ax || size.y<ax) return False;
lab1:
  bx = 0;
  cx = view->size.x;
  rettax = ax;
  flag = call(lab_11,view,ax,bx,cx,si);
  ax = rettax;
  if (flag) return True;
  view = this;
  ax++;
  if (ax<view->size.y) goto lab1;
  return False;
}

extern TPoint shadowSize;
extern uchar shadowAttr;

static MouseEventType * curmouse;
static Boolean * mouseintflag;

#define maxret 100

static short offset;

#define AX ((ushort)(ax))

#define CALL(lab) call(lab,view,ax,bx,cx,dx,si,Buffer)

void call(int LAB,TView *&view,short &ax,short &bx,short &cx,short &dx,short &si,const void far * Buffer)
{
  TView *retttarget;
  short rettoffset;
  TView *rettview;
  short rettsi;
  short rettdx;
  short rettcx;
  short rettax;
  switch (LAB)
  {
    case 00 : goto lab00;
    case 20 : goto lab20;
    case 30 : goto lab30;
    case 50 : goto lab50;
  }
  return;
lab00:
  offset = bx;
  cx += bx;
  dx = 0;
  if (ax<0 || ax>=view->size.y) goto lab3;
  bx = bx<0 ? 0 : bx;
  cx = cx>view->size.x ? view->size.x : cx;
  if (bx<cx) goto lab10;
lab3:
ret:
  return;
lab10:
  if ( !( view->state & sfVisible) ) goto lab3;
  if (!view->owner) goto lab3;
  target = view;
  ax += view->origin.y;
  si = view->origin.x;
  bx += si;
  cx += si;
  offset += si;
  if (ax < view->owner->clip.a.y) goto lab3;
  if (ax>=view->owner->clip.b.y) goto lab3;
  bx = bx<view->owner->clip.a.x ? view->owner->clip.a.x : bx;
  cx = cx>view->owner->clip.b.x ? view->owner->clip.b.x : cx;
  if (bx>=cx) goto lab3;
  view = view->owner->last;
lab20:
  view = view->next;
  if (view == target) goto lab40;
  if (!(view->state & sfVisible)) goto lab20;
  si = view->origin.y;
  if (ax<si) goto lab20;
  si += view->size.y;
  if (ax<si) goto lab23;
  if (!(view->state & sfShadow)) goto lab20;
  si += shadowSize.y;
  if (ax>=si) goto lab20;
  si = view->origin.x;
  si += shadowSize.x;
  if (bx>=si) goto lab22;
  if (cx<=si) goto lab20;
  CALL(30);
lab22:
  si += view->size.x;
  goto lab26;
lab23:
  si = view->origin.x;
  if (bx>=si) goto lab24;
  if (cx<=si) goto lab20;
  CALL(30);
lab24:
  si += view->size.x;
  if (bx>=si) goto lab25;
  if (cx<=si) goto lab31;
  bx = si;
lab25:
  if (!(view->state & sfShadow)) goto lab20;
  if (ax<view->origin.y+shadowSize.y) goto lab27;
  si += shadowSize.x;
lab26:
  if (bx>=si) goto lab27;
  dx++;
  if (cx<=si) goto lab27;
  CALL(30);
  dx--;
lab27:
  goto lab20;
lab30:
  retttarget = target;
  rettoffset = offset;
  rettview = view;
  rettsi = si;
  rettdx = dx;
  rettcx = cx;
  rettax = ax;
  cx = si;
  CALL(20);
  ax = rettax;
  cx = rettcx;
  dx = rettdx;
  si = rettsi;
  view = rettview;
  offset = rettoffset;
  target = retttarget;
  bx = si;
lab31:
  goto ret;
lab40:
  view = view->owner;
  if (!((TGroup *)(view))->buffer) goto lab44;
  if ((((TGroup *)(view))->buffer) == ((ushort far *)(TScreen::screenBuffer))) goto lab41;
  CALL(50);
  goto lab44;
lab41:
  disable();
  if (ax != curmouse->where.y) goto lab42;
  if (bx > curmouse->where.x) goto lab42;
  if (cx > curmouse->where.x) goto lab43;
lab42:
  *mouseintflag = False;
  enable();
  CALL(50);
  if (*mouseintflag == False) goto lab44;
lab43:
  enable();
  TMouse::hide();
  CALL(50);
  TMouse::show();
lab44:
  if (((TGroup *)(view))->lockFlag) goto lab31;
  goto lab10;
lab50:
  {
    TView *rettview = view;
    short rettcx = cx;
    short rettax = ax;
    long _buffer;
    ushort far * buffer;
    ax *= view->size.x;
    ax += bx;
    _buffer = ScreenPrimary + ax*2 + TScreen::GetPage()*0x1000;
    buffer = ((TGroup *)(view))->buffer+ax;
    ax = shadowAttr << 8;
    cx -= bx;
    si = bx - offset;
    if (dx) goto lab52;
    if (((TGroup *)(view))->buffer == ((ushort far *)(TScreen::screenBuffer)))
    {
      dosmemput((const void *) (((const ushort far *)Buffer) +si),cx*2,_buffer);
    }
    else
    {
      while (cx--) (buffer++)[0] = ((const ushort far *)(Buffer))[si++];
    }
    goto lab70;
lab52:
    if (((TGroup *)(view))->buffer == ((ushort far *)(TScreen::screenBuffer)))
    {
      int _i;
      ushort us;
      ax &= 0xff00;
      for (_i=0;_i<cx;_i++)
      {
        us = ((const ushort far *)(Buffer))[si+_i] & 0x00ff | ax;
        dosmemput((const void *) (&us),2,_buffer+_i*2);
      }
    }
    else
    {
      ax &= 0xff00;
      while (cx--) (buffer++)[0] = (((const ushort far *)(Buffer))[si++] & 0x00ff) | ax;
    }
    goto lab70;
lab70:
    ax = rettax;
    cx = rettcx;
    view = rettview;
    goto ret;
  }
}

struct MYARGS {
  ushort ax;
  ushort bx;
  ushort cx;
  void far * Buffer;
  TView * view;
};

static write_args wa;
static MYARGS * WA = (MYARGS *)&wa;

#define WRITEVIEW(b,a,c,B)\
{\
  WA->bx = (b);\
  WA->ax = (a);\
  WA->cx = (c);\
  WA->Buffer = (B);\
  WA->view = this;\
  writeView(wa);\
}

void far TView::writeView(write_args wa)
{
  TView * view;
  short dx,si,bx,ax,cx;
  MYARGS * WA = (MYARGS *)&wa;
  void far * Buffer;
  bx = WA->bx;
  ax = WA->ax;
  cx = WA->cx;
  Buffer = WA->Buffer;
  view = WA->view;
  curmouse = &TEventQueue::curMouse;
  mouseintflag = &TEventQueue::mouseIntFlag;
  CALL(00);
}

void TView::writeBuf(short x,short y,short w,short h,const void far * Buffer)
{
  int i=0;
  while (h)
  {
    WRITEVIEW(x,y,w,((ushort *)(Buffer))+w*i);
    i++;
    h--;
    y++;
  }
}

void TView::writeChar( short x, short y, char c, uchar color, short count )
{
  ushort colo = (mapColor(color) << 8) | (uchar)c;
  ushort temp[256];
  int i=0;
  if (count<0) return;
  count = count>256 ? 256 : count;
  for (i=0;i<count;i++) temp[i]=colo;
  WRITEVIEW(x,y,count,&temp);
}

void TView::writeLine( short x, short y, short w, short h, const void far *Buffer )
{
  while (h--) WRITEVIEW(x,y++,w,((ushort *)(Buffer)));
}

void TView::writeStr( short x, short y, const char *str, uchar color )
{
  ushort temp[256];
  ushort count = strlen(str),i;
  if (!count) return;
  count = count>256 ? 256 : count;
  color = mapColor(color);
  for (i=0;i<count;i++) temp[i] = (color << 8) | (uchar)str[i];
  WRITEVIEW(x,y,count,&temp);
}

