#define Uses_TStringList
#define Uses_TStrIndexRec
#define Uses_ipstream
#include <tv.h>

#include <string.h>

TStringList::TStringList( StreamableInit ) :
    basePos(0),
    indexSize(0),
    index(0)
{
}


TStringList::~TStringList()
{
    int i;
    for (i=indexSize;i>0;i--) delete (index+(i-1));
/*
    delete [indexSize] index;
*/
}


void TStringList::get( char *dest, ushort key )
{
    if( indexSize == 0 )
        {
        *dest = EOS;
        return;
        }

    TStrIndexRec *cur = index;
    while( cur->key + MAXKEYS < key && cur - index < indexSize )
        cur++;
    if( cur->key + MAXKEYS < key )
        {
        *dest = EOS;
        return;
        }
    ip->seekg( basePos + cur->offset );
    int count = key - cur->key;
    do  {
        uchar sz = ip->readByte();
        ip->readBytes( dest, sz );
        dest[sz] = EOS;
        } while( count-- > 0 );
}

void *TStringList::read( ipstream& is )
{
    ip = &is;

    ushort strSize;
    is >> strSize;

    basePos = is.tellg();
    is.seekg( basePos + strSize );
    is >> indexSize;
    index = new TStrIndexRec[indexSize];
    is.readBytes( index, indexSize * sizeof( TStrIndexRec ) );
    return this;
}

TStreamable *TStringList::build()
{
    return new TStringList( streamableInit );
}
