#define Uses_TScreen
#define Uses_TEvent
#include <tv.h>

#include <dos.h>
#include <go32.h>
#if defined( DJGPP ) && ( DJGPP > 1 )
#include <dpmi.h>
#define REGS __dpmi_regs
#define INT10 __dpmi_int(0x10,&r_display)
#define SCREENPRIMARY ScreenPrimary
#else
#define REGS union REGS
#define INT10 int86(0x10,&r_display,&r_display)
#define SCREENPRIMARY _go32_info_block.linear_address_of_primary_screen
#endif

#include <conio.h>
#include <pc.h>

ushort TScreen::startupMode = 0xFFFF;
ushort TScreen::startupCursor = 0;
ushort TScreen::screenMode = 0;
uchar TScreen::screenWidth = 0;
uchar TScreen::screenHeight = 0;
uchar TScreen::Page = 0;
Boolean TScreen::hiResScreen = False;
Boolean TScreen::checkSnow = True;
long TScreen::screenBuffer = -1;
ushort TScreen::cursorLines = 0;

static uchar startupCursorX;
static uchar startupCursorY;

extern REGS r_display;

#define r (r_display)
#define AL (r.h.al)
#define BL (r.h.bl)
#define DL (r.h.dl)
#define AH (r.h.ah)
#define BH (r.h.bh)
#define DH (r.h.dh)
#define AX (r.x.ax)
#define BX (r.x.bx)
#define CX (r.x.cx)
#define DX (r.x.dx)

static ushort *SCREEN = NULL;
static int screensize;
static ushort startupmode;

void SaveScreen()
{
  int x,y;
  screensize = TDisplay::getRows()*TDisplay::getCols();
  ScreenGetCursor(&x,&y);
  startupCursorX = x;
  startupCursorY = y;
  startupmode = TScreen::getCrtMode();
  if (SCREEN) delete SCREEN;
  SCREEN = new ushort[screensize];
  ScreenRetrieve(SCREEN);
}

void RestoreScreen()
{
  TScreen::setCrtMode(startupmode);
  ScreenUpdate(SCREEN);
  ScreenSetCursor(startupCursorX,startupCursorY);
}

TScreen::TScreen()
{
    startupMode = getCrtMode();
    startupCursor = getCursorType();
    if (TMouse::present() == True) TMouse::hide();
    SaveScreen();
    if (TMouse::present() == True) TMouse::show();
    setCrtData();
}

void TScreen::SetPage(uchar page)
{
  Page = page;
  AH = 0x05;
  AL = page;
  videoInt();
#if 0
  screenBuffer = SCREENPRIMARY + (long)page * 0x1000;
#endif
}
  
void TScreen::resume()
{
    startupMode = getCrtMode();
    startupCursor = getCursorType();
    if (TMouse::present() == True) TMouse::hide();
    SaveScreen();
    if (TMouse::present() == True) TMouse::show();
    if (screenMode != startupMode)
       setCrtMode( screenMode );
    setCrtData();
}

TScreen::~TScreen()
{
    suspend();
}

void TScreen::suspend()
{
    if( startupMode != screenMode )
        setCrtMode( startupMode );
    clearScreen();
    setCursorType( startupCursor );
    SetPage(0);
    RestoreScreen();
}

ushort TScreen::fixCrtMode( ushort mode )
{
  return mode;
}

void TScreen::setCrtData()
{
    screenMode = getCrtMode();
    screenWidth = getCols();
    screenHeight = getRows();
    hiResScreen = Boolean(screenHeight > 25);
    cursorLines = getCursorType();
    setCursorType( 0x2000 );

}

void TScreen::clearScreen()
{
    TDisplay::clearScreen( screenWidth, screenHeight );
}

void TScreen::setVideoMode( ushort mode )
{
    setCrtMode( fixCrtMode( mode ) );
    setCrtData();
}
