#define Uses_TEventQueue
#define Uses_TEvent
#define Uses_TScreen
#include <tv.h>

#include <dos.h>

TEvent near TEventQueue::eventQueue[ eventQSize ] = { {0} };
TEvent *near TEventQueue::eventQHead = TEventQueue::eventQueue;
TEvent *near TEventQueue::eventQTail = TEventQueue::eventQueue;
Boolean near TEventQueue::mouseIntFlag = False;

#include <go32.h>
#include <sys/farptr.h>
#if defined( DJGPP ) && ( DJGPP > 1 )
#include <dpmi.h>
#define REGS __dpmi_regs
#define INTR(nr,r) __dpmi_int(nr,&r)
#else
#define _dos_ds _go32_conventional_mem_selector()
#define REGS union REGS
#define INTR(nr,r) int86(nr,&r,&r)
#endif


ushort TICKS(void)
{
  return _farpeekw(_dos_ds,0x46c);
}

ushort near TEventQueue::eventCount = 0;

Boolean near TEventQueue::mouseEvents = False;
Boolean near TEventQueue::mouseReverse = False;
ushort near TEventQueue::doubleDelay = 8;
ushort near TEventQueue::repeatDelay = 8;
ushort near TEventQueue::autoTicks = 0;
ushort near TEventQueue::autoDelay = 0;

MouseEventType near TEventQueue::lastMouse;
MouseEventType near TEventQueue::curMouse;
MouseEventType near TEventQueue::downMouse;
ushort near TEventQueue::downTicks = 0;

TEventQueue::TEventQueue()
{
    resume();
}

static int handler_locked = 0;
_go32_dpmi_registers mouseIntRegs;
_go32_dpmi_seginfo mouseIntInfo;
static MouseEventType tempMouse;

void TEventQueue::resume()
{
    if( mouse.present() == False )
        mouse.resume();
    if( mouse.present() == False )
        return;
    mouse.getEvent( curMouse );
    lastMouse = curMouse;
    
    if (!handler_locked)
    {
      _go32_dpmi_lock_code(mouseInt,1000);
      _go32_dpmi_lock_data(&mouseIntRegs,sizeof(mouseIntRegs));
      _go32_dpmi_lock_data(&tempMouse,sizeof(tempMouse));
      handler_locked = 1;
    }
    mouseIntInfo.pm_offset = (int)mouseInt;
    _go32_dpmi_allocate_real_mode_callback_retf(&mouseIntInfo,&mouseIntRegs);

    mouse.registerHandler( 0xFFFF, mouseInt );

    mouseEvents = True;
    mouse.show();
    TMouse::setRange( TScreen::screenWidth-1, TScreen::screenHeight-1 );
}

void TEventQueue::suspend()
{
    mouse.suspend();
}

TEventQueue::~TEventQueue()
{
    suspend();
}

void TEventQueue::getMouseEvent( TEvent& ev )
{
    if( mouseEvents == True )
        {

        getMouseState( ev );

        if( ev.mouse.buttons == 0 && lastMouse.buttons != 0 )
            {
            ev.what = evMouseUp;
            lastMouse = ev.mouse;
            return;
            }

        if( ev.mouse.buttons != 0 && lastMouse.buttons == 0 )
            {
            if( ev.mouse.buttons == downMouse.buttons &&
                ev.mouse.where == downMouse.where &&
                ev.what - downTicks <= doubleDelay )
                    ev.mouse.doubleClick = True;

            downMouse = ev.mouse;
            autoTicks = downTicks = ev.what;
            autoDelay = repeatDelay;
            ev.what = evMouseDown;
            lastMouse = ev.mouse;
            return;
            }

        ev.mouse.buttons = lastMouse.buttons;

        if( ev.mouse.where != lastMouse.where )
            {
            ev.what = evMouseMove;
            lastMouse = ev.mouse;
            return;
            }

        if( ev.mouse.buttons != 0 && ev.what - autoTicks > autoDelay )
            {
            autoTicks = ev.what;
            autoDelay = 1;
            ev.what = evMouseAuto;
            lastMouse = ev.mouse;
            return;
            }
        }

    ev.what = evNothing;
}

void TEventQueue::getMouseState( TEvent & ev )
{
    disable();
    if( eventCount == 0 )
        {
        ev.what = TICKS();
        ev.mouse = curMouse;
        }
    else
        {
	ev = *eventQHead;
        if( ++eventQHead >= eventQueue + eventQSize )
            eventQHead = eventQueue;
        eventCount--;
        }
    enable();
    if( mouseReverse != False && ev.mouse.buttons != 0 && ev.mouse.buttons != 3 )
        ev.mouse.buttons ^= 3;
}

int draw_mouse(int,int);

void TEventQueue::mouseInt()
{
    int x,y;
    tempMouse.buttons = mouseIntRegs.h.bl;
    tempMouse.doubleClick = False;
    x = tempMouse.where.x = (mouseIntRegs.x.cx >> 3) & 0xFF;
    y = tempMouse.where.y = (mouseIntRegs.x.dx >> 3) & 0xFF;
    if (draw_mouse(x,y)) mouseIntFlag = True;
    if( (mouseIntRegs.x.ax & 0x1e) != 0 && eventCount < eventQSize )
        {
        eventQTail->what = TICKS();
        eventQTail->mouse = curMouse;
        if( ++eventQTail >= eventQueue + eventQSize )
            eventQTail = eventQueue;
        eventCount++;
        }

    curMouse = tempMouse;
}

extern unsigned short gkey(void);

void TEvent::getKeyEvent()
{
  if (!kbhit()) what = evNothing;
  else
  {
    keyDown.keyCode = gkey();
    what = evKeyDown;
  }
}

