/*
 *
 * cpu.c
 *
 *  cpu detecting
 *
 *  (c) Sampsa Lehtonen 1998, kyt vapaasti
 *
 */

#include <stdio.h>
#include <string.h>

#include "cpu.h"

#define CPU_CHIPS_INTEL 39

// family, model, revision (-1 means everything will do)
//
// !!! All the brand names used here belong to their owners !!!
//
CPU_CHIPSTRUCT cpu_chip_intel[CPU_CHIPS_INTEL] = {
{ 3, -1, -1, "386 with CPUID" },
{ 4,  0,  5, "486DX" },
{ 4,  1,  5, "486DX" },
{ 4,  2, -1, "486SX" },
{ 4,  3,  5, "486DX2"},
{ 4,  3,  5, "486DX2"},
{ 4,  4, -1, "486SL" },
{ 4,  5, -1, "486SX2"},
{ 4,  7, -1, "486DX2"},
{ 4,  8,  0, "486DX4"},
{ 4,  9, -1, "486DX4"},
{ 5,  0, -1, "Pentium"},
{ 5,  1,  3, "Pentium DIVBUG"},
{ 5,  1,  5, "Pentium DIVBUG"},
{ 5,  1,  7, "Pentium 60/66"},
{ 5,  1, 10, "Pentium Overdrive 120/133"},
{ 5,  2,  1, "Pentium 75 DIVBUG"},
{ 5,  2,  2, "Pentium 75 DIVBUG"},
{ 5,  2,  4, "Pentium 75"},
{ 5,  2,  5, "Pentium 75"},
{ 5,  2,  6, "Pentium 75"},
{ 5,  2, 11, "Pentium 75"},
{ 5,  2, 12, "Pentium 75"},
{ 5,  3,  1, "Pentium Overdrive (486)"},
{ 5,  3,  2, "Pentium Overdrive (486)"},
{ 5,  4,  3, "Pentium MMX"},
{ 5,  4,  4, "Pentium MMX"},
{ 5,  5, -1, "DX4 Overdrive ?"},
{ 5,  6, -1, "P5 Overdrive ?"},
{ 5,  7, -1, "Pentium"},
{ 5,  8,  1, "Pentium MMX"}, 
{ 6,  0, -1, "Pentium Pro"},
{ 6,  1, -1, "Pentium Pro"},
{ 6,  3,  2, "Pentium II Overdrive (Pentium Pro)"},
{ 6,  3,  3, "Pentium II Klamath"},
{ 6,  3,  4, "Pentium II Klamath"},
{ 6,  4,  3, "P5 Overdrive ?"},
{ 6,  5, -1, "Pentium II Deschutes/Celeron"},
{ 6,  6, -1, "Pentium II Celeron 128KB Cache"} };

#define CPU_CHIPS_UMC 2

CPU_CHIPSTRUCT cpu_chip_umc[CPU_CHIPS_UMC] = {
{ 4,  1, -1, "486DX"},
{ 4,  2,  3, "486SX"} };

#define CPU_CHIPS_AMD 17

CPU_CHIPSTRUCT cpu_chip_amd[CPU_CHIPS_AMD] = {
{ 4,  3,  2, "486DX2/DX4"},
{ 4,  3,  4, "486DX2/DX4"},
{ 4,  7,  4, "486DX2/DX4"},
{ 4,  8,  4, "486DX4 or 5x86"},
{ 4,  9,  4, "486DX4"},
{ 4,0xE,  4, "5x86"},
{ 4,0xF,  4, "5x86"},
{ 5,  0, -1, "K5"},
{ 5,  1, -1, "K5"},
{ 5,  2,  4, "K5"},
{ 5,  3,  4, "K5"},
{ 5,  6,  1, "K6"},
{ 5,  6,  2, "K6"},
{ 5,  7,  0, "K6"},
{ 5,  8,  0, "K6-2"},
{ 5,  8,  2, "K6-2"},
{ 5,  9,  1, "K6-3 3DNow!"} };

#define CPU_CHIPS_CYRIX 6

CPU_CHIPSTRUCT cpu_chip_cyrix[CPU_CHIPS_CYRIX] = {
{ 4, 4, -1, "Cx5x86"},
{ 4, 9, -1, "Cx5x86"},
{ 5, 0, -1, "Cx6x86"},
{ 5, 2, -1, "Cx5x86"},
{ 5, 4, -1, "Cx5x86"},
{ 6, 0, -1, "6x86MX"} };

#define CPU_CHIPS_NEXGEN 2

CPU_CHIPSTRUCT cpu_chip_nexgen[CPU_CHIPS_NEXGEN] = {
{ 5, 0, 4, "Nx586 P100 ?"},
{ 5, 0, 6, "Nx586 P120 ?"} };

#define CPU_CHIPS_CENTAUR 1

CPU_CHIPSTRUCT cpu_chip_centaur[CPU_CHIPS_CENTAUR] = {
{ 5, 4, -1, "WinChip"} };


CPU_VENDORSTRUCT cpu_vendorList[CPU_CHIPS] = {

{ "XXXXXXXXXXXX", "Unknown",NULL,             0 },
{ "GenuineIntel", "Intel",  cpu_chip_intel,   CPU_CHIPS_INTEL },
{ "UMC UMC UMC ", "UMC",    cpu_chip_umc,     CPU_CHIPS_UMC },
{ "AuthenticAMD", "AMD",    cpu_chip_amd,     CPU_CHIPS_AMD },
{ "CyrixInstead", "Cyrix",  cpu_chip_cyrix,   CPU_CHIPS_CYRIX },
{ "NexGenDriven", "NexGen", cpu_chip_nexgen,  CPU_CHIPS_NEXGEN },
{ "CentaurHauls", "Centaur",cpu_chip_centaur, CPU_CHIPS_CENTAUR } };


char *cpu_getVendorName(int vendorNumber)
{
  return cpu_vendorList[vendorNumber].vendorName;
}

char *cpu_getChipName(int vendorNumber, int family, int model, int rev)
{
  int i;
  /*
  char chipName[50];

  cpu_getChipID(chipName);

  return chipName;
  */

  for (i = 0; i < cpu_vendorList[vendorNumber].chips; i++)
  {
    if (family == cpu_vendorList[vendorNumber].chip[i].family)    
      if (model == cpu_vendorList[vendorNumber].chip[i].model ||
          cpu_vendorList[vendorNumber].chip[i].model == -1)      
        if (rev == cpu_vendorList[vendorNumber].chip[i].revision ||
            cpu_vendorList[vendorNumber].chip[i].revision == -1)
          return cpu_vendorList[vendorNumber].chip[i].description;

  }
}

int cpu_getSpeed(void);

int cpu_lastFamily;
int cpu_lastModel;
int cpu_lastRev;

void cpu_getChipInfo(char *vendorName, char *chipName, int *speed)
{
  int _cpufamily = 0;  
  int _cpumodel = 0;
  int _cpurev = 0;
  int _vendorNumber = 0;

  _cpufamily = cpu_processorType();

  if (_cpufamily > 4)
  {
    _asm {
      mov eax, 1
      CPUID

      mov edx, eax
      shr edx, 4
      and edx, 0x7
      mov [_cpumodel], edx

      mov edx, eax
      and edx, 0x7
      mov [_cpurev], edx
    };

    _vendorNumber = cpu_getVendorNumber();


    *speed = cpu_getSpeed();
  }
  else
  {
    _vendorNumber = 0;

    *speed = 0;
  }
    strcpy(vendorName, cpu_getVendorName(_vendorNumber));

    strcpy(chipName, cpu_getChipName(_vendorNumber, _cpufamily, _cpumodel, _cpurev));

  cpu_lastFamily = _cpufamily;
  cpu_lastModel = _cpumodel;
  cpu_lastRev = _cpurev;
}

int cpu_getVendorNumber(void)
{
  char vendorID[16];
  int i;

  cpu_getVendorID(&vendorID);

  for (i = 0; i < CPU_CHIPS; i++)
    if (!strncmp(vendorID, cpu_vendorList[i].vendorID, 12))
      return i;

  return 0;
}

//
// Measure CPU speed, code by Rick Booth (from a book called Inner Loops)
//
int cpu_getSpeed(void)
{
  int speed;

  _asm {
    mov     edx,46cH                ;  ;address of DOS tick counter
    mov     eax,[edx]               ;  ;read it
    loopstart:
    cmp eax, [edx]
    jz loopstart

    
    mov     esi,[edx]               ;  ;
    rdtsc                           ;  ;read cycles
    mov     ecx,eax                 ;  ;store 32 bits
    mov     ebx,10                  ;  ;
    mov     edx,46cH                ;  ;address of DOS tick counter

    loopstart2:
                             ;  ;
      mov   eax,[edx]               ;  ;read it again
      loopstart3:                       ;  ;
      cmp eax, [edx]
      jz loopstart3

      dec   ebx                     ;  ;
    jnz loopstart2

    sub     esi,[edx]               ;  ;
    rdtsc                           ;  ;read cycles
    neg     esi                     ;  ;esi has actual tick count
    sub     eax,ecx                 ;  ;find difference
    mov     ebx,eax                 ;  ;
    mov     eax,1820651             ;  ;scale to secs, fixed point
    xor     edx,edx                 ;  ;
    div     esi                     ;  ;adjust for actual ticks
    mul     ebx                     ;  ;
    mov     ecx,100000              ;  ;
    div     ecx                     ;  ;eax has cycles per second

    mov [speed], eax
    };

    return speed;
}
