

 //**********************************************
 // RST 2 Small Intro
 // By Synthetic Man
 // Of The Rising Sun Team
 // In December 1994
 //**********************************************
 // To Contact Us Write To:
 // S-Mail:
 // Rising Sun Team
 // Via Ronchi Bassi, 13
 // 35135 Padova (Italy)
 // E-Mail:
 // sakurambo@paola.dei.unipd.it
 // barchio@paola.dei.unipd.it
 // silviazm@paola.dei.unipd.it
 //**********************************************
 // Use COMPACT Model For Code Generation
 // Use A Project RST2 With MODEX.OBJ And RST2.C
 //**********************************************
 // This source code is totally free and you can
 // use it for your demos/intros but don't forget
 // to greet us of RST
 //**********************************************


 //--------------------------------------------------
 // librerie standard
 //--------------------------------------------------
 #include <stdlib.h>
 #include <stdio.h>
 #include <string.h>
 #include <conio.h>

 //--------------------------------------------------
 // librerie mode x
 //--------------------------------------------------
 #include "modex.h"

 //--------------------------------------------------
 // includo dei dati
 //--------------------------------------------------
 #include "ball.c"    //immagine palla
 #include "pattern.c" //immagine pattern
 #include "palette.c" //palette palla

 //--------------------------------------------------
 // definizione dati
 //--------------------------------------------------
 #define colore_minimo   97
 #define colore_massimo  107
 #define x 55
 #define y 10
 #define distanza_x 14
 #define distanza_y 12
 #define vga_x 360
 #define vga_y 240

 //--------------------------------------------------
 // variabili globali
 //--------------------------------------------------
 unsigned char far *sprite_palla;
 unsigned char far *sprite_pattern;
 unsigned char r[256],g[256],b[256];
 unsigned char r_old,g_old,b_old;

 //--------------------------------------------------
 // testo scritte
 //--------------------------------------------------
 char testo[][80]={"---== The Rising Sun Team ==---",
		   "",
		   "Present This Simple Intro Dedicated To All",
		   "Italian Guys Who Want Enjoy PC Coding!",
		   "If You Are In Trouble Contact Us Now!",
		   "",
		   "Intro Code & Graphic By Synthetic Man",
		   "",
		   "The Members Of Rising Sun Team Are:",
		   "Synthetic Man, Crazy Byte, Cyber Punk Boy,",
		   "Manga Man, Mr Babiox, Crazy Teo, Pit."};

 char testo_fine[][80]={" ͻ",
			"  The Rising Sun Team          ",
			"  RST2 Intro                   ",
			" ͹",
			"  Idea, Code & Graphic         ",
			"  By Synthetic Man             ",
			" ͹",
			"  S-Mail:                      ",
			"  Rising Sun Team              ",
			"  Via Ronchi Bassi 13          ",
			"  35135 Padova (Italy)         ",
			"  E-Mail:                      ",
			"  sakurambo@paola.dei.unipd.it ",
			"  barchio@paola.dei.unipd.it   ",
			"  silviazm@paola.dei.unipd.it  ",
			"  lythyum@maya.dei.unipd.it    ",
			" ͼ",
			""};


 //--------------------------------------------------
 // posizione delle palle della scritta
 //--------------------------------------------------
 char posizione[]={0,0,
		   0,1,
		   0,2,
		   0,3,
		   0,4,
		   0,5,
		   0,6,
		   0,7,
		   1,0,
		   1,4,
		   2,0,
		   2,4,
		   2,5,
		   3,0,
		   3,4,
		   3,6,
		   4,0,
		   4,1,
		   4,2,
		   4,3,
		   4,4,
		   4,7,
		   6,0,
		   6,1,
		   6,2,
		   6,3,
		   6,4,
		   6,7,
		   7,0,
		   7,4,
		   7,7,
		   8,0,
		   8,4,
		   8,7,
		   9,0,
		   9,4,
		   9,7,
		   10,0,
		   10,4,
		   10,5,
		   10,6,
		   10,7,
		   12,0,
		   13,0,
		   14,0,
		   14,1,
		   14,2,
		   14,3,
		   14,4,
		   14,5,
		   14,6,
		   14,7,
		   15,0,
		   16,0};

 //--------------------------------------------------
 // ritorna il valori di rgb di un colore della pal.
 //--------------------------------------------------
 void get_palette(unsigned char col)
 {
  unsigned char  rr,gg,bb;

   asm{
      mov    dx,3c7h
      mov    al,col
      out    dx,al

      add    dx,2

      in     al,dx
      mov    [rr],al
      in     al,dx
      mov    [gg],al
      in     al,dx
      mov    [bb],al
      }

   r[col]=rr;
   g[col]=gg;
   b[col]=bb;
 }


 //--------------------------------------------------
 // vertical retrace
 //--------------------------------------------------
 void wait_retrace(void)
  {
    asm mov dx,3DAh
   l1:
    asm in al,dx
    asm and al,08h
    asm jnz l1
   l2:
    asm in al,dx
    asm and al,08h
    asm jz  l2
  }

  //----------------------------------------------------
  // fade off 256 colori
  //----------------------------------------------------
  void fade_off(unsigned char red[256],unsigned char green[256],
		unsigned char blue[256])
  {
   int i,n;

    for(i=0;i<=64;i++)   //64=max numero di sfumature di un colore
    {
      for(n=0;n<=255;n++)
      {
      if(red[n]>0) red[n]--;
      if(green[n]>0) green[n]--;
      if(blue[n]>0) blue[n]--;
      set_dac_register(n,red[n],green[n],blue[n]);
     }
    wait_retrace();
    wait_retrace();
   }
  }

  //-----------------------------------------------
  // fade in 256 colori
  //-----------------------------------------------
  void fade_in(unsigned char red[256],unsigned char green[256],
	       unsigned char blue[256])
  {
   int i,n,_red[256],_green[256],_blue[256];

   for(n=0;n<=255;n++)
   {
    _red[n]=red[n];
    _green[n]=green[n];
    _blue[n]=blue[n];
   }

  for(n=0;n<=255;n++)
   {
    red[n]=0;
    green[n]=0;
    blue[n]=0;
   }

    for(i=0;i<=64;i++)
    {
      for(n=0;n<=255;n++)
      {
      if(red[n]<_red[n]) red[n]++;
      if(green[n]<_green[n]) green[n]++;
      if(blue[n]<_blue[n]) blue[n]++;
      set_dac_register(n,red[n],green[n],blue[n]);
     }
    wait_retrace();
    wait_retrace();
   }
  }
 
 //--------------------------------------------------
 // azzera il contenuto della palette
 //--------------------------------------------------
 void azzera_palette(void)
 {
  int n;
  for(n=0;n<=255;n++)
     set_dac_register(n,0,0,0);
 }


 //--------------------------------------------------
 // genera il movimento dello sfondo
 //--------------------------------------------------
 void play_palette(void)
 {
  register int n,m;


   // memorizza il primo colore della palette
    r_old=r[colore_minimo];
    g_old=g[colore_minimo];
    b_old=b[colore_minimo];

    for(n=colore_minimo;n<=colore_massimo;n++)
     {
      r[n]=r[n+1];
      g[n]=g[n+1];
      b[n]=b[n+1];
     }

    r[colore_massimo]=r_old;
    g[colore_massimo]=g_old;
    b[colore_massimo]=b_old;

    for(n=colore_minimo;n<=colore_massimo;n++)
	set_dac_register(n,r[n],g[n],b[n]);

    wait_retrace();
    wait_retrace();
    wait_retrace();
    wait_retrace();

  }


 void main()
 {
  register int n,m;

  //--------------------------------------------------
  // rileva la palette attuale
  //--------------------------------------------------
  for(n=0;n<=256;n++)
   get_palette(n);

  //--------------------------------------------------
  // fade off della schermata in modo testo
  //--------------------------------------------------
  fade_off(r,g,b);

  //--------------------------------------------------
  // alloca i puntatori degli sprite
  //--------------------------------------------------
  sprite_palla=calloc(625,sizeof(unsigned char far));
  sprite_pattern=calloc(400,sizeof(unsigned char far));

  //--------------------------------------------------
  // costruisce lo sprite della palla
  //--------------------------------------------------
  for(n=0;n<625;n++)
    sprite_palla[n]=palla[n];

  //--------------------------------------------------
  // costruisce lo sprite del pattern
  //--------------------------------------------------
  for(n=0;n<400;n++)
    sprite_pattern[n]=pattern[n];

  //--------------------------------------------------
  // inizializza il mode x in 360x240
  //--------------------------------------------------
  set_modex(6);

  //--------------------------------------------------
  // copia la palette in tre vettori r,g,b
  //--------------------------------------------------
  m=0;
  for(n=0;n<256;n++)
   {
    r[n]=palette[m];
    g[n]=palette[m+1];
    b[n]=palette[m+2];
    m+=3;
   }

  //--------------------------------------------------
  // azzera la palette per nascondere l'immagine
  //--------------------------------------------------
  azzera_palette();

  //--------------------------------------------------
  // disegna lo sfondo
  //--------------------------------------------------
  for(n=0;n<=(vga_y/20)-1;n++)
   for(m=0;m<=(vga_x/20)-1;m++)
    draw_bitmap(sprite_pattern,m*20,n*20,20,20);

  //--------------------------------------------------
  // disegna la scritta
  //--------------------------------------------------
  for(n=0;n<=106;n+=2)
   tdraw_bitmap(sprite_palla,x+(posizione[n]*distanza_x),
		y+(posizione[n+1]*distanza_y),25,25);

  //--------------------------------------------------
  // prepara una scalatura dei colori dello sfondo
  //--------------------------------------------------
  for(n=colore_massimo,m=colore_minimo;n>=colore_minimo;n--,m++)
   {
    r[n]=r[m];
    g[n]=g[m];
    b[n]=b[m];
   }

  //--------------------------------------------------
  // scrive il testo
  //--------------------------------------------------
  for(n=0;n<=10;n++)
   tprint_str(testo[n],strlen(testo[n]),(vga_x/2)-((strlen(testo[n])*8)/2),
	      n*10+130,1);

  //--------------------------------------------------
  // fade in dell'immagine dell'intro
  //--------------------------------------------------
  fade_in(r,g,b);

  //--------------------------------------------------
  // ciclo principale
  //--------------------------------------------------
  for(;;)
  {
   if (kbhit())
    if (getch()==27)   //controlla se viene premuto esc
     break;

   play_palette();
  }

  //--------------------------------------------------
  // fade off dell'immagine dell'intro
  //--------------------------------------------------
  fade_off(r,g,b);

  //--------------------------------------------------
  // ritorna in modo tsto a 80 colonne
  //--------------------------------------------------
  textmode(3);

  //--------------------------------------------------
  // rileva la palette attuale
  //--------------------------------------------------
  for(n=0;n<=256;n++)
   get_palette(n);

  //--------------------------------------------------
  // azzera la palette
  //--------------------------------------------------
  azzera_palette();

  //--------------------------------------------------
  // scrive il testo
  //--------------------------------------------------
  for(n=0;n<=17;n++)
   printf("\n%s",testo_fine[n]);

  //--------------------------------------------------
  // fade in del testo in modo testo
  //--------------------------------------------------
  fade_in(r,g,b);

 }