/*         ______   ___    ___ 
 *        /\  _  \ /\_ \  /\_ \ 
 *        \ \ \L\ \\//\ \ \//\ \      __     __   _ __   ___ 
 *         \ \  __ \ \ \ \  \ \ \   /'__`\ /'_ `\/\`'__\/ __`\
 *          \ \ \/\ \ \_\ \_ \_\ \_/\  __//\ \L\ \ \ \//\ \L\ \
 *           \ \_\ \_\/\____\/\____\ \____\ \____ \ \_\\ \____/
 *            \/_/\/_/\/____/\/____/\/____/\/___L\ \/_/ \/___/
 *                                           /\____/
 *                                           \_/__/
 *      By Shawn Hargreaves,
 *      1 Salisbury Road,
 *      Market Drayton,
 *      Shropshire,
 *      England, TF9 1AJ.
 *
 *      Some definitions for internal use by the library code.
 *      This should not be included by user programs.
 *
 *      See readme.txt for copyright information.
 */


#ifndef INTERNAL_H
#define INTERNAL_H

#include "keyboard.h"

/* macros to enable and disable interrupts */
#ifdef __DJGPP__
#define DISABLE()   asm volatile ("cli")
#define ENABLE()    asm volatile ("sti")
#else
#define DISABLE()   asm cli
#define ENABLE()    asm sti
#endif

/* interrupt hander stuff */
#ifdef __DJGPP__
#define fISR int
int _install_irq(int num, int (*handler)());
#else
#define fISR void interrupt
int _install_irq(int num, void interrupt (*isr) (VarArgList) );
#endif
void _remove_irq(int num);

#ifdef __DJGPP__
typedef struct _IRQ_HANDLER
{
   int (*handler)();             /* our C handler */
   int number;                   /* irq number */
   __dpmi_paddr old_vector;      /* original protected mode vector */
} _IRQ_HANDLER;
#endif

/* list of functions to call at program cleanup */
void _add_exit_func(void (*func)());
void _remove_exit_func(void (*func)());

#endif          /* ifndef INTERNAL_H */
