/* Copyright (C) 1996,1997 Robert Hhne, see COPYING.RH for details */
/* This file is part of RHIDE. */
/*
 $Id: idedial.cc,v 1.3 1997-09-10 20:38:29+00 rho Exp rho $
*/
#define Uses_TApplication
#define Uses_MsgBox
#define Uses_TDeskTop
#define Uses_TFileDialog
#define Uses_TLabel
#define Uses_TRect
#define Uses_TCheckBoxes
#define Uses_TRadioButtons
#define Uses_THistory
#define Uses_TSItem
#define Uses_TButton
#define Uses_IDEConst
#include <rhide.h>
#include <rhidehis.h>
#include <ideapp.h>

#define Uses_TProject
#include <libide.h>

#define Uses_TLButton
#define Uses_tvutilFunctions
#include <libtvuti.h>

#include <rhutils.h>

#define Uses_TCEditor_External
#define Uses_TCEditor_Commands
#include <ceditor.h>
#include <calcu.h>

#define Uses_TInputLinePiped
#include <settvuti.h>

#include <string.h>
#include <errno.h>
#include <strstream.h>

int SelectFunctionToJump(char *, unsigned);
int PipeTCEditor(unsigned);

static void ApplyBroadcast(TView *p, void *e)
{
  p->handleEvent(*(TEvent *)e);
}

ushort execDialog( TDialog *d, void *data )
{
  TView *p = TProgram::application->validView(d);
  if (p == 0)
    return cmCancel;
  else
  {
    if (data != NULL)
      p->setData(data);
    ushort result = TProgram::deskTop->execView(p);
    if (result != cmCancel && data != NULL)
      p->getData(data);
    TObject::destroy(p);
    return result;
  }
}

static
TDialog *createFindDialog()
{
    TDialog *d = new TDialog( TRect( 0, 0, 38, 20 ), _("Find") );

    d->options |= ofCentered;

    TInputLinePiped *control = new TInputLinePiped( TRect( 3, 3, 32, 4 ), 80 );
    d->insert( control );
    d->insert(
        new TLabel( TRect( 2, 2, 35, 3 ), _("~T~ext to find"), control ) );
    InitHistoryID(RHIDE_History_find);
    d->insert(
        new THistory( TRect( 32, 3, 35, 4 ), control, RHIDE_History_find ) );

    d->insert( new TCheckBoxes( TRect( 3, 5, 35, 7 ),
        new TSItem( _("~C~ase sensitive"),
        new TSItem( _("~W~hole words only"), 0 ))));

    // Scope
    TRadioButtons *scope = new TRadioButtons( TRect( 3, 9, 35, 11 ),
                           new TSItem( _("~G~lobal"),
                           new TSItem( _("~S~elected text"), 0 )));
    d->insert( scope );
    d->insert(
        new TLabel( TRect( 2, 8, 35, 9 ), _("Scope"), scope ) );

    // Origin
    TRadioButtons *origin = new TRadioButtons( TRect( 3, 13, 37, 15 ),
                            new TSItem( _("~F~rom cursor"),
                            new TSItem( _("~E~ntire scope"), 0 )));
    d->insert( origin );
    d->insert(
        new TLabel( TRect( 2, 12, 35, 13 ), _("Origin"), origin ) );

    d->insert(
        new TButton( TRect( 10, 17, 20, 19 ), _("O~K~"), cmOK, bfDefault ) );
    d->insert(
        new TButton( TRect( 22, 17, 36, 19 ), _("Cancel"), cmCancel, bfNormal ) );

    d->selectNext( False );
    return d;
}

static
TDialog *createReplaceDialog()
{
    TDialog *d = new TDialog( TRect( 0, 0, 76, 18 ), _("Replace") );

    d->options |= ofCentered;

    TInputLinePiped *control = new TInputLinePiped( TRect( 3, 3, 34, 4 ), 80 );
    d->insert( control );
    d->insert(
        new TLabel( TRect( 2, 2, 33, 3 ), _("~T~ext to find"), control ) );
    InitHistoryID(RHIDE_History_find);
    d->insert( new THistory( TRect( 34, 3, 37, 4 ), control, RHIDE_History_find ) );

    TInputLinePiped *control2 = new TInputLinePiped( TRect( 39, 3, 70, 4 ), 80 );
    d->insert( control2 );
    d->insert( new TLabel( TRect( 38, 2, 69, 3 ), _("~N~ew text"), control2 ) );
    InitHistoryID(RHIDE_History_replace);
    d->insert( new THistory( TRect( 70, 3, 73, 4 ), control2, RHIDE_History_replace ) );

    // Options
    TCheckBoxes *options = new TCheckBoxes( TRect( 3, 6, 37, 10 ),
        new TSItem(_("~C~ase sensitive"),
        new TSItem(_("~W~hole words only"),
        new TSItem(_("~P~rompt on replace"),
        new TSItem(_("~R~eplace all"), 0 )))));
    d->insert( options );
    d->insert(
        new TLabel( TRect( 2, 5, 35, 6 ), _("Options"), options ) );

    // Scope
    TRadioButtons *scope = new TRadioButtons( TRect( 3, 12, 37, 14 ),
                           new TSItem( _("~G~lobal"),
                           new TSItem( _("~S~elected text"), 0 )));
    d->insert( scope );
    d->insert(
        new TLabel( TRect( 2, 11, 35, 12 ), _("Scope"), scope ) );

    // Origin
    TRadioButtons *origin = new TRadioButtons( TRect( 39, 6, 73, 8 ),
                            new TSItem( _("~F~rom cursor"),
                            new TSItem( _("~E~ntire scope"), 0 )));
    d->insert( origin );
    d->insert(
        new TLabel( TRect( 38, 5, 71, 6 ), _("Origin"), origin ) );

    d->insert(
        new TButton( TRect( 49, 15, 59, 17 ), _("O~K~"), cmOK, bfDefault ) );
    d->insert(
        new TButton( TRect( 61, 15, 74, 17 ),_("Cancel"), cmCancel, bfNormal ) );

    d->selectNext( False );

    return d;
}

#define YSLOCheckB   2
#define AlSLOCheckB  10
#define YSLORadB     YSLOCheckB
#define AlSLORadB    4
#define YSLOLabRadB  (YSLORadB-1)
#define YSLOInTab    (YSLORadB+AlSLORadB+2)
#define YSLOButs     (YSLOCheckB+AlSLOCheckB+1)
#define AlSLO        YSLOButs+3

#define XSLOCheck    2
#define AnSLOCheck   37
#define XSLORad      (XSLOCheck+AnSLOCheck+2)
#define AnSLORad     33
#define XSLOTab      (XSLOCheck+AnSLOCheck+3)

#define AnSLO        (XSLORad+AnSLORad+3)

static
TDialog *createSetLocalOptions()
{
    TDialog *d = new TDialog( TRect( 0, 0, AnSLO , AlSLO ), _("Local Options") );

    d->options |= ofCentered;

    d->insert( new TCheckBoxes( TRect( XSLOCheck, YSLOCheckB, XSLOCheck+AnSLOCheck, YSLOCheckB+AlSLOCheckB ),
        new TSItem(_("~O~verwrite"),
        new TSItem(_("~A~utoindent"),
        new TSItem(_("~U~se tabs"),
        new TSItem(_("~P~ersistent blocks"),
        new TSItem(_("~I~nteligent C indent"),
        new TSItem(_("~C~olumn cursor"),
        new TSItem(_("~R~ow cursor"),
        new TSItem(_("~M~atch pair highlight"),
        new TSItem(_("Tra~n~sparent Blocks"),
        new TSItem(_("Optimal ~F~ill"), 0 ))))))))))));


    TRadioButtons *shl = new TRadioButtons( TRect( XSLORad, YSLORadB, XSLORad+AnSLORad, YSLORadB+AlSLORadB ),
                         new TSItem(_("O~f~f"),
                         new TSItem(_("~C~++ style"),
                         new TSItem(_("Pa~s~cal style"),
                         new TSItem(_("C~l~ipper style"), 0 )))));
    d->insert(shl);
    d->insert(
        new TLabel( TRect( XSLORad, YSLOLabRadB, XSLORad+AnSLORad, YSLOLabRadB+1 ), _("Syntax ~H~ighlight"), shl ) );

    TInputLine *tab = new TInputLine( TRect( XSLOTab, YSLOInTab, XSLOTab+5, YSLOInTab+1 ), 3 );
    d->insert( tab );
    d->insert(
        new TLabel( TRect( XSLOTab-1, YSLOInTab-1, XSLOTab+17, YSLOInTab ), _("~T~ab size"), tab ) );

    d->insert( new TButton( TRect( AnSLO-26, YSLOButs, AnSLO-16, YSLOButs+2 ),
               _("O~K~"), cmOK, bfDefault ) );
    d->insert( new TButton( TRect( AnSLO-14, YSLOButs, AnSLO-2, YSLOButs+2 ),
               _("Cancel"), cmCancel, bfNormal ) );

    d->selectNext( False );

    return d;
}

#define YSGOCheckB   2
#define AlSGOCheckB  10
#define YSGORadB     (YSGOCheckB+AlSGOCheckB+2)
#define AlSGORadB    -2
#define YSGOLabRadB  (YSLORadB-1)
#define YSGOInTab    (YSGORadB+AlSGORadB+2)
#define YSGOButs     (YSGOInTab+2)
#define AlSGO        YSGOButs+3

static
TDialog *createSetGlobalOptions()
{
    TDialog *d = new TDialog( TRect( 0, 0, 49, AlSGO ), _("Global Options") );

    d->options |= ofCentered;

    d->insert( new TCheckBoxes( TRect( 3, YSGOCheckB, 46, YSGOCheckB+AlSGOCheckB ),
        new TSItem(_("~A~utoindent"),
        new TSItem(_("~U~se tabs"),
        new TSItem(_("~P~ersistent blocks"),
        new TSItem(_("~I~nteligent C indent"),
        new TSItem(_("~C~olumn cursor"),
        new TSItem(_("~R~ow cursor"),
        new TSItem(_("~M~atch pair highlight"),
        new TSItem(_("~D~on't move the cursor on Paste"),
        new TSItem(_("Tra~n~sparent Blocks"),
        new TSItem(_("Optimal ~F~ill"), NULL ))))))))))));


    TInputLine *tab = new TInputLine( TRect( 3, YSGOInTab, 8, YSGOInTab+1 ), 3 );
    d->insert( tab );
    d->insert(
        new TLabel( TRect( 2, YSGOInTab-1, 20, YSGOInTab ), _("~T~ab size"), tab ) );

    d->insert( new TButton( TRect( 4, YSGOButs, 14, YSGOButs+2 ),
               _("To a~l~l"), cmYes, bfNormal ) );
    d->insert( new TButton( TRect( 15, YSGOButs, 25, YSGOButs+2 ),
               _("~O~K"), cmOK, bfDefault ) );
    d->insert( new TButton( TRect( 26, YSGOButs, 38, YSGOButs+2 ),
               _("Cancel"), cmCancel, bfNormal ) );

    d->selectNext( False );

    return d;
}

unsigned doEditDialog( int dialog, ... )
{
    va_list arg;

    char buf[256]; // 80 is not enough
    ostrstream os( buf, sizeof( buf ) );
    switch( dialog )
        {
        case edOutOfMemory:
            return messageBox( _("Not enough memory for this operation"),
                               mfError | mfOKButton );
        case edReadError:
            {
            char *fname;
            va_start( arg, dialog );
            fname = va_arg(arg,char *);
            va_end(arg);
            return messageBox(mfError|mfOKButton,"%s %s. %s(%d)",
                  _("Error reading file "),fname,strerror(errno),errno);
            }
        case edWriteError:
            {
            va_start( arg, dialog );
            os << _("Error writing file ") << va_arg(arg, char *)
               << "." << ends;
            va_end( arg );
            return messageBox( buf, mfError | mfOKButton );
            }
        case edCreateError:
            {
            va_start( arg, dialog );
            os << _("Error creating file ") << va_arg( arg, char *)
               << "." << ends;
            va_end( arg );
            return messageBox( buf, mfError | mfOKButton );
            }
        case edSaveModify:
            {
            va_start( arg, dialog );
            os << va_arg( arg, char *)
               << _(" has been modified. Save?") << ends;
            va_end( arg );
            return messageBox( buf, mfInformation | mfYesNoCancel );
            }
        case edSaveUntitled:
            return messageBox( _("Save untitled file?"),
                               mfInformation | mfYesNoCancel );
        case edSaveAs:
            {
            va_start( arg, dialog );
            ushort retval = execDialog(
             FileOpenDialog(Project.defaultprojectmask,
                    _("Save file as"),_("~N~ame"),fdOpenButton|fdHelpButton,
                    RHIDE_History_source_file,default_directory),
                    va_arg(arg, char *));
            va_end(arg);
            return retval;
            }

        case edFind:
            {
            va_start( arg, dialog );
            return execDialog( createFindDialog(), va_arg(arg, char *));
            }

        case edSearchFailed:
            return messageBox(_("Search string not found."),
                               mfError | mfOKButton );
        case edReplace:
            {
            va_start(arg, dialog);
            return execDialog(createReplaceDialog(), va_arg(arg, char *));
            }

        case edReplacePrompt:
            {
            //  Avoid placing the dialog on the same line as the cursor
            TRect r( 0, 1, 40, 8 );
            r.move( (TProgram::deskTop->size.x-r.b.x)/2, 0 );
            TPoint t = TProgram::deskTop->makeGlobal( r.b );
            t.y++;
            va_start( arg, dialog );
            TPoint *pt = va_arg( arg, TPoint *);
            if( pt->y <= t.y )
                r.move( 0, TProgram::deskTop->size.y - r.b.y - 2 );
            va_end( arg );
            return messageBoxRect( r, _("Replace this occurence?"),
                                   mfYesNoCancel | mfInformation );
            }

        case edJumpToFunction:
            {
             int *p;
             char *bu;
             unsigned l;

             va_start( arg, dialog );
             p=va_arg(arg,int *);
             bu=va_arg(arg,char *);
             l=va_arg(arg,unsigned);

             *p=SelectFunctionToJump(bu,l);

             return (*p!=-1);
            }

        case edSetLocalOptions:
            {
             void *p;
             va_start( arg, dialog );
             p=va_arg(arg,void *);
             return (execDialog( createSetLocalOptions(), p ) == cmOK);
            }

        case edSetGlobalOptions:
            {
             void *p;
             va_start( arg, dialog );
             p=va_arg(arg,void *);
             ushort ret=execDialog( createSetGlobalOptions(), p );
             if (ret==cmYes)
               {
                TEvent event;
                event.what = evBroadcast;
                event.message.command = cmcSetGlobalOptions;
                event.message.infoPtr = p;
                TProgram::deskTop->forEach(ApplyBroadcast,&event);
               }
             return (ret==cmYes) || (ret==cmOK);
            }

        case edLineOverflow:
            return messageBox( _("Line too long, cut it?"),
                               mfError | mfYesButton | mfNoButton);
        }
 return 0;
}

extern "C" int eval(char *mit,char **out);

void ShowCalculator()
{
#if 1
  TRect r(10,2,72,11);
  TDialog *dialog;
  TInputLine *input;
  TInputLine *result;
  ushort retval;
  char *startval;
  dialog = new TDialog(r,_("Calculator"));
  dialog->helpCtx = hcCalculatorDialog;
  r.a.x = 2;
  r.a.y = 2;
  r.b.x = dialog->size.x - 5;
  r.b.y = r.a.y + 1;
  input = new TInputLinePiped(r,255);
  startval = WUC();
  if (startval)
  {
    input->setData(startval);
    string_free(startval);
  }
  dialog->insert(input);
  InitHistoryID(RHIDE_History_Calculator);
  dialog->insert(new THistory(TRect(r.b.x,r.a.y,r.b.x+3,r.b.y), input,
                      RHIDE_History_Calculator));
  r.move(0,-1);
  dialog->insert(new TLabel(r,_("~E~xpression"),input));
  r.move(0,3);
  result = new TInputLinePiped(r,255,tilpNoPipe | tilpNoPaste);
  dialog->insert(result);
  r.move(0,-1);
  dialog->insert(new TLabel(r,_("~R~esult"),result));
  r.move(0,3);
  r.b.x = r.a.x + 12;
  r.b.y = r.a.y + 2;
  dialog->insert(new TLButton(r,_("E~v~al"),cmOK,bfDefault));
  r.a.x = r.b.x + 2;
  r.b.x = r.a.x + 12;
  dialog->insert(new TLButton(r,_("Cancel"),cmCancel,bfNormal));
  r.a.x = r.b.x + 2;
  r.b.x = r.a.x + 12;
  dialog->insert(new TLButton(r,_("~H~elp"),cmHelp,bfNormal));
  input->select();
  dialog->options |= ofCentered;
  TProgram::deskTop->insert(dialog);
  do
  {
    dialog->setState(sfModal, True);
    retval = dialog->execute();
    if (retval == cmOK)
    {
      char input_buffer[256],*ret;
      input->getData(input_buffer);
      int err=eval(input_buffer,&ret);
      if (err)
        {
         sprintf(input_buffer,_("Error in expression (%d)"),err);
         messageBox(input_buffer,mfError | mfOKButton);
        }
      result->setData(ret);
      input->selectAll(True);
    }
  } while (retval == cmOK);
  destroy(dialog);
#else
  executeCalc(NULL);
#endif
}

