/*
**   XONOFF.C
**
**   1. XON/XOFF protocol can NOT be used with binary data.
**   2. Before using XioPutc() and XioGetc(), call XioSetup() with
**      LoWater = 16, and HiWater = RX_QUEUE_SIZE - 16, where
**      RX_QUEUE_SIZE is the queue size passed in SioRxBuf().
**   3. After calling XioSetup(), call XioPutc() and XioGetc()
**      instead of SioPutc() and SioGetc().
*/

#include "pcl4c.h"
#include "xonoff.h"

#define XON  0x11
#define XOFF 0x13

static char LastXsent = XON;
static char LastXreceived = XON;
static int  RxHiWater = 48;
static int  RxLoWater = 16;

void XioSetup(int LoWater,int HiWater)
{RxLoWater = LoWater;
 RxHiWater = HiWater;
 LastXsent = XON;
 LastXreceived = XON;
}

int XioPutc(int Port,char C)
{if(LastXreceived==XOFF) return -1;
 return SioPutc(Port,C);
}

int XioGetc(int Port)
{int C;
 C = SioGetc(Port,0);
 if((C==XON)||(C==XOFF)) LastXreceived = C;
 else switch(LastXsent)
   {case XOFF:
      if(SioRxQue(Port)<=RxLoWater) SioPutc(Port,LastXsent=XON);
      break;
    case XON:
      if(SioRxQue(Port)>=RxHiWater) SioPutc(Port,LastXsent=XOFF);
      break;
   }
 return C;
}

