#include <math.h>
#include "sin.h"

// sine and cosine tables

int sinus[361];
int cosinus[361];

// return sine of angle given in degrees

int zDSin(int deg)
{
    //deg %= 360;
	if (deg < 0)
		deg += 360;
    return(sinus[deg]);
}

// return sine of angle given in radians

int zRSin(double rad)
{
    return(zDSin((int) (rad * 180 / PI)));
}

// return cosine of angle given in degrees

int zDCos(int deg)
{
    //deg %= 360;
	if (deg < 0)
		deg += 360;
    return(cosinus[deg]);
}

// return cosine of angle given in radians

int zRCos(double rad)
{
    return(zDCos((int) (rad * 180 / PI)));
}

// initializes sin/cos tables.  VERY IMPORTANT that this is called.  If you
// #include "3dtools.h", this function is called automatically when the 
// world3d object initializes

void initSinCos()
{
	int count;

	for (count = 0; count <= 360; count++)
	{
        sinus[count] = (int) (sin((float) count * PI / 180) * 256);
        cosinus[count] = (int) (cos((float) count * PI / 180) * 256);
	}

}

