/*
	MTVGA.CPP
	---------
	(c) PLOTSO 1997

*/
#include <math.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include "mt.h"

#pragma inline

bitmap *screen=0;

errors MTerror=Ok;
errors err() { return MTerror; }
void vretrace()
{
      while(inp(0x3da)&8);
      while(!(inp(0x3da)&8));
}
void setmode(int mode)
{
	if(mode==0x13 && screen==0)
	{
		screen=new bitmap;
		screen->data=(char*)MK_FP(0xa000,0);
		screen->up=screen->left=0;
		screen->lev=screen->right=320;
		screen->kor=screen->down=200;
	}
	asm {
		mov ax,[mode]
		int 0x10
	}
}
void putpixel(int x,int y,char col,bitmap *dest)
{
	if(x>=dest->left && y>=dest->up && x<dest->right && y<dest->down)
	asm {
		les di,[dest]   // huono tapa??? (ainakin hidas :( )
		mov bx,[es:di]  // no, en saanut muullakaan tavalla
		les di,[es:di+4]// toimimaan :(

		mov ax,y
		mul bx
		add di,ax
		add di,x

		mov al,col
		mov [es:di],al
	}
}
char getpixel(int x,int y,bitmap *sour)
{
	if(x>=sour->left && y>=sour->up && x<sour->right && y<sour->down)
	asm {
		les di,[sour]
		mov bx,[es:di]
		les di,[es:di+4]

		mov ax,y
		mul bx
		add di,ax
		add di,x

		mov al,[es:di]
	}
	else return 0;
}
void put_image(int x,int y,int lev,int kor,char *pic,bitmap *dest)
{
	int a,b;
	long diplus=0,siplus=0;
	unsigned plus=0,sip=0;
	int uuslev=lev,uuskor=kor;

	if(y>=dest->down || x>=dest->right  || x+lev<=dest->left || y+kor<=dest->up) return;
	if(y<dest->up) { siplus=(dest->up-y)*lev;uuskor-=(dest->up-y);diplus=(long)dest->up*dest->lev; } else { diplus=(long)y*dest->lev; }
	if(x<=dest->left) { siplus+=dest->left-x;uuslev-=dest->left-x;sip=dest->left-x;plus=dest->left;diplus+=dest->left; } else { diplus+=x;plus=x; }

	a=x+lev;
	if(a>dest->right) { a-=dest->right;uuslev-=a;sip+=a;plus+=dest->lev-dest->right; }
	else { plus+=dest->lev-a; }
	a=y+kor;
	if(a>dest->down) { uuskor-=a-dest->down; }
	asm {
		les di,[dest]
		les di,[es:di+4]
		add di,[diplus]
		push ds
		lds si,[pic]
		add si,[siplus]

		mov bx,uuslev
		mov ax,bx
		and ax,3
		shr bx,2
	}
loop:
	asm {
		mov cx,bx
		rep movsd
		mov cx,ax
		rep movsb
		add di,plus
		add si,sip
		dec word ptr [uuskor]
		jnz loop
		pop ds
	}
}
void put_sprite(int x,int y,int lev,int kor,char *pic,bitmap *dest)
{
	int a,b;
	long diplus=0,siplus=0;
	unsigned plus=0,sip=0;
	int uuslev=lev,uuskor=kor;

	if(y>=dest->down || x>=dest->right  || x+lev<=dest->left || y+kor<=dest->up) return;
	if(y<dest->up) { siplus=(dest->up-y)*lev;uuskor-=(dest->up-y);diplus=(long)dest->up*dest->lev; } else { diplus=(long)y*dest->lev; }
	if(x<=dest->left) { siplus+=dest->left-x;uuslev-=dest->left-x;sip=dest->left-x;plus=dest->left;diplus+=dest->left; } else { diplus+=x;plus=x; }
	a=x+lev;
	if(a>dest->right) { a-=dest->right;uuslev-=a;sip+=a;plus+=dest->lev-dest->right; }
	else { plus+=dest->lev-a; }

	a=y+kor;
	if(a>dest->down) { uuskor-=a-dest->down; }
	asm {
		les di,[dest]
		les di,[es:di+4]
		add di,[diplus]
		push ds
		lds si,[pic]
		add si,[siplus]
	}
loop:
	asm     mov cx,uuslev
loop2:
	asm {
		lodsb
		or al,al
		je skip
		mov [es:di],al
	}
skip:
	asm {
		inc di
		dec cx
		jnz loop2
		add di,plus
		add si,sip
		dec word ptr [uuskor]
		jnz loop
		pop ds
	}
}
void clear(bitmap *dest)
{
	asm {
		les di,[dest]
		mov bx,[es:di]
		mov ax,[es:di+2]
		mul bx
		les di,[es:di+4]
		mov cx,ax
		mov bx,ax
		and bx,3
		shr cx,2
		xor eax,eax
		rep stosd
		mov cx,bx
		rep stosb
	}
}
void clear(char col,bitmap *dest)
{
	asm {
		les di,[dest]
		mov bx,[es:di]
		mov ax,[es:di+2]
		mul bx
		les di,[es:di+4]
		mov cx,ax
		mov bx,ax
		and bx,3
		shr cx,2
		mov dl,col
		mov al,dl
		mov ah,dl
		shl eax,16
		mov al,dl
		mov ah,dl
		rep stosd
		mov cx,bx
		rep stosb
	}
}
void line(int x1,int y1,int x2,int y2,char c,bitmap *dest)
{
	int d,x,y,ax,ay,sx,sy,dx,dy;
	dx=x2-x1; ax=abs(dx)<<1; sx=((dx<0) ? -1 : 1);
	dy=y2-y1; ay=abs(dy)<<1; sy=((dy<0) ? -1 : 1);

	x=x1; y=y1;
	if(ax>ay)
	{
		d=ay-(ax>>1);
		while(x!=x2)
		{
			if(x>=dest->left && y>=dest->up && x<dest->right && y<dest->down)
				putpixel2(x,y,c,dest);
			if(d>=0) { y+=sy; d-=ax; }
			x+=sx; d+=ay;
		}
	}
	else
	{
		d=ax-(ay>>1);
		while(y!=y2)
		{
			if(x>=dest->left && y>=dest->up && x<dest->right && y<dest->down)
				putpixel2(x,y,c,dest);
			if(d>= 0) { x+=sx; d-=ay; }
			y+=sy; d+=ax;
		}
	}
}
void hline(int x,int y,int lev,char c,bitmap *dest)
{
	if(y<dest->up || y>=dest->down || x>=dest->right) return;
	if(x<dest->left) { lev-=dest->left-abs(x);x=dest->left; }
	if(x+lev>=dest->right) lev=dest->right-x;
	if(lev<=0) return;
	asm {
		les di,[dest]
		mov bx,[es:di]
		les di,[es:di+4]

		mov ax,y
		mul bx
		add di,ax
		add di,x

		mov bl,[c]
		mov al,bl
		mov ah,bl
		shl eax,16
		mov al,bl
		mov ah,bl

		mov cx,[lev]
		mov bx,cx
		and bx,3
		shr cx,2
		rep stosd
		mov cx,bx
		rep stosb
	}
}
void vline(int x,int y,int kor,char c,bitmap *dest)
{
	if(x<dest->left || x>=dest->right || y>=dest->down) return;
	if(y<dest->up) { kor-=dest->up-abs(y);y=dest->up; }
	if(y+kor>=dest->down) kor=dest->down-y;
	int plus=dest->lev;
	if(kor<=0) return;
	asm {
		les di,[dest]
		mov bx,[es:di]
		les di,[es:di+4]

		mov ax,y
		mul bx
		add di,ax
		add di,x

		mov cx,[kor]
		mov al,[c]
	}
loop:
	asm {
		mov [es:di],al
		add di,plus
		dec cx
		jnz loop
	}
}
void hline2(int x,int x2,int y,char c,bitmap *dest)
{
	int tmp;
	if(x>x2) { tmp=x; x=x2; x2=tmp; }
	hline(x,y,(x2-x),c,dest);
}
void vline2(int x,int y,int y2,char c,bitmap *dest)
{
	int tmp;
	if(y>y2) { tmp=y; y=y2; y2=tmp; }
	vline(x,y,(y2-y),c,dest);
}
void circle(int cx,int cy,int r,char c,bitmap *dest)
{
	int x,l=r;
	int d=3-(2*r);
	for (x=0;x<=l;x++)
	{
		putpixel(cx+x,cy+l,c,dest);
		putpixel(cx+x,cy-l,c,dest);
		putpixel(cx-x,cy+l,c,dest);
		putpixel(cx-x,cy-l,c,dest);
		putpixel(cx+l,cy+x,c,dest);
		putpixel(cx+l,cy-x,c,dest);
		putpixel(cx-l,cy+x,c,dest);
		putpixel(cx-l,cy-x,c,dest);
		if (d<0) d=d+(4*x)+6; else { d+=4*(x-l)+10;l--; }
	}
}
void fcircle(int cx,int cy,int r,char c,bitmap *dest)
{
	int x,l=r;
	int d=3-(2*r);
	for (x=0;x<=l;x++)
	{
		hline2(cx+x,cx-x,cy+l, c,dest);
		hline2(cx+x,cx-x,cy-l, c,dest);
		hline2(cx+l,cx-l,cy+x, c,dest);
		hline2(cx+l,cx-l,cy-x, c,dest);
		if (d<0) d=d+(4*x)+6; else { d+=4*(x-l)+10;l--; }
	}
}
void createbitmap(bitmap *pic,int lev,int kor)
{
	pic->data=new char [lev*kor];
	if(!pic->data) { MTerror=Mem; return; }
	pic->lev=lev;pic->kor=kor;
	setcut(0,0,lev,kor,pic);
}
void copy(bitmap *sour,bitmap *dest, int sx,int sy,int dx,int dy,int lev,int kor)
{
	int k1=dx+lev,k2=dy+kor;
	if(k1<0 || k2<0 || dx>dest->lev || dy>dest->kor) return;

	int ox1=dest->left, ox2=dest->right, oy1=dest->up, oy2=dest->down;
	if(k1>ox2) k1=ox2; if(k2>oy2) k2=oy2;
	int dx2=dx, dy2=dy;
	if(dx2<ox1) dx2=ox1;
	if(dy2<oy1) dy2=oy1;
	if(dx2>=k1 || dy2>=k2) return;
	dest->cut(dx2,dy2, k1,k2);
	sour->putimage(dx-sx,dy-sy,dest);
	dest->cut(ox1,oy1,ox2,oy2);
}
void mirrorv(bitmap *dest,bitmap *sour)
{
	int a,b,c;
	createbitmap(dest,sour->lev,sour->kor);
	if(!dest->data) return;
	for(a=0;a<sour->kor;a++)
		for(b=0;b<sour->lev;b++)
		{
			dest->data[a*sour->lev+b]=sour->data[a*sour->lev+(sour->lev-(b+1))];
		}
}
void scale_pic(int x,int y,int lev,int kor,int uuslev,int uuskor,char *source,bitmap *dest)
{
	if(uuskor<=0 || uuslev<=0 || x+uuslev<=0 || y+uuskor<=0 || x>=dest->lev || y>=dest->kor) return;
	long xp=long(((long)lev<<16)/uuslev);
	long yp=long(((long)kor<<16)/uuskor);
	long y2=0L,cx1=0L,xplus=0L,xplus2=0L;

	if(uuskor+y>dest->kor) uuskor=dest->kor-y;
	if(y<0) { y2=abs(y)*yp;uuskor-=abs(y); }
	else { cx1=y*dest->lev; }
	if(uuslev+x>dest->lev) { if(x>0) xplus2=x;uuslev=dest->lev-x; }
	else xplus2=dest->lev-uuslev;
	if(x<0) { xplus=abs(x)*xp;uuslev-=abs(x);xplus2=dest->lev-uuslev; }
	else { cx1+=x; }
	asm {
		push ds
		lds si,[source]
		les di,[dest]
		les di,[es:di+4]
		add di,[cx1]
	}
loop1:
	asm {
		mov eax,[y2]
		shr eax,16
		mov bx,[lev]
		mul bx
		mov edx,[xplus]
		mov cx,[uuslev]
	}
loop2:
	asm {
		push eax
		mov ebx,edx
		shr ebx,16
		add eax,ebx
		push esi
		add esi,eax
		mov bl,[ds:si]
		mov [es:di],bl
		inc di
		pop esi
		pop eax
		add edx,[xp]
		dec cx
		jnz loop2
		add di,[xplus2]
		mov eax,[yp]
		add [y2],eax
		dec word ptr [uuskor]
		jnz loop1
		pop ds
	}
}
void scale_spr(int x,int y,int lev,int kor,int uuslev,int uuskor,char *source,bitmap *dest)
{
	if(uuskor<=0 || uuslev<=0 || x+uuslev<=0 || y+uuskor<=0 || x>=dest->lev || y>=dest->kor) return;
	long xp=long(((long)lev<<16)/uuslev);
	long yp=long(((long)kor<<16)/uuskor);
	long y2=0L,cx1=0L,xplus=0L,xplus2=0L;

	if(uuskor+y>dest->kor) uuskor=dest->kor-y;
	if(y<0) { y2=abs(y)*yp;uuskor-=abs(y); }
	else { cx1=y*dest->lev; }
	if(uuslev+x>dest->lev) { if(x>0) xplus2=x;uuslev=dest->lev-x; }
	else xplus2=dest->lev-uuslev;
	if(x<0) { xplus=abs(x)*xp;uuslev-=abs(x);xplus2=dest->lev-uuslev; }
	else { cx1+=x; }

	asm {
		push ds
		lds si,[source]
		les di,[dest]
		les di,[es:di+4]
		add di,[cx1]
	}
loop1:
	asm {
		mov eax,[y2]
		shr eax,16
		mov bx,[lev]
		mul bx
		mov edx,[xplus]
		mov cx,[uuslev]
	}
loop2:
	asm {
		push eax
		mov ebx,edx
		shr ebx,16
		add eax,ebx
		push esi
		add esi,eax
		mov bl,[ds:si]
		or bl,bl
		je skip
		mov [es:di],bl
	}
skip:
	asm {
		inc di
		pop esi
		pop eax
		add edx,[xp]
		dec cx
		jnz loop2
		add di,[xplus2]
		mov eax,[yp]
		add [y2],eax
		dec word ptr [uuskor]
		jnz loop1
		pop ds
	}
}
void put_spritecol(int x,int y,int lev,int kor,char col,char *pic,bitmap *dest)
{
	int a,b;
	long diplus=0,siplus=0;
	unsigned plus=0,sip=0;
	int uuslev=lev,uuskor=kor;

	if(y>=dest->down || x>=dest->right  || x+lev<=dest->left || y+kor<=dest->up) return;
	if(y<dest->up) { siplus=(dest->up-y)*lev;uuskor-=(dest->up-y);diplus=(long)dest->up*dest->lev; } else { diplus=(long)y*dest->lev; }
	if(x<=dest->left) { siplus+=dest->left-x;uuslev-=dest->left-x;sip=dest->left-x;plus=dest->left;diplus+=dest->left; } else { diplus+=x;plus=x; }
	a=x+lev;
	if(a>dest->right) { a-=dest->right;uuslev-=a;sip+=a;plus+=dest->lev-dest->right; }
	else { plus+=dest->lev-a; }

	a=y+kor;
	if(a>dest->down) { uuskor-=a-dest->down; }
	asm {
		les di,[dest]
		les di,[es:di+4]
		add di,[diplus]
		push ds
		lds si,[pic]
		add si,[siplus]
	}
loop:
	asm     mov cx,uuslev
loop2:
	asm {
		lodsb
		or al,al
		je skip
		mov al,[col]
		mov [es:di],al
	}
skip:
	asm {
		inc di
		dec cx
		jnz loop2
		add di,plus
		add si,sip
		dec word ptr [uuskor]
		jnz loop
		pop ds
	}
}
