/*=================================================================

                   Neuromancer's Graphics Library
		           Version 1.0

   This program will demonstrates all the features of this 
   library

   Project:	MTLIB01.LIB
		MTDEMO.CPP

 *=================================================================*/
#include <iostream.h>
#include <conio.h>
#include <stdlib.h>
#include "video.h"
#include "fonts.h"
#include "palette.h"
#include "circle.h"
#include "line.h"
#include "rect.h"
#include "image.h"
#include "mouse.h"
#include "ellipse.h"


byte sprite2[] = {
  /*20,20,*/
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 75, 75,
 75, 75, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75

};

byte sprite3[]={
//20,20
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 80, 80, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 80, 80, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 80, 80, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 80, 80, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 80, 80, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 80, 80, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 80, 80, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 80, 80, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 80, 80, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 80, 80, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 80, 80, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 80, 80, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 80, 80, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 80, 80, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 80, 80, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 80, 80, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75
};

byte sprite4[]={
//20,20
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 80, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 80, 80, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 80, 80, 80, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 80, 80, 80, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 80, 80, 80, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 80, 80, 80, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 80, 80, 80, 45, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 80, 80, 80, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 80, 80, 80, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 80, 80, 80, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 80, 80, 80, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 45, 80, 80, 80, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 80, 80, 80, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 80, 80, 80, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 80, 80, 80, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 80, 80, 80, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75
};


byte sprite5[]={
//20,20
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 80, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 80, 80, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 80, 80, 80, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 80, 80, 80, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 80, 80, 80, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 80, 80, 80, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 45, 80, 80, 80, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 45, 80, 80, 80, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 45, 80, 80, 80, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 45, 80, 80, 80, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 45, 80, 80, 80, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 45, 80, 80, 80, 45, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 45, 80, 80, 80, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 45, 80, 80, 80, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 45, 80, 80, 80, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 80, 80, 80, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75
};


block page1,page2;

int Show_Palette_Routine()
{
	byte palette[768];
	byte palblack[768];

	mtClearPal(palblack);

	if ((page1 = mtSetBlk(0,0,319,199))==NULL)
	{
		return 1;
	}
	
	mtSetPage(PAGE_1);
	if (mtLoadPCX("poolball.dat")==0)
	{
		return 1;
	}

	mtGetAllPal(palette);
	mtSetPal(palblack,0,255);
	mtCopyToScreen(PAGE_1);

	mtFadeIn(palette,1,40);

	while (!kbhit());

	mtFadeOut(30);

	mtSetPage(PAGE_0);

	mtClrScr(0);

	mtSetPage(PAGE_1);
	mtLoadPCX("pacman.dat");
	mtCopyToScreen(PAGE_1);

	return 0;

}

void Pixel_Routine()
{
	randomize();

	mtSetWindow(15,15,304,184);	//set up clip region

	while(!kbhit())
	{
	   mtCPutPixel( random(320),random(200),random(256));
	}
	
}


void Line_Routine()
{
	while(!kbhit())
	{
	   mtCLine( random(320),random(200),random(320), random(200), random(256));
	}
}

void Circle_Routine()
{

	int x,y,major,color;

	randomize();

	while(!kbhit())
	{
	    x = random(320)+1;
	    y = random(200)+1;
	    major = random(40);
	    color = random(256);

	    if ((major < x ) || (major < y))
	    {
		mtCCircle(x,y,major,color);
	    }
	 }

	 getch();

	 while(!kbhit())
	 {
	    x = random(320)+1;
	    y = random(200)+1;
	    major = random(40);
	    color = random(256);

	    if ((major < x ) || (major < y))
	    {
		mtCFillCircle(x,y,major,color);
	    }
	 }

}

void Ellipse_Routine()
{
	int x,y,major,minor,color;
	
	 while(!kbhit())
	 {  
  	    x = random(320)+1;
	    y = random(200)+1;
	    major = random(40);
	    color = random(256);
	    minor = random(40);

	    mtCEllipse(x,y,major,minor,color);
	    
	}

	getch();

	while(!kbhit())
	{  
  	    x = random(320)+1;
	    y = random(200)+1;
	    major = random(40);
	    color = random(256);
	    minor = random(40);

	    mtCFillEllipse(x,y,major,minor,color);
	    
	}


}


void Rect_Routine()
{
	while(!kbhit())
	{
	   mtCRect(random(320),random(200),random(320),random(200), random(256));
	}

	getch();

	while(!kbhit())
	{
	   mtCFillRect(random(320),random(200),random(320),random(200), random(256));
	}
}

 
int Mouse_Routine()
{
	int button=-1,xm=0,ym=0;
	
	if (mtInitMouse()==0){
		return 1;
	}

	mtShowMouse();

	do
	{
		mtGetMousePos(&button, &xm, &ym);

	}while(button<=0);

	mtHideMouse();
}


int Animation_Routine()
{

	int xcor;
	int ycor;

	int xcor1;
	int ycor1;

	int xdir;
	int ydir;

	int xdir1;
	int ydir1;
	int flag=0;
	int inc=0;
	int ch;

	SPRITE		*spriteheader;
	SPRITETYPE	**sprite;
	byte		palette[768];

	if ((spriteheader=mtLoadBM("testbmp",palette)) == NULL)
	{
		return 1;
	}

	sprite = spriteheader->sprite;
	
	xcor = random(297);
	ycor = random(170);
	xcor1 =random(300);
	ycor1 =random(179);

	xdir = 5;
	ydir = 5;
	xdir1 =5;
	ydir1 =5;
	flag=0;
	inc=0;

	if ((page2=mtSetBlk(0,0,319,199))==NULL)
	{
		return 1;
	}
	
	mtCopyPage(PAGE_1,PAGE_2);

	mtSetPage(PAGE_1);
	
	while(!kbhit())
	{
		xcor += xdir;
		ycor += ydir;

		xcor1 += xdir1;
		ycor1 += ydir1;

		if (xcor < 0 || xcor > 297 ) {
			xdir = -xdir;
			xcor += xdir;
		}

		if (ycor <0|| ycor >170) {
			ydir = -ydir;
			ycor += ydir;
		}

		if (xcor1<0||xcor1 >300) {
			xdir1 = -xdir1;
			xcor1 += xdir1;
		}
		
		if (ycor1 <0 || ycor1>179) {
			ydir1 = -ydir1;
			ycor1 += ydir1;
		}

		mtCPutSprite(xcor, ycor, sprite[0]->width,sprite[0]->height,sprite[0]->data);

		if (flag ==0){
			mtCPutSprite(xcor1, ycor1, 20, 20, sprite2);	//sprite mode
			inc++;
			if (inc == 1) flag = 1;
		}
		else
		if (flag==1)
		{
			mtCPutSprite(xcor1, ycor1, 20, 20, sprite4);	//sprite mode
			inc++;
			if (inc==2) flag=2;
		}
		else
		if (flag==2)
		{
			mtCPutSprite(xcor1, ycor1, 20, 20, sprite3);	//sprite mode
			inc++;
			if (inc==3) flag=3;
		}
		else
		if (flag==3)
		{	
			mtCPutSprite(xcor1, ycor1, 20, 20, sprite5);	//sprite mode
			inc++;
			if (inc==4)
			{
			 flag=0;
			 inc=0;
			}
		}
		
		mtWaitRetrace();
		mtCopyToScreen(PAGE_1);
		mtCopyPage(PAGE_2,PAGE_1);

	}

	getch();

	free(spriteheader);
	free(page2);

	mtSetPage(PAGE_0);
}


void main(void)
{
	byte palette[768];

	mtSetVGAMode();			//Set up VGA Mode

	sysFont=mtLoadFont("default.fon");

	mtClrScr(0);

	mtPrintStr(95,50,"WELCOME TO");
	mtPrintStr(40,70,"THE MTGRAPH TOOLKIT DEMO");

	getch();

	mtClrScr(0);

	if (Show_Palette_Routine() == 1)
	{
		mtRemoveFont();
		mtSetTextMode();
		cout << "Error encountered! Exiting.."<< endl;
		exit(0);
	}

	getch();
	getch();
	
	mtSetPage(PAGE_0);
	Pixel_Routine();

	getch();

	Line_Routine();

	getch();

	Circle_Routine();

	getch();

	Rect_Routine();

	getch();

	Ellipse_Routine();

	getch();

	mtWaitRetrace();
	mtCopyToScreen(PAGE_1);

	getch();

	mtSetWindow(0,0,319,199);
	mtSetPage(PAGE_0);
	mtClrScr(0);

	mtSetPage(PAGE_1);
	mtLoadPCX("screen1.dat");
	
	mtWaitRetrace();
	mtCopyToScreen(PAGE_1);

	Mouse_Routine();

	mtSetPage(PAGE_0);
	mtPrintStr(30,20,"Now for some Animation Examples");
	mtPrintStr(48,170,"Press Any Key to continue");
	
	getch();

	Animation_Routine();

	mtClrScr(0);
	mtPrintStr(70,60,"THAT'S ALL FOLKS!");

	getch();
	
	mtRemoveFont();
	free(page1);
	mtSetTextMode();

	cout << "Thank you for using the library!" << endl;

	exit(0);
	
}

   		
		    

		   

		   

