/* lzo1c_ds.S -- LZO1C decompression in assembler (i386 + gcc)

   This file is part of the LZO real-time data compression library.

   Copyright (C) 1996 Markus Franz Xaver Johannes Oberhumer

   The LZO library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   The LZO library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the LZO library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation, Inc.,
   675 Mass Ave, Cambridge, MA 02139, USA.

   Markus F.X.J. Oberhumer
   markus.oberhumer@jk.uni-linz.ac.at
 */


/***********************************************************************
// Notes:
//   For reasons of speed this implementation can access (write to)
//   up to 3 bytes past the end of the decompressed (output) block.
//   Data past the end of the compressed (input) block is never
//   accessed (read from).
************************************************************************/

#if 0
#if defined(__GNUC__) && defined(__i386__)
/* fast decompression in assembler - see notes in source code */
LZO_EXTERN(int)
lzo1c_decompress_asm    ( const lzo_byte *src, lzo_uint  src_len,
                                lzo_byte *dst, lzo_uint *dst_len,
                                lzo_voidp wrkmem /* NOT USED */ );
#endif
#endif


#include "lzo_asm.sh"

	.text

	LZO_PUBLIC(lzo1c_decompress_asm)

#include "enter.sh"
#include "lzo1c_d.sh"
#include "leave.sh"


/*
vi:ts=4
*/

