#ifndef __PCX_H
#define __PCX_H

void loadpcx(char *filename, char *buffer) {
    int xsize, ysize, tavu1, tavu2, position=0;
    FILE *handle=fopen(filename, "rb");

    if(handle==NULL) {
        printf("Virhe PCX-tiedoston avauksessa: Tiedostoa ei lydy!\n");
        exit(1);
    }
    fseek(handle, 8, SEEK_SET);
    xsize=fgetc(handle)+(fgetc(handle)<<8)+1;
    ysize=fgetc(handle)+(fgetc(handle)<<8)+1;
    fseek(handle, 128, SEEK_SET);
    while(position<xsize*ysize) {
        tavu1=fgetc(handle);
        if(tavu1>192) {
            tavu2=fgetc(handle);
            for(; tavu1>192; tavu1--)
                buffer[position++]=tavu2;
        } else buffer[position++]=tavu1;
    }
    fclose(handle);
}

void loadpal(char *filename, char *palette) {
    FILE *handle=fopen(filename, "rb");
    int c;

    if(handle==NULL) {
        printf("Virhe PCX-tiedoston palettia luettaessa:"
               " Tiedostoa ei lydy!\n");
        exit(1);
    }

    fseek(handle,-768,SEEK_END);
    for(c=0; c<256*3; c++)
        palette[c] =fgetc(handle)/4;
    fclose(handle);
}

#endif
