/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */

/* target specific includes for WATCOM/VESA */

#ifndef __JTARGET_H__
#define __JTARGET_H__

#ifdef __cplusplus
extern "C" {
#endif 

#ifndef WATCOM
#error Wrong Target header file included in build.
#endif

#ifndef WAT_320x200x256
#ifndef WAT_640x480x256
#ifndef WAT_800x600x256
#error Wrong Target header file included in build.
#endif
#endif
#endif

/* INPUT */
#define KEYBOARD_AVAILABLE 1	/* keyboard support */
#define MOUSE_AVAILABLE 1	/* mouse support  */ 
#define JOYSTICK_AVAILABLE 1	/* joystick support */

/* mouse */
#define MOUSE_NUM_BUTTONS	3
#define MOUSE_B_LEFT	1 
#define MOUSE_B_MIDDLE	2
#define MOUSE_B_RIGHT	4

#define BUTTON_DOWN(status)	(status)
#define BUTTON_CHECK(status,x)	(status & (x))

/* joystick */
typedef struct {
	int joy,xcen,ycen,x1,y1,x2,y2,deadx1,deady1,deadx2,deady2;
} logical_joy;

extern logical_joy __jlib_joys[3];

#define JOY_FIRE1	1
#define JOY_FIRE2	2

#define FIRE_1_DOWN(status)	(status & JOY_FIRE1)
#define FIRE_2_DOWN(status)	(status & JOY_FIRE2)

#define UCLOCK_TICKS_PER_SECOND	1000000L

/* SCREEN */
extern int vesa_remains,vesa_granularity,vesa_gran_mul,vesa_gran1024,vesa_pages,vesa_width,vesa_lfb,__jlib_is_13h,__jlib_pg;

#ifdef WAT_320x200x256
#define  SCREEN_WIDTH	320
#define  SCREEN_HEIGHT	200
#define  SCREEN_MAX_X	319
#define  SCREEN_MAX_Y	199
#endif

#ifdef WAT_640x480x256
#define  SCREEN_WIDTH	640
#define  SCREEN_HEIGHT	480
#define  SCREEN_MAX_X	639
#define  SCREEN_MAX_Y	479
#endif

#ifdef WAT_800x600x256
#define  SCREEN_WIDTH	800
#define  SCREEN_HEIGHT	600
#define  SCREEN_MAX_X	799
#define  SCREEN_MAX_Y	599
#endif

#define  SCREEN_NUM_COLORS	256
#define  SCREEN_NUM_PAGES	1

/*+------------------------------------------------------------------------+*/
/*| Set the VESA output window.                                            |*/
/*+------------------------------------------------------------------------+*/
void __setpg(int vpage);
#pragma aux __setpg= \
	"mov bx,0" \
	"mov ax,0x4f05" \
	"int 0x10" \
	parm [edx] ;

#define vesa_set_page(pg)	if(pg != __jlib_pg){__setpg(pg);__jlib_pg = pg;}

/* MEMORY OPERATIONS */
#include <string.h>

#define VIDEO_START	0xA0000

int get_best_copy_method(void *s,void *d,int l);

#define ALIGNMENT_STATE_1	0
#define ALIGNMENT_STATE_2	1
#define ALIGNMENT_STATE_3	2
#define ALIGNMENT_STATE_4	3
#define ALIGNMENT_STATE_5	4
#define ALIGNMENT_STATE_6	5
#define ALIGNMENT_STATE_7	6
#define ALIGNMENT_STATE_8	7

/* every memory copy is done using memcpy */
#define MEM_COPY_ALIGN_1(x,y,z)	memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_2(x,y,z)	memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_3(x,y,z)	memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_4(x,y,z)	memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_5(x,y,z)	memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_6(x,y,z)	memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_7(x,y,z)	memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_8(x,y,z)	memcpy( (y) , (x) , (z) )

#define FAST_SHORT_COPY(s,d,len)	memcpy( (d) , (s) , (len) )
#define FAST_LONG_COPY(s,d,len)	memcpy( (d) , (s) , (len) )
#define FAST_VERY_LONG_COPY(s,d,len)	memcpy( (d) , (s) , (len) )

void BYTE_COPY(int *src,int *dst,int len);
#pragma aux BYTE_COPY= \
	"rep movsb" \
	parm [esi] [edi] [ecx];

void WORD_COPY(int *src,int *dst,int len);
#pragma aux WORD_COPY= \
	"shr ecx,1" \
	"rep movsw" \
	parm [esi] [edi] [ecx];

void LONG_COPY(int *src,int *dst,int len);
#pragma aux LONG_COPY= \
	"shr ecx,2" \
	"rep movsd"\
	parm [esi] [edi] [ecx];

#ifdef __cplusplus
}
#endif 

#endif
