/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */

/* target specific includes for BORLAND/MODE_13H */

#ifndef __JTARGET_H__
#define __JTARGET_H__

#ifdef __cplusplus
extern "C" {
#endif 

#ifndef BORLAND
#error Wrong Target header file included in build.
#endif

#ifndef MODE_13H
#error Wrong Target header file included in build.
#endif

/* INPUT */
#define KEYBOARD_AVAILABLE 1    /* keyboard support is available */
#define MOUSE_AVAILABLE 0       /* mouse is not available */ 
#define JOYSTICK_AVAILABLE 0    /* joystick support is not available */

/* mouse */
#define MOUSE_NUM_BUTTONS 3
#define MOUSE_B_LEFT   1
#define MOUSE_B_MIDDLE 2
#define MOUSE_B_RIGHT  4

#define BUTTON_DOWN(status)    (status)
#define BUTTON_CHECK(status,x) (status & (x))

/* joystick */
typedef struct  {
    int joy,xcen,ycen,x1,y1,x2,y2,deadx1,deady1,deadx2,deady2;
} logical_joy;

extern logical_joy __jlib_joys[3];

#define JOY_FIRE1 1
#define JOY_FIRE2 2

#define FIRE_1_DOWN(status) (status & JOY_FIRE1)
#define FIRE_2_DOWN(status) (status & JOY_FIRE2)

/* SCREEN */
#define  SCREEN_WIDTH   320
#define  SCREEN_HEIGHT  200
#define  SCREEN_MAX_X   319
#define  SCREEN_MAX_Y   199
#define  SCREEN_NUM_COLORS 256
#define  SCREEN_NUM_PAGES 1

#define __VIDEO_START   MK_FP(0xa000,0)

#define UCLOCK_TICKS_PER_SECOND 1000000L

/* MEMORY OPERATIONS */
#include <string.h>

#define ALIGNMENT_STATE_1   0
#define ALIGNMENT_STATE_2   1
#define ALIGNMENT_STATE_3   2
#define ALIGNMENT_STATE_4   3
#define ALIGNMENT_STATE_5   4
#define ALIGNMENT_STATE_6   5
#define ALIGNMENT_STATE_7   6
#define ALIGNMENT_STATE_8   7

/* every memory copy is done using memcpy */
#define MEM_COPY_ALIGN_1(x,y,z)  memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_2(x,y,z)  memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_3(x,y,z)  memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_4(x,y,z)  memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_5(x,y,z)  memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_6(x,y,z)  memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_7(x,y,z)  memcpy( (y) , (x) , (z) )
#define MEM_COPY_ALIGN_8(x,y,z)  memcpy( (y) , (x) , (z) )

#define FAST_SHORT_COPY(s,d,len)     memcpy( (d) , (s) , (len) )
#define FAST_LONG_COPY(s,d,len)      memcpy( (d) , (s) , (len) )
#define FAST_VERY_LONG_COPY(s,d,len) memcpy( (d) , (s) , (len) )

#define BYTE_COPY(s,d,len) memcpy( (d) , (s) , (len) )
#define WORD_COPY(s,d,len) memcpy( (d) , (s) , (len) )
#define LONG_COPY(s,d,len) memcpy( (d) , (s) , (len) )

#ifdef __cplusplus
}
#endif 

#endif
