/* Copyright 1995-97 Jon Griffiths.  See the file "jlib.doc" for details. */
#include <jlib.h>

void __recurse_fill_color(buffer_rec * buff, int x, int y, UBYTE old, UBYTE new);

/*+------------------------------------------------------------------------+ */
/*|fill an area of color old with color new.                               | */
/*+------------------------------------------------------------------------+ */
void buff_fill_color(buffer_rec * buff, int x, int y, UBYTE old, UBYTE new)
{
	UBYTE *ptr;
	JLIB_ENTER("buff_fill_color");

#ifndef JLIB_PRODUCTION
	jlib_check_buffer(buff);
#endif

	if ((x < B_CX1(buff)) || (x > B_CY1(buff)) || (y < B_CY1(buff)) || (y > B_CY2(buff))) {
		JLIB_LEAVE;
		return;
	}

	ptr = B_OFFSET(buff,y) + x;

	if (*ptr != old) {
		JLIB_LEAVE;
		return;
	}

	__recurse_fill_color(buff, x, y, old, new);

	JLIB_LEAVE;
}


void __recurse_fill_color(buffer_rec * buff, int x, int y, UBYTE old, UBYTE new)
{
	UBYTE *ptr = B_OFFSET(buff,y) + x;
	int xn = x;

	/* scan left */
	while ((*ptr == old) && (xn > B_CX1(buff))) {
		*ptr = new;
		--ptr;
		--xn;
	}

	while (xn <= x) {
		/* recurse above */
		if (y > B_CY1(buff))
			if (y != 0)
				if (*(ptr - B_X_SIZE(buff)) == old)
					__recurse_fill_color(buff,xn,y-1,old,new);

		/* recurse below */
		if (y < B_CY2(buff))
			if (y != B_MAX_X(buff))
				if (*(ptr + B_X_SIZE(buff)) == old)
					__recurse_fill_color(buff,xn,y+1,old,new);
		xn++;
	}

	/* scan right*/
	while ((*ptr == old) && (xn < B_CX2(buff))) {
		*ptr = new;
		++ptr;
		++xn;
	}

	while (xn > x) {
		/* recurse above */
		if (y > B_CY1(buff))
			if (y != 0)
				if (*(ptr - B_X_SIZE(buff)) == old)
					__recurse_fill_color(buff,xn,y-1,old,new);

		/* recurse below */
		if (y < B_CY2(buff))
			if (y != B_MAX_X(buff))
				if (*(ptr + B_X_SIZE(buff)) == old)
					__recurse_fill_color(buff,xn,y+1,old,new);
			
		xn--;
	}
}