#ifndef _hmod_structs_h
#define _hmod_structs_h
/* structs.h, some structures and stuff */
/* the ifndef&define-combinations at the beginning of each .h */
/* are there to make sure that each .h only gets included once */

#define iso unsigned long long
#define _minporta 56
#define _maxporta 27392
#define _notecut 0
#define _portatonote 1
#define _arpeggio 2
#define _porta 3
#define _vibrato 4
#define _tremolo 5
#define _retrignote 6
#define _tremor 7
#define _nothing 255
#define _keyoff 254

/* device structures : */
typedef struct
{
 unsigned char used; /*0 no; 1 yes*/
 unsigned char name[29]; /* sample's name */
 int length; /* samples length */
 int c2spd; /* samples playing frequency at C4 */
 int volume; /*0-64 please*/
 int loop_start,loop_length,loop_endi; /* loop_endi==0 EQU no loop */
 unsigned char *data;  /* SB only */
 unsigned int gus_data; /* GUS only */
 int pan; /*0-256 please; 0 left, 256 right*/
 int offset; /* start playing at this offset */
 unsigned short flags; /*not really used yet.*/
} samrec;
samrec samples[max_samples]; /* */

typedef struct
{
 volatile int playing; /*0 no; 1 yes*/
 volatile unsigned long long position; /* fixed point */
 int sample;
 int freq; /* playing speed in hz */
 int volume;  /* 0-64 please */
 int pan; /* 0-256 please */
} channelinforec;
channelinforec channel[33];
/* end of device structures */

/* player structures : */
typedef struct /* this is probably not the best solution */
{
 int notecut_ontick;
 int portanote_portaspeed,portanote_notetoportato,portanote_period;
 signed int volumeslide_add;
 int arpeggio_note,arpeggio_xfine,arpeggio_yfine;
 signed int porta_add;
 signed int vibrato_speed,vibrato_depth,vibrato_vibepos;
 int tremolo_speed,tremolo_depth,tremolo_vibepos;
 int retrignote_ontick,retrignote_sample;
 char s3m_vslide_para,s3m_porta_down;
 char tremor_count,tremor_para;
 char retrig_para;
} modplay_effectrec; /* parameters for some effects. */

typedef struct
{
 int lastinstru;
 int lastnote;
 signed int period;
 int whicheffect;
 int vslide;
 int pattern_loop_row,pattern_loop_loop;
 int lastsampleoffset;
 int volume;
 int pan;
 modplay_effectrec effect;

 int note;
 int effy;
 int instru;

} channarec; /* module player's channel structure */
channarec channa[33];

struct
{
 _go32_dpmi_seginfo _info,vanha;
 volatile iso call_me; /* the old int 8 handler */
 volatile unsigned int kelloja;
 volatile unsigned int timspeed,counter;
} kello; /* for the timer system */

struct
{
 int tremolo; /* tremolo waveform */
 int retrigtre; /*0 no, 1 yes*/
 int vibrato; /* vibrato waveform */
 int retrigvib; /*0 no, 1 yes*/
} waveform;

#define MOD 100
#define S3M 101

typedef struct
{
 unsigned char length;
 unsigned char patterns; //number of patterns.
 unsigned char order[257]; //lotsa lotsa.
 unsigned char *pattern[256]; //lotsa lotsa lotsa. lotsa.
 unsigned int speed; //initial speed
 unsigned int bpm; //initial tempo
} songrec; //this is, er, not too small, is it?

unsigned int finetunes[16]=
 {
  8363,8413,8463,8529,8581,8651,8723,8757,
  7895,7941,7985,8046,8107,8169,8232,8280
 };

unsigned int periods[132]=
{
27392,25856,24384,23040,21696,20480,19328,18240,17216,16256,15360,14496,
13696,12928,12192,11520,10848,10240, 9664, 9120, 8608, 8128, 7680, 7248,
 6848, 6464, 6096, 5760, 5424, 5120, 4832, 4560, 4304, 4064, 3840, 3624,
 3424, 3232, 3048, 2880, 2712, 2560, 2416, 2280, 2152, 2032, 1920, 1812,
 1712, 1616, 1524, 1440, 1356, 1280, 1208, 1140, 1076, 1016,  960,  906,
  856,  808,  762,  720,  678,  640,  604,  570,  538,  508,  480,  453,
  428,  404,  381,  360,  339,  320,  302,  285,  269,  254,  240,  226,
  214,  202,  190,  180,  170,  160,  151,  143,  135,  127,  120,  113,
  107,  101,   95,   90,   85,   80,   75,   71,   67,   63,   60,   56,
   53,   50,   47,   45,   42,   40,   37,   35,   33,   31,   30,   28,
   26,   25,   23,   22,   21,   20,   18,   17,   16,   15,   15,   14
}; /*"imported" from fmoddoc2.*/

unsigned int totalsamples; /* bytes */
songrec song;

/* end of structs.h */
#endif
