#ifndef _hmod_hmodxtra_h
#define _hmod_hmodxtra_h
/* hmodxtra.h */

#include "mod_det.h" /* check_mk() */

signed int file_type(char *file_name)
/*
OUT: -3 file not found
     -2 file format is none of the following
     +5 .mod-format file
     +6 .s3m-format file
*/
{
 FILE *f;
 char sig[5];
 f=fopen(file_name,"rb");
 if (f==NULL) return -3;
 if (filelength(fileno(f))<48) {fclose(f); return -2;}
 fseek(f,44+module.file_offset,SEEK_SET);
 memset(sig,0,5);
 fread(&sig,1,4,f); sig[4]=0;
 if (strcmp(sig,"SCRM")==0) { fclose(f); return 6; }
 if (filelength(fileno(f))<1084) {fclose(f); return -2;}
 fseek(f,1080+module.file_offset,SEEK_SET);
 memset(sig,0,5);
 fread(&sig,1,4,f); sig[4]=0;
 if (check_mk(f,0)==0) { fclose(f); return 5; }
 fclose(f);
 return -2;
}

int __load_MOD_or_S3M(char *fn)
{ /* OUT: 0 ok, -1 error */
 int ii;
 char nimi[256];
 strcpy(nimi,fn);
 ii=file_type(nimi);
 if (ii==-3) /* file not found, assume that the extension is missing */
  {
   strcat(nimi,".MOD");
   ii=file_type(nimi);
  }
 if (ii==-3) /* file still not found, so the extension must be .S3M */
  {
   strcpy(nimi,fn);
   strcat(nimi,".S3M");
   ii=file_type(nimi);
  }

 switch (ii)
  {
   case 5:
#ifdef _hmod_mod_h
    ii=load_mod(nimi);
#else
    ii=-4;
#endif
    break;

   case 6:
#ifdef _hmod_s3m_h
    ii=load_s3m(nimi);
#else
    ii=-5;
#endif
    break;
   default: break;
  }

/* printf("ii=%d\n",ii); */
 if (ii<0)
  {
   switch (ii)
   {
    case -1:strcat(error,"unable to load module.\n"); break;
    case -2:strcat(error,"unknown file format.\n"); break;
    case -3:strcat(error,"file not found.\n"); break;
    case -4:strcat(error,"loader for this format (MOD) missing.\n"); break;
    case -5:strcat(error,"loader for this format (S3M) missing.\n"); break;
    default:strcat(error,"unknown error.\n"); break;
   }
   return -1;
  }

 return 0;
}

/* end of hmodxtra.h */
#endif
