#ifndef _hmod_gupload_h
#define _hmod_gupload_h
/* gupload.h */

struct
{
 unsigned long long gup_pos; /* upload position */
 unsigned long long total; /* total amount of bytes to be loaded. for crunching */
} gpoke;

unsigned int guppoke(unsigned int gus_pos,signed char *buf,unsigned int count,unsigned char ssigned)
{
 gus.usedmem+=count;
 if (gus.usedmem>=gus.totalmem)
 {
  strcat(error,"gupload: out of GUS memory.\n");
  return -1;
 }
 do {
  guspoke(gus_pos++,*(buf++)^ssigned^0x80);
 } while (--count);
 return 0;
}

signed char __2pintrplt(signed char oo1,signed char oo2,unsigned long long wei)
{
 signed long long o1=(signed long long)oo1,o2=(signed long long)oo2,retu,we;
 wei&=0xFFFF0000;
 we=(signed)((unsigned)wei>>16);
 retu=( o2*we + o1*(0xFFFF-we) );
 retu/=0xFFFF;
 if (retu<-128) retu=-128; else if (retu>127) retu=127;
 return (signed char)retu;
}

unsigned int guppoke_crunch(unsigned int gus_pos,signed char *buf,unsigned int count,unsigned char ssigned)
{
 unsigned long long gup_step=((unsigned long long)gpoke.total<<32)/gus.totalmem;

/*
 count=((unsigned long long)count*(unsigned long long)gus.totalmem)/gpoke.total;

 gus.usedmem+=count;
 if (gus.usedmem>=gus.totalmem)
 {
  strcat(error,"cgupload: out of GUS memory!\n");
  return -1;
 }
*/

 gpoke.gup_pos&=0xFFFFFFFF; /* only the decimal part */

// while (count--) {
 while ( ((gpoke.gup_pos>>32)<count) && (gus.usedmem<gus.totalmem) ) {

  guspoke( gus_pos++, /* poke a byte to gus mem */
           __2pintrplt(buf[(gpoke.gup_pos>>32)]^ssigned^0x80,
                       buf[(gpoke.gup_pos>>32)+1]^ssigned^0x80,
                       gpoke.gup_pos) );

  gpoke.gup_pos+=gup_step; /* increase 32.32 fixp. source pointer */
  gus.usedmem++;

 };

 if (gus.usedmem>=gus.totalmem)
 {
  strcat(error,"cgupload: out of GUS memory!\n");
  return -1;
 }

 return gus_pos;
}

/* end of gupload.h */
#endif
